/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.function.Function;
import net.elytrium.limboapi.api.file.BuiltInWorldFileType;
import net.elytrium.limboapi.api.file.WorldFile;
import net.elytrium.limboapi.file.MCEditSchematicFile;
import net.elytrium.limboapi.file.StructureNbtFile;
import net.elytrium.limboapi.file.WorldEditSchemFile;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.CompoundBinaryTag;

public enum WorldFileTypeRegistry {
    SCHEMATIC(BuiltInWorldFileType.SCHEMATIC, MCEditSchematicFile::new),
    WORLDEDIT_SCHEM(BuiltInWorldFileType.WORLDEDIT_SCHEM, WorldEditSchemFile::new),
    STRUCTURE(BuiltInWorldFileType.STRUCTURE, StructureNbtFile::new);

    private static final EnumMap<BuiltInWorldFileType, WorldFileTypeRegistry> API_TYPE_MAP;
    private final BuiltInWorldFileType apiType;
    private final Function<CompoundBinaryTag, WorldFile> worldFileFunction;

    private WorldFileTypeRegistry(BuiltInWorldFileType apiType, Function<CompoundBinaryTag, WorldFile> worldFileFunction) {
        this.apiType = apiType;
        this.worldFileFunction = worldFileFunction;
    }

    public static WorldFileTypeRegistry fromApiType(BuiltInWorldFileType apiType) {
        return API_TYPE_MAP.get((Object)apiType);
    }

    public static WorldFile fromApiType(BuiltInWorldFileType apiType, Path file) throws IOException {
        return WorldFileTypeRegistry.fromApiType(apiType).fromNbt(file);
    }

    public static WorldFile fromApiType(BuiltInWorldFileType apiType, InputStream stream) throws IOException {
        return WorldFileTypeRegistry.fromApiType(apiType).fromNbt(stream);
    }

    public static WorldFile fromApiType(BuiltInWorldFileType apiType, CompoundBinaryTag tag) {
        return WorldFileTypeRegistry.fromApiType(apiType).fromNbt(tag);
    }

    public WorldFile fromNbt(Path file) throws IOException {
        return this.fromNbt(BinaryTagIO.unlimitedReader().read(file, BinaryTagIO.Compression.GZIP));
    }

    public WorldFile fromNbt(InputStream stream) throws IOException {
        return this.fromNbt(BinaryTagIO.unlimitedReader().read(stream, BinaryTagIO.Compression.GZIP));
    }

    public WorldFile fromNbt(CompoundBinaryTag tag) {
        return this.worldFileFunction.apply(tag);
    }

    static {
        API_TYPE_MAP = new EnumMap(BuiltInWorldFileType.class);
        for (WorldFileTypeRegistry pluginType : WorldFileTypeRegistry.values()) {
            API_TYPE_MAP.put(pluginType.apiType, pluginType);
        }
    }
}

