/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.injection.login;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.network.HandshakeIntent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.api.proxy.player.TabList;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.api.util.UuidUtils;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.util.Natives;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PlayerInfoForwarding;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.client.AuthSessionHandler;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.client.InitialInboundConnection;
import com.velocitypowered.proxy.connection.client.LoginInboundConnection;
import com.velocitypowered.proxy.crypto.IdentifiedKeyImpl;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.VelocityConnectionEvent;
import com.velocitypowered.proxy.protocol.netty.MinecraftCompressorAndLengthEncoder;
import com.velocitypowered.proxy.protocol.packet.ServerLoginSuccessPacket;
import com.velocitypowered.proxy.protocol.packet.SetCompressionPacket;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import net.elytrium.commons.utils.reflection.ReflectionException;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.Settings;
import net.elytrium.limboapi.api.event.LoginLimboRegisterEvent;
import net.elytrium.limboapi.injection.dummy.ClosedChannel;
import net.elytrium.limboapi.injection.dummy.ClosedMinecraftConnection;
import net.elytrium.limboapi.injection.dummy.DummyEventPool;
import net.elytrium.limboapi.injection.login.LoginTasksQueue;
import net.elytrium.limboapi.injection.login.confirmation.LoginConfirmHandler;
import net.elytrium.limboapi.injection.packet.ServerLoginSuccessHook;
import net.elytrium.limboapi.injection.tablist.RewritingKeyedVelocityTabList;
import net.elytrium.limboapi.injection.tablist.RewritingVelocityTabList;
import net.elytrium.limboapi.injection.tablist.RewritingVelocityTabListLegacy;
import net.elytrium.limboapi.utils.LambdaUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class LoginListener {
    private static final ClosedMinecraftConnection CLOSED_MINECRAFT_CONNECTION = new ClosedMinecraftConnection(new ClosedChannel(new DummyEventPool()), null);
    private static final MethodHandle DELEGATE_FIELD;
    private static final BiConsumer<Object, MinecraftConnection> MC_CONNECTION_SETTER;
    private static final MethodHandle CONNECTED_PLAYER_CONSTRUCTOR;
    private static final MethodHandle SPAWNED_FIELD;
    private static final BiConsumer<ConnectedPlayer, TabList> TAB_LIST_SETTER;
    private final LimboAPI plugin;
    private final VelocityServer server;

    public LoginListener(LimboAPI plugin, VelocityServer server) {
        this.plugin = plugin;
        this.server = server;
    }

    @Subscribe
    public void hookInitialServer(PlayerChooseInitialServerEvent event) {
        if (this.plugin.hasNextServer(event.getPlayer())) {
            event.setInitialServer(this.plugin.getNextServer(event.getPlayer()));
        }
        this.plugin.setLimboJoined(event.getPlayer());
    }

    public void hookLoginSession(GameProfileRequestEvent event) throws Throwable {
        LoginInboundConnection inboundConnection = (LoginInboundConnection)event.getConnection();
        if (LoginInboundConnection.class.isAssignableFrom(inboundConnection.getClass())) {
            InitialInboundConnection inbound = DELEGATE_FIELD.invokeExact(inboundConnection);
            MinecraftConnection connection = inbound.getConnection();
            if (!connection.eventLoop().inEventLoop()) {
                connection.eventLoop().execute(() -> {
                    try {
                        this.hookLoginSession(event);
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("failed to handle login request", e);
                    }
                });
                return;
            }
            MinecraftSessionHandler handler = connection.getActiveSessionHandler();
            MC_CONNECTION_SETTER.accept(handler, CLOSED_MINECRAFT_CONNECTION);
            LoginConfirmHandler loginHandler = null;
            if (connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) >= 0) {
                loginHandler = new LoginConfirmHandler(this.plugin, connection);
                connection.setActiveSessionHandler(StateRegistry.LOGIN, (MinecraftSessionHandler)loginHandler);
            }
            if (!connection.isClosed()) {
                try {
                    IdentifiedKey playerKey = inboundConnection.getIdentifiedKey();
                    if (playerKey != null) {
                        if (playerKey.getSignatureHolder() == null) {
                            IdentifiedKeyImpl unlinkedKey;
                            if (playerKey instanceof IdentifiedKeyImpl && !(unlinkedKey = (IdentifiedKeyImpl)playerKey).internalAddHolder(event.getGameProfile().getId())) {
                                playerKey = null;
                            }
                        } else if (!Objects.equals(playerKey.getSignatureHolder(), event.getGameProfile().getId())) {
                            playerKey = null;
                        }
                    }
                    ConnectedPlayer player = CONNECTED_PLAYER_CONSTRUCTOR.invokeExact(this.server, event.getGameProfile(), connection, inboundConnection.getVirtualHost().orElse(null), inboundConnection.getRawVirtualHost().orElse(null), event.isOnlineMode(), inboundConnection.getHandshakeIntent(), playerKey);
                    if (connection.getProtocolVersion().noLessThan((Object)ProtocolVersion.MINECRAFT_1_19_3)) {
                        TAB_LIST_SETTER.accept(player, (TabList)new RewritingVelocityTabList(player));
                    } else if (connection.getProtocolVersion().noLessThan((Object)ProtocolVersion.MINECRAFT_1_8)) {
                        TAB_LIST_SETTER.accept(player, (TabList)new RewritingKeyedVelocityTabList(player, (ProxyServer)this.server));
                    } else {
                        TAB_LIST_SETTER.accept(player, (TabList)new RewritingVelocityTabListLegacy(player, (ProxyServer)this.server));
                    }
                    if (connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) >= 0) {
                        loginHandler.setPlayer(player);
                    }
                    if (this.server.canRegisterConnection(player)) {
                        if (!connection.isClosed()) {
                            boolean compressionEnabled;
                            int threshold = this.server.getConfiguration().getCompressionThreshold();
                            ChannelPipeline pipeline = connection.getChannel().pipeline();
                            boolean bl = compressionEnabled = threshold >= 0 && connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) >= 0;
                            if (compressionEnabled) {
                                connection.write((Object)new SetCompressionPacket(threshold));
                                this.plugin.fixDecompressor(pipeline, threshold, true);
                                if (!Settings.IMP.MAIN.COMPATIBILITY_MODE) {
                                    pipeline.addFirst("compression-encoder", (ChannelHandler)new ChannelOutboundHandlerAdapter());
                                } else {
                                    int level = this.server.getConfiguration().getCompressionLevel();
                                    VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(level);
                                    pipeline.addBefore("minecraft-encoder", "compression-encoder", (ChannelHandler)new MinecraftCompressorAndLengthEncoder(threshold, compressor));
                                    pipeline.remove("frame-encoder");
                                }
                            }
                            if (!Settings.IMP.MAIN.COMPATIBILITY_MODE) {
                                pipeline.remove("frame-encoder");
                            }
                            this.plugin.inject3rdParty((Player)player, connection, pipeline);
                            if (compressionEnabled) {
                                pipeline.fireUserEventTriggered((Object)VelocityConnectionEvent.COMPRESSION_ENABLED);
                            } else {
                                pipeline.fireUserEventTriggered((Object)VelocityConnectionEvent.COMPRESSION_DISABLED);
                            }
                            VelocityConfiguration configuration = this.server.getConfiguration();
                            UUID playerUniqueID = player.getUniqueId();
                            if (configuration.getPlayerInfoForwardingMode() == PlayerInfoForwarding.NONE) {
                                playerUniqueID = UuidUtils.generateOfflinePlayerUuid((String)player.getUsername());
                            }
                            ServerLoginSuccessPacket success = new ServerLoginSuccessPacket();
                            success.setUsername(player.getUsername());
                            success.setProperties(player.getGameProfileProperties());
                            success.setUuid(playerUniqueID);
                            if (Settings.IMP.MAIN.COMPATIBILITY_MODE) {
                                connection.write((Object)success);
                            } else {
                                ServerLoginSuccessHook successHook = new ServerLoginSuccessHook();
                                successHook.setUsername(player.getUsername());
                                successHook.setProperties(player.getGameProfileProperties());
                                successHook.setUuid(playerUniqueID);
                                connection.write((Object)successHook);
                                ChannelHandler compressionHandler = pipeline.get("compression-encoder");
                                if (compressionHandler != null) {
                                    connection.write((Object)this.plugin.encodeSingleLogin((MinecraftPacket)success, connection.getProtocolVersion()));
                                } else {
                                    ChannelHandler frameHandler = pipeline.get("frame-encoder");
                                    if (frameHandler != null) {
                                        pipeline.remove(frameHandler);
                                    }
                                    connection.write((Object)this.plugin.encodeSingleLoginUncompressed((MinecraftPacket)success, connection.getProtocolVersion()));
                                }
                            }
                            this.plugin.setInitialID((Player)player, playerUniqueID);
                            if (connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) >= 0) {
                                loginHandler.thenRun(() -> this.fireRegisterEvent(player, connection, inbound, handler));
                            } else {
                                connection.setState(StateRegistry.PLAY);
                                this.fireRegisterEvent(player, connection, inbound, handler);
                            }
                        }
                    } else {
                        player.disconnect0((Component)Component.translatable((String)"velocity.error.already-connected-proxy", (TextColor)NamedTextColor.RED), true);
                    }
                }
                catch (Throwable e) {
                    throw new ReflectionException(e);
                }
            }
        }
    }

    private void fireRegisterEvent(ConnectedPlayer player, MinecraftConnection connection, InitialInboundConnection inbound, Object handler) {
        ((CompletableFuture)this.server.getEventManager().fire((Object)new LoginLimboRegisterEvent((Player)player)).thenAcceptAsync(limboRegisterEvent -> {
            LoginTasksQueue queue = new LoginTasksQueue(this.plugin, handler, this.server, player, (InboundConnection)inbound, limboRegisterEvent.getOnJoinCallbacks());
            this.plugin.addLoginQueue((Player)player, queue);
            this.plugin.setKickCallback((Player)player, limboRegisterEvent.getOnKickCallback());
            queue.next();
        }, (Executor)connection.eventLoop())).exceptionally(t -> {
            LimboAPI.getLogger().error("Exception while registering LimboAPI login handlers for {}.", (Object)player, t);
            return null;
        });
    }

    @Subscribe
    public void hookPlaySession(ServerConnectedEvent event) {
        ConnectedPlayer player = (ConnectedPlayer)event.getPlayer();
        MinecraftConnection connection = player.getConnection();
        if (connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) >= 0) {
            return;
        }
        connection.eventLoop().execute(() -> {
            if (!(connection.getActiveSessionHandler() instanceof ClientPlaySessionHandler)) {
                try {
                    ClientPlaySessionHandler playHandler = new ClientPlaySessionHandler(this.server, player);
                    SPAWNED_FIELD.invokeExact(playHandler, this.plugin.isLimboJoined((Player)player));
                    connection.setActiveSessionHandler(connection.getState(), (MinecraftSessionHandler)playHandler);
                }
                catch (Throwable e) {
                    throw new ReflectionException(e);
                }
            }
        });
    }

    static {
        try {
            CONNECTED_PLAYER_CONSTRUCTOR = MethodHandles.privateLookupIn(ConnectedPlayer.class, MethodHandles.lookup()).findConstructor(ConnectedPlayer.class, MethodType.methodType(Void.TYPE, VelocityServer.class, GameProfile.class, MinecraftConnection.class, InetSocketAddress.class, String.class, Boolean.TYPE, HandshakeIntent.class, IdentifiedKey.class));
            DELEGATE_FIELD = MethodHandles.privateLookupIn(LoginInboundConnection.class, MethodHandles.lookup()).findGetter(LoginInboundConnection.class, "delegate", InitialInboundConnection.class);
            Field mcConnectionField = AuthSessionHandler.class.getDeclaredField("mcConnection");
            mcConnectionField.setAccessible(true);
            MC_CONNECTION_SETTER = LambdaUtil.setterOf(mcConnectionField);
            SPAWNED_FIELD = MethodHandles.privateLookupIn(ClientPlaySessionHandler.class, MethodHandles.lookup()).findSetter(ClientPlaySessionHandler.class, "spawned", Boolean.TYPE);
            Field tabListField = ConnectedPlayer.class.getDeclaredField("tabList");
            tabListField.setAccessible(true);
            TAB_LIST_SETTER = LambdaUtil.setterOf(tabListField);
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }
}

