/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.injection.login;

import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.permission.PermissionsSetupEvent;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.event.player.PlayerClientBrandEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.permission.PermissionFunction;
import com.velocitypowered.api.permission.PermissionProvider;
import com.velocitypowered.api.permission.PermissionSubject;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftConnectionAssociation;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.client.AuthSessionHandler;
import com.velocitypowered.proxy.connection.client.ClientConfigSessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.client.InitialConnectSessionHandler;
import com.velocitypowered.proxy.event.VelocityEventManager;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.LegacyPlayerListItemPacket;
import com.velocitypowered.proxy.protocol.packet.UpsertPlayerInfoPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import net.elytrium.commons.utils.reflection.ReflectionException;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.injection.login.confirmation.LoginConfirmHandler;
import net.elytrium.limboapi.server.LimboSessionHandlerImpl;
import net.elytrium.limboapi.utils.LambdaUtil;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;

public class LoginTasksQueue {
    private static final MethodHandle PROFILE_FIELD;
    private static final PermissionProvider DEFAULT_PERMISSIONS;
    private static final MethodHandle SET_PERMISSION_FUNCTION_METHOD;
    private static final MethodHandle INITIAL_CONNECT_SESSION_HANDLER_CONSTRUCTOR;
    private static final BiConsumer<Object, MinecraftConnection> MC_CONNECTION_SETTER;
    private static final MethodHandle CONNECT_TO_INITIAL_SERVER_METHOD;
    private static final MethodHandle SET_CLIENT_BRAND;
    public static final BiConsumer<ClientConfigSessionHandler, String> BRAND_CHANNEL_SETTER;
    private final LimboAPI plugin;
    private final Object handler;
    private final VelocityServer server;
    private final ConnectedPlayer player;
    private final InboundConnection inbound;
    private final Queue<Runnable> queue;

    public LoginTasksQueue(LimboAPI plugin, Object handler, VelocityServer server, ConnectedPlayer player, InboundConnection inbound, Queue<Runnable> queue) {
        this.plugin = plugin;
        this.handler = handler;
        this.server = server;
        this.player = player;
        this.inbound = inbound;
        this.queue = queue;
    }

    public void next() {
        MinecraftConnection connection = this.player.getConnection();
        if (connection.getChannel().isActive()) {
            EventLoop eventLoop = connection.eventLoop();
            if (this.queue.isEmpty()) {
                eventLoop.execute(this::finish);
            } else {
                eventLoop.execute(Objects.requireNonNull(this.queue.poll()));
            }
        }
    }

    private void finish() {
        this.plugin.removeLoginQueue((Player)this.player);
        VelocityEventManager eventManager = this.server.getEventManager();
        MinecraftConnection connection = this.player.getConnection();
        Logger logger = LimboAPI.getLogger();
        this.plugin.getEventManagerHook().proceedProfile(this.player.getGameProfile());
        eventManager.fire((Object)new GameProfileRequestEvent(this.inbound, this.player.getGameProfile(), this.player.isOnlineMode())).thenAcceptAsync(arg_0 -> this.lambda$finish$1(connection, (EventManager)eventManager, logger, arg_0), (Executor)connection.eventLoop());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void initialize(MinecraftConnection connection) throws Throwable {
        connection.setAssociation((MinecraftConnectionAssociation)this.player);
        if (connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) < 0 || connection.getState() != StateRegistry.CONFIG) {
            this.plugin.setState(connection, StateRegistry.PLAY);
        }
        ChannelPipeline pipeline = connection.getChannel().pipeline();
        this.plugin.deject3rdParty(pipeline);
        if (pipeline.get("frame-encoder") == null) {
            this.plugin.fixCompressor(pipeline, connection.getProtocolVersion());
        }
        Logger logger = LimboAPI.getLogger();
        ((CompletableFuture)this.server.getEventManager().fire((Object)new LoginEvent((Player)this.player)).thenAcceptAsync(event -> {
            if (connection.isClosed()) {
                this.server.getEventManager().fireAndForget((Object)new DisconnectEvent((Player)this.player, DisconnectEvent.LoginStatus.CANCELLED_BY_USER_BEFORE_COMPLETE));
            } else {
                Optional reason = event.getResult().getReasonComponent();
                if (reason.isPresent()) {
                    this.player.disconnect0((Component)reason.get(), false);
                } else if (this.server.registerConnection(this.player)) {
                    MinecraftSessionHandler patt0$temp = connection.getActiveSessionHandler();
                    if (patt0$temp instanceof LoginConfirmHandler) {
                        LoginConfirmHandler confirm = (LoginConfirmHandler)patt0$temp;
                        confirm.waitForConfirmation(() -> this.connectToServer(logger, this.player, connection));
                    } else {
                        this.connectToServer(logger, this.player, connection);
                    }
                } else {
                    this.player.disconnect0((Component)Component.translatable((String)"velocity.error.already-connected-proxy"), false);
                }
            }
        }, (Executor)connection.eventLoop())).exceptionally(t -> {
            logger.error("Exception while completing login initialisation phase for {}", (Object)this.player, t);
            return null;
        });
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void connectToServer(Logger logger, ConnectedPlayer player, MinecraftConnection connection) {
        if (connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) < 0) {
            try {
                connection.setActiveSessionHandler(connection.getState(), (MinecraftSessionHandler)INITIAL_CONNECT_SESSION_HANDLER_CONSTRUCTOR.invokeExact(this.player, this.server));
            }
            catch (Throwable e) {
                throw new ReflectionException(e);
            }
        }
        if (connection.getState() == StateRegistry.PLAY) {
            ((LimboSessionHandlerImpl)connection.getActiveSessionHandler()).disconnectToConfig(() -> this.connectToServer(logger, player, connection));
            return;
        }
        ClientConfigSessionHandler configHandler = new ClientConfigSessionHandler(this.server, this.player);
        MinecraftSessionHandler minecraftSessionHandler = connection.getActiveSessionHandler();
        if (minecraftSessionHandler instanceof LimboSessionHandlerImpl) {
            LimboSessionHandlerImpl sessionHandler = (LimboSessionHandlerImpl)minecraftSessionHandler;
            if (sessionHandler.getSettings() != null) {
                this.player.setClientSettings(sessionHandler.getSettings());
            }
            if (sessionHandler.getBrand() != null) {
                try {
                    this.server.getEventManager().fireAndForget((Object)new PlayerClientBrandEvent((Player)this.player, sessionHandler.getBrand()));
                    SET_CLIENT_BRAND.invokeExact(this.player, sessionHandler.getBrand());
                    BRAND_CHANNEL_SETTER.accept(configHandler, "minecraft:brand");
                }
                catch (Throwable e) {
                    throw new ReflectionException(e);
                }
            }
        }
        this.plugin.setActiveSessionHandler(connection, StateRegistry.CONFIG, (MinecraftSessionHandler)configHandler);
        this.server.getEventManager().fire((Object)new PostLoginEvent((Player)this.player)).thenAccept(postLoginEvent -> {
            try {
                MC_CONNECTION_SETTER.accept(this.handler, connection);
                CONNECT_TO_INITIAL_SERVER_METHOD.invoke((AuthSessionHandler)this.handler, this.player);
            }
            catch (Throwable e) {
                throw new ReflectionException(e);
            }
        });
    }

    private /* synthetic */ void lambda$finish$1(MinecraftConnection connection, EventManager eventManager, Logger logger, GameProfileRequestEvent gameProfile) {
        try {
            UUID uuid = this.plugin.getInitialID((Player)this.player);
            if (connection.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_19_1) <= 0) {
                connection.delayedWrite((Object)new LegacyPlayerListItemPacket(4, List.of(new LegacyPlayerListItemPacket.Item(uuid))));
                connection.delayedWrite((Object)new LegacyPlayerListItemPacket(0, List.of(new LegacyPlayerListItemPacket.Item(uuid).setName(gameProfile.getUsername()).setProperties(gameProfile.getGameProfile().getProperties()))));
            } else if (connection.getState() != StateRegistry.CONFIG) {
                UpsertPlayerInfoPacket.Entry playerInfoEntry = new UpsertPlayerInfoPacket.Entry(uuid);
                playerInfoEntry.setDisplayName(new ComponentHolder(this.player.getProtocolVersion(), (Component)Component.text((String)gameProfile.getUsername())));
                playerInfoEntry.setProfile(gameProfile.getGameProfile());
                connection.delayedWrite((Object)new UpsertPlayerInfoPacket(EnumSet.of(UpsertPlayerInfoPacket.Action.UPDATE_DISPLAY_NAME, UpsertPlayerInfoPacket.Action.ADD_PLAYER), List.of(playerInfoEntry)));
            }
            PROFILE_FIELD.invokeExact(this.player, gameProfile.getGameProfile());
            eventManager.fire((Object)new PermissionsSetupEvent((PermissionSubject)this.player, DEFAULT_PERMISSIONS)).thenAcceptAsync(event -> {
                if (!connection.isClosed()) {
                    PermissionFunction function = event.createFunction((PermissionSubject)this.player);
                    if (function == null) {
                        logger.error("A plugin permission provider {} provided an invalid permission function for player {}. This is a bug in the plugin, not in Velocity. Falling back to the default permission function.", (Object)event.getProvider().getClass().getName(), (Object)this.player.getUsername());
                    } else {
                        try {
                            SET_PERMISSION_FUNCTION_METHOD.invokeExact(this.player, function);
                        }
                        catch (Throwable ex) {
                            logger.error("Exception while completing injection to {}", (Object)this.player, (Object)ex);
                        }
                    }
                    try {
                        this.initialize(connection);
                    }
                    catch (Throwable e) {
                        throw new ReflectionException(e);
                    }
                }
            }, (Executor)connection.eventLoop());
        }
        catch (Throwable e) {
            logger.error("Exception while completing injection to {}", (Object)this.player, (Object)e);
        }
    }

    static {
        try {
            PROFILE_FIELD = MethodHandles.privateLookupIn(ConnectedPlayer.class, MethodHandles.lookup()).findSetter(ConnectedPlayer.class, "profile", GameProfile.class);
            Field defaultPermissionsField = ConnectedPlayer.class.getDeclaredField("DEFAULT_PERMISSIONS");
            defaultPermissionsField.setAccessible(true);
            DEFAULT_PERMISSIONS = (PermissionProvider)defaultPermissionsField.get(null);
            SET_PERMISSION_FUNCTION_METHOD = MethodHandles.privateLookupIn(ConnectedPlayer.class, MethodHandles.lookup()).findVirtual(ConnectedPlayer.class, "setPermissionFunction", MethodType.methodType(Void.TYPE, PermissionFunction.class));
            INITIAL_CONNECT_SESSION_HANDLER_CONSTRUCTOR = MethodHandles.privateLookupIn(InitialConnectSessionHandler.class, MethodHandles.lookup()).findConstructor(InitialConnectSessionHandler.class, MethodType.methodType(Void.TYPE, ConnectedPlayer.class, VelocityServer.class));
            CONNECT_TO_INITIAL_SERVER_METHOD = MethodHandles.privateLookupIn(AuthSessionHandler.class, MethodHandles.lookup()).findVirtual(AuthSessionHandler.class, "connectToInitialServer", MethodType.methodType(CompletableFuture.class, ConnectedPlayer.class));
            Field mcConnectionField = AuthSessionHandler.class.getDeclaredField("mcConnection");
            mcConnectionField.setAccessible(true);
            MC_CONNECTION_SETTER = LambdaUtil.setterOf(mcConnectionField);
            SET_CLIENT_BRAND = MethodHandles.privateLookupIn(ConnectedPlayer.class, MethodHandles.lookup()).findVirtual(ConnectedPlayer.class, "setClientBrand", MethodType.methodType(Void.TYPE, String.class));
            Field brandChannelField = ClientConfigSessionHandler.class.getDeclaredField("brandChannel");
            brandChannelField.setAccessible(true);
            BRAND_CHANNEL_SETTER = LambdaUtil.setterOf(brandChannelField);
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }
}

