/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.injection.packet;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.netty.MinecraftCompressDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import net.elytrium.limboapi.Settings;
import net.elytrium.limboapi.injection.packet.LimboCompressDecoder;

public class MinecraftLimitedCompressDecoder
extends MinecraftCompressDecoder
implements LimboCompressDecoder {
    private final int threshold;
    private final VelocityCompressor compressor;
    private int uncompressedCap;

    public MinecraftLimitedCompressDecoder(int threshold, VelocityCompressor compressor) {
        super(threshold, compressor);
        this.uncompressedCap = Settings.IMP.MAIN.MAX_PACKET_LENGTH_TO_SUPPRESS_IT;
        this.threshold = threshold;
        this.compressor = compressor;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int claimedUncompressedSize = ProtocolUtils.readVarInt((ByteBuf)in);
        if (claimedUncompressedSize == 0) {
            out.add(in.retain());
        } else if (claimedUncompressedSize > Settings.IMP.MAIN.MAX_SINGLE_GENERIC_PACKET_LENGTH) {
            ctx.close();
        } else if (claimedUncompressedSize >= this.threshold && claimedUncompressedSize <= this.uncompressedCap) {
            ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (ByteBuf)in);
            ByteBuf uncompressed = MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (int)claimedUncompressedSize);
            try {
                this.compressor.inflate(compatibleIn, uncompressed, claimedUncompressedSize);
                out.add(uncompressed);
            }
            catch (Exception e) {
                uncompressed.release();
                throw e;
            }
            finally {
                compatibleIn.release();
            }
        }
    }

    public void setUncompressedCap(int uncompressedCap) {
        this.uncompressedCap = uncompressedCap;
    }
}

