/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.injection.tablist;

import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.tablist.VelocityTabList;
import com.velocitypowered.proxy.tablist.VelocityTabListEntry;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.elytrium.limboapi.injection.tablist.RewritingTabList;
import net.elytrium.limboapi.utils.LambdaUtil;

public class RewritingVelocityTabList
extends VelocityTabList
implements RewritingTabList {
    private static final Function<VelocityTabList, Map<UUID, VelocityTabListEntry>> ENTRIES_GETTER;
    private final ConnectedPlayer player;
    private final MinecraftConnection connection;
    private final Map<UUID, VelocityTabListEntry> entries;

    public RewritingVelocityTabList(ConnectedPlayer player) {
        super(player);
        try {
            this.player = player;
            this.connection = player.getConnection();
            this.entries = ENTRIES_GETTER.apply(this);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public void addEntry(TabListEntry entry) {
        super.addEntry(this.rewriteEntry(entry));
    }

    public Optional<TabListEntry> getEntry(UUID uuid) {
        return super.getEntry(this.rewriteUuid(uuid));
    }

    public boolean containsEntry(UUID uuid) {
        return super.containsEntry(this.rewriteUuid(uuid));
    }

    public Optional<TabListEntry> removeEntry(UUID uuid) {
        return super.removeEntry(this.rewriteUuid(uuid));
    }

    static {
        try {
            Field field = VelocityTabList.class.getDeclaredField("entries");
            field.setAccessible(true);
            ENTRIES_GETTER = LambdaUtil.getterOf(field);
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
    }
}

