/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.mcprotocollib;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.elytrium.limboapi.api.chunk.util.CompactStorage;

public class BitStorage19
implements CompactStorage {
    private final long[] data;
    private final int bitsPerEntry;
    private final int size;
    private final long maxEntryValue;

    public BitStorage19(int bitsPerEntry, int size) {
        this(bitsPerEntry, new long[(size * bitsPerEntry - 1 >> 6) + 1]);
    }

    public BitStorage19(int bitsPerEntry, long[] data) {
        if (bitsPerEntry < 4) {
            bitsPerEntry = 4;
        }
        this.bitsPerEntry = bitsPerEntry;
        this.data = data;
        this.size = (this.data.length << 6) / this.bitsPerEntry;
        this.maxEntryValue = (1L << this.bitsPerEntry) - 1L;
    }

    @Override
    public void set(int index, int value) {
        if (index < 0 || index > this.size - 1) {
            throw new IndexOutOfBoundsException();
        }
        if (value < 0 || (long)value > this.maxEntryValue) {
            throw new IllegalArgumentException("Value cannot be outside of accepted range.");
        }
        int bitIndex = index * this.bitsPerEntry;
        int startIndex = bitIndex >> 6;
        int endIndex = (index + 1) * this.bitsPerEntry - 1 >> 6;
        int startBitSubIndex = bitIndex & 0x3F;
        this.data[startIndex] = this.data[startIndex] & (this.maxEntryValue << startBitSubIndex ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.maxEntryValue) << startBitSubIndex;
        if (startIndex != endIndex) {
            int endBitSubIndex = 64 - startBitSubIndex;
            this.data[endIndex] = this.data[endIndex] >>> endBitSubIndex << endBitSubIndex | ((long)value & this.maxEntryValue) >> endBitSubIndex;
        }
    }

    @Override
    public int get(int index) {
        if (index < 0 || index > this.size - 1) {
            throw new IndexOutOfBoundsException();
        }
        int bitIndex = index * this.bitsPerEntry;
        int startIndex = bitIndex >> 6;
        int endIndex = (index + 1) * this.bitsPerEntry - 1 >> 6;
        int startBitSubIndex = bitIndex & 0x3F;
        if (startIndex == endIndex) {
            return (int)(this.data[startIndex] >>> startBitSubIndex & this.maxEntryValue);
        }
        int endBitSubIndex = 64 - startBitSubIndex;
        return (int)((this.data[startIndex] >>> startBitSubIndex | this.data[endIndex] << endBitSubIndex) & this.maxEntryValue);
    }

    @Override
    public void write(Object byteBufObject, ProtocolVersion version) {
        Preconditions.checkArgument((boolean)(byteBufObject instanceof ByteBuf));
        ByteBuf buf = (ByteBuf)byteBufObject;
        ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.data.length);
        for (long l : this.data) {
            buf.writeLong(l);
        }
    }

    @Override
    public int getBitsPerEntry() {
        return this.bitsPerEntry;
    }

    @Override
    public int getDataLength(ProtocolVersion version) {
        return ProtocolUtils.varIntBytes((int)this.data.length) + this.data.length * 8;
    }

    @Override
    public long[] getData() {
        return this.data;
    }

    @Override
    public CompactStorage copy() {
        return new BitStorage19(this.bitsPerEntry, Arrays.copyOf(this.data, this.data.length));
    }
}

