/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.StateRegistry;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.elytrium.commons.utils.reflection.ReflectionException;
import net.elytrium.limboapi.api.protocol.PacketDirection;
import net.elytrium.limboapi.api.protocol.packets.PacketMapping;
import net.elytrium.limboapi.api.utils.OverlayMap;
import net.elytrium.limboapi.protocol.packets.c2s.MoveOnGroundOnlyPacket;
import net.elytrium.limboapi.protocol.packets.c2s.MovePacket;
import net.elytrium.limboapi.protocol.packets.c2s.MovePositionOnlyPacket;
import net.elytrium.limboapi.protocol.packets.c2s.MoveRotationOnlyPacket;
import net.elytrium.limboapi.protocol.packets.c2s.PlayerChatSessionPacket;
import net.elytrium.limboapi.protocol.packets.c2s.TeleportConfirmPacket;
import net.elytrium.limboapi.protocol.packets.s2c.ChangeGameStatePacket;
import net.elytrium.limboapi.protocol.packets.s2c.ChunkDataPacket;
import net.elytrium.limboapi.protocol.packets.s2c.ChunkUnloadPacket;
import net.elytrium.limboapi.protocol.packets.s2c.DefaultSpawnPositionPacket;
import net.elytrium.limboapi.protocol.packets.s2c.MapDataPacket;
import net.elytrium.limboapi.protocol.packets.s2c.PlayerAbilitiesPacket;
import net.elytrium.limboapi.protocol.packets.s2c.PositionRotationPacket;
import net.elytrium.limboapi.protocol.packets.s2c.SetExperiencePacket;
import net.elytrium.limboapi.protocol.packets.s2c.SetSlotPacket;
import net.elytrium.limboapi.protocol.packets.s2c.TimeUpdatePacket;
import net.elytrium.limboapi.protocol.packets.s2c.UpdateTagsPacket;
import net.elytrium.limboapi.protocol.packets.s2c.UpdateViewPositionPacket;
import net.elytrium.limboapi.utils.OverlayIntObjectMap;
import net.elytrium.limboapi.utils.OverlayObject2IntMap;
import sun.misc.Unsafe;

public class LimboProtocol {
    private static final StateRegistry LIMBO_STATE_REGISTRY;
    private static final MethodHandle REGISTER_METHOD;
    private static final MethodHandle PACKET_MAPPING_CONSTRUCTOR;
    private static final Unsafe UNSAFE;
    public static final String READ_TIMEOUT = "limboapi-read-timeout";
    public static final MethodHandle VERSIONS_GETTER;
    public static final Field VERSIONS_FIELD;
    public static final MethodHandle PACKET_ID_TO_SUPPLIER_GETTER;
    public static final Field PACKET_ID_TO_SUPPLIER_FIELD;
    public static final MethodHandle PACKET_CLASS_TO_ID_GETTER;
    public static final Field PACKET_CLASS_TO_ID_FIELD;
    public static final StateRegistry.PacketRegistry PLAY_CLIENTBOUND_REGISTRY;
    public static final StateRegistry.PacketRegistry PLAY_SERVERBOUND_REGISTRY;
    public static final StateRegistry.PacketRegistry LIMBO_CLIENTBOUND_REGISTRY;
    public static final StateRegistry.PacketRegistry LIMBO_SERVERBOUND_REGISTRY;
    public static final MethodHandle SERVERBOUND_REGISTRY_GETTER;
    public static final MethodHandle CLIENTBOUND_REGISTRY_GETTER;

    private static void overlayRegistry(StateRegistry stateRegistry, String registryName, StateRegistry.PacketRegistry playRegistry) throws Throwable {
        StateRegistry.PacketRegistry registry = (StateRegistry.PacketRegistry)UNSAFE.allocateInstance(StateRegistry.PacketRegistry.class);
        Field directionField = StateRegistry.PacketRegistry.class.getDeclaredField("direction");
        directionField.setAccessible(true);
        directionField.set(registry, directionField.get(playRegistry));
        Field versionField = StateRegistry.PacketRegistry.ProtocolRegistry.class.getDeclaredField("version");
        versionField.setAccessible(true);
        Map playProtocolRegistryVersions = VERSIONS_GETTER.invokeExact(playRegistry);
        EnumMap<ProtocolVersion, StateRegistry.PacketRegistry.ProtocolRegistry> versions = new EnumMap<ProtocolVersion, StateRegistry.PacketRegistry.ProtocolRegistry>(ProtocolVersion.class);
        for (ProtocolVersion version : ProtocolVersion.values()) {
            if (version.isLegacy() || version.isUnknown()) continue;
            StateRegistry.PacketRegistry.ProtocolRegistry playProtoRegistry = (StateRegistry.PacketRegistry.ProtocolRegistry)playProtocolRegistryVersions.get(version);
            StateRegistry.PacketRegistry.ProtocolRegistry protoRegistry = (StateRegistry.PacketRegistry.ProtocolRegistry)UNSAFE.allocateInstance(StateRegistry.PacketRegistry.ProtocolRegistry.class);
            versionField.set(protoRegistry, version);
            IntObjectMap playPacketIDToSupplier = PACKET_ID_TO_SUPPLIER_GETTER.invokeExact(playProtoRegistry);
            PACKET_ID_TO_SUPPLIER_FIELD.set(protoRegistry, new OverlayIntObjectMap(playPacketIDToSupplier, new IntObjectHashMap(16, 0.5f)));
            Object2IntMap playPacketClassToID = PACKET_CLASS_TO_ID_GETTER.invokeExact(playProtoRegistry);
            Object2IntOpenHashMap packetClassToID = new Object2IntOpenHashMap(16, 0.5f);
            packetClassToID.defaultReturnValue(playPacketClassToID.defaultReturnValue());
            PACKET_CLASS_TO_ID_FIELD.set(protoRegistry, new OverlayObject2IntMap(playPacketClassToID, packetClassToID));
            versions.put(version, protoRegistry);
        }
        VERSIONS_FIELD.set(registry, Collections.unmodifiableMap(versions));
        Field fallbackField = StateRegistry.PacketRegistry.class.getDeclaredField("fallback");
        fallbackField.setAccessible(true);
        fallbackField.set(registry, false);
        Field registryField = StateRegistry.class.getDeclaredField(registryName);
        registryField.setAccessible(true);
        registryField.set(stateRegistry, registry);
    }

    public static void init() throws Throwable {
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, ChangeGameStatePacket.class, ChangeGameStatePacket::new, LimboProtocol.createMapping(43, ProtocolVersion.MINECRAFT_1_7_2, true), LimboProtocol.createMapping(30, ProtocolVersion.MINECRAFT_1_9, true), LimboProtocol.createMapping(32, ProtocolVersion.MINECRAFT_1_13, true), LimboProtocol.createMapping(30, ProtocolVersion.MINECRAFT_1_14, true), LimboProtocol.createMapping(31, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(30, ProtocolVersion.MINECRAFT_1_16, true), LimboProtocol.createMapping(29, ProtocolVersion.MINECRAFT_1_16_2, true), LimboProtocol.createMapping(30, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(27, ProtocolVersion.MINECRAFT_1_19, true), LimboProtocol.createMapping(29, ProtocolVersion.MINECRAFT_1_19_1, true), LimboProtocol.createMapping(28, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(31, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(32, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(34, ProtocolVersion.MINECRAFT_1_20_5, true), LimboProtocol.createMapping(35, ProtocolVersion.MINECRAFT_1_21_2, true), LimboProtocol.createMapping(34, ProtocolVersion.MINECRAFT_1_21_5, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, ChunkDataPacket.class, ChunkDataPacket::new, LimboProtocol.createMapping(33, ProtocolVersion.MINECRAFT_1_7_2, true), LimboProtocol.createMapping(32, ProtocolVersion.MINECRAFT_1_9, true), LimboProtocol.createMapping(34, ProtocolVersion.MINECRAFT_1_13, true), LimboProtocol.createMapping(33, ProtocolVersion.MINECRAFT_1_14, true), LimboProtocol.createMapping(34, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(33, ProtocolVersion.MINECRAFT_1_16, true), LimboProtocol.createMapping(32, ProtocolVersion.MINECRAFT_1_16_2, true), LimboProtocol.createMapping(34, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(31, ProtocolVersion.MINECRAFT_1_19, true), LimboProtocol.createMapping(33, ProtocolVersion.MINECRAFT_1_19_1, true), LimboProtocol.createMapping(32, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(36, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(37, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(39, ProtocolVersion.MINECRAFT_1_20_5, true), LimboProtocol.createMapping(40, ProtocolVersion.MINECRAFT_1_21_2, true), LimboProtocol.createMapping(39, ProtocolVersion.MINECRAFT_1_21_5, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, ChunkUnloadPacket.class, ChunkUnloadPacket::new, LimboProtocol.createMapping(33, ProtocolVersion.MINECRAFT_1_7_2, true), LimboProtocol.createMapping(29, ProtocolVersion.MINECRAFT_1_9, true), LimboProtocol.createMapping(31, ProtocolVersion.MINECRAFT_1_13, true), LimboProtocol.createMapping(29, ProtocolVersion.MINECRAFT_1_14, true), LimboProtocol.createMapping(30, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(29, ProtocolVersion.MINECRAFT_1_16, true), LimboProtocol.createMapping(28, ProtocolVersion.MINECRAFT_1_16_2, true), LimboProtocol.createMapping(29, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(26, ProtocolVersion.MINECRAFT_1_19, true), LimboProtocol.createMapping(28, ProtocolVersion.MINECRAFT_1_19_1, true), LimboProtocol.createMapping(27, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(30, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(31, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(33, ProtocolVersion.MINECRAFT_1_20_5, true), LimboProtocol.createMapping(34, ProtocolVersion.MINECRAFT_1_21_2, true), LimboProtocol.createMapping(33, ProtocolVersion.MINECRAFT_1_21_5, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, DefaultSpawnPositionPacket.class, DefaultSpawnPositionPacket::new, LimboProtocol.createMapping(5, ProtocolVersion.MINECRAFT_1_7_2, true), LimboProtocol.createMapping(67, ProtocolVersion.MINECRAFT_1_9, true), LimboProtocol.createMapping(69, ProtocolVersion.MINECRAFT_1_12, true), LimboProtocol.createMapping(70, ProtocolVersion.MINECRAFT_1_12_1, true), LimboProtocol.createMapping(73, ProtocolVersion.MINECRAFT_1_13, true), LimboProtocol.createMapping(77, ProtocolVersion.MINECRAFT_1_14, true), LimboProtocol.createMapping(78, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(66, ProtocolVersion.MINECRAFT_1_16, true), LimboProtocol.createMapping(75, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(74, ProtocolVersion.MINECRAFT_1_19, true), LimboProtocol.createMapping(77, ProtocolVersion.MINECRAFT_1_19_1, true), LimboProtocol.createMapping(76, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(80, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(82, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(84, ProtocolVersion.MINECRAFT_1_20_3, true), LimboProtocol.createMapping(86, ProtocolVersion.MINECRAFT_1_20_5, true), LimboProtocol.createMapping(91, ProtocolVersion.MINECRAFT_1_21_2, true), LimboProtocol.createMapping(90, ProtocolVersion.MINECRAFT_1_21_5, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, MapDataPacket.class, MapDataPacket::new, LimboProtocol.createMapping(52, ProtocolVersion.MINECRAFT_1_7_2, true), LimboProtocol.createMapping(36, ProtocolVersion.MINECRAFT_1_9, true), LimboProtocol.createMapping(38, ProtocolVersion.MINECRAFT_1_13, true), LimboProtocol.createMapping(39, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(38, ProtocolVersion.MINECRAFT_1_16, true), LimboProtocol.createMapping(37, ProtocolVersion.MINECRAFT_1_16_2, true), LimboProtocol.createMapping(39, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(36, ProtocolVersion.MINECRAFT_1_19, true), LimboProtocol.createMapping(38, ProtocolVersion.MINECRAFT_1_19_1, true), LimboProtocol.createMapping(37, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(41, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(42, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(44, ProtocolVersion.MINECRAFT_1_20_5, true), LimboProtocol.createMapping(45, ProtocolVersion.MINECRAFT_1_21_2, true), LimboProtocol.createMapping(44, ProtocolVersion.MINECRAFT_1_21_5, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, PlayerAbilitiesPacket.class, PlayerAbilitiesPacket::new, LimboProtocol.createMapping(57, ProtocolVersion.MINECRAFT_1_7_2, true), LimboProtocol.createMapping(43, ProtocolVersion.MINECRAFT_1_9, true), LimboProtocol.createMapping(44, ProtocolVersion.MINECRAFT_1_12_1, true), LimboProtocol.createMapping(46, ProtocolVersion.MINECRAFT_1_13, true), LimboProtocol.createMapping(49, ProtocolVersion.MINECRAFT_1_14, true), LimboProtocol.createMapping(50, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(49, ProtocolVersion.MINECRAFT_1_16, true), LimboProtocol.createMapping(48, ProtocolVersion.MINECRAFT_1_16_2, true), LimboProtocol.createMapping(50, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(47, ProtocolVersion.MINECRAFT_1_19, true), LimboProtocol.createMapping(49, ProtocolVersion.MINECRAFT_1_19_1, true), LimboProtocol.createMapping(48, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(52, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(54, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(56, ProtocolVersion.MINECRAFT_1_20_5, true), LimboProtocol.createMapping(58, ProtocolVersion.MINECRAFT_1_21_2, true), LimboProtocol.createMapping(57, ProtocolVersion.MINECRAFT_1_21_5, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, PositionRotationPacket.class, PositionRotationPacket::new, LimboProtocol.createMapping(8, ProtocolVersion.MINECRAFT_1_7_2, true), LimboProtocol.createMapping(46, ProtocolVersion.MINECRAFT_1_9, true), LimboProtocol.createMapping(47, ProtocolVersion.MINECRAFT_1_12_1, true), LimboProtocol.createMapping(50, ProtocolVersion.MINECRAFT_1_13, true), LimboProtocol.createMapping(53, ProtocolVersion.MINECRAFT_1_14, true), LimboProtocol.createMapping(54, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(53, ProtocolVersion.MINECRAFT_1_16, true), LimboProtocol.createMapping(52, ProtocolVersion.MINECRAFT_1_16_2, true), LimboProtocol.createMapping(56, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(54, ProtocolVersion.MINECRAFT_1_19, true), LimboProtocol.createMapping(57, ProtocolVersion.MINECRAFT_1_19_1, true), LimboProtocol.createMapping(56, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(60, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(62, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(64, ProtocolVersion.MINECRAFT_1_20_5, true), LimboProtocol.createMapping(66, ProtocolVersion.MINECRAFT_1_21_2, true), LimboProtocol.createMapping(65, ProtocolVersion.MINECRAFT_1_21_5, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, SetExperiencePacket.class, SetExperiencePacket::new, LimboProtocol.createMapping(31, ProtocolVersion.MINECRAFT_1_7_2, true), LimboProtocol.createMapping(61, ProtocolVersion.MINECRAFT_1_9, true), LimboProtocol.createMapping(63, ProtocolVersion.MINECRAFT_1_12, true), LimboProtocol.createMapping(64, ProtocolVersion.MINECRAFT_1_12_1, true), LimboProtocol.createMapping(67, ProtocolVersion.MINECRAFT_1_13, true), LimboProtocol.createMapping(71, ProtocolVersion.MINECRAFT_1_14, true), LimboProtocol.createMapping(72, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(81, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(84, ProtocolVersion.MINECRAFT_1_19_1, true), LimboProtocol.createMapping(82, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(86, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(88, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(90, ProtocolVersion.MINECRAFT_1_20_3, true), LimboProtocol.createMapping(92, ProtocolVersion.MINECRAFT_1_20_5, true), LimboProtocol.createMapping(97, ProtocolVersion.MINECRAFT_1_21_2, true), LimboProtocol.createMapping(96, ProtocolVersion.MINECRAFT_1_21_5, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, SetSlotPacket.class, SetSlotPacket::new, LimboProtocol.createMapping(47, ProtocolVersion.MINECRAFT_1_7_2, true), LimboProtocol.createMapping(22, ProtocolVersion.MINECRAFT_1_9, true), LimboProtocol.createMapping(23, ProtocolVersion.MINECRAFT_1_13, true), LimboProtocol.createMapping(22, ProtocolVersion.MINECRAFT_1_14, true), LimboProtocol.createMapping(23, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(22, ProtocolVersion.MINECRAFT_1_16, true), LimboProtocol.createMapping(21, ProtocolVersion.MINECRAFT_1_16_2, true), LimboProtocol.createMapping(22, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(19, ProtocolVersion.MINECRAFT_1_19, true), LimboProtocol.createMapping(18, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(20, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(21, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(20, ProtocolVersion.MINECRAFT_1_21_5, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, TimeUpdatePacket.class, TimeUpdatePacket::new, LimboProtocol.createMapping(3, ProtocolVersion.MINECRAFT_1_7_2, true), LimboProtocol.createMapping(68, ProtocolVersion.MINECRAFT_1_9, true), LimboProtocol.createMapping(70, ProtocolVersion.MINECRAFT_1_12, true), LimboProtocol.createMapping(71, ProtocolVersion.MINECRAFT_1_12_1, true), LimboProtocol.createMapping(74, ProtocolVersion.MINECRAFT_1_13, true), LimboProtocol.createMapping(78, ProtocolVersion.MINECRAFT_1_14, true), LimboProtocol.createMapping(79, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(78, ProtocolVersion.MINECRAFT_1_16, true), LimboProtocol.createMapping(88, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(89, ProtocolVersion.MINECRAFT_1_18, true), LimboProtocol.createMapping(92, ProtocolVersion.MINECRAFT_1_19_1, true), LimboProtocol.createMapping(90, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(94, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(96, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(98, ProtocolVersion.MINECRAFT_1_20_3, true), LimboProtocol.createMapping(100, ProtocolVersion.MINECRAFT_1_20_5, true), LimboProtocol.createMapping(107, ProtocolVersion.MINECRAFT_1_21_2, true), LimboProtocol.createMapping(106, ProtocolVersion.MINECRAFT_1_21_5, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, UpdateViewPositionPacket.class, UpdateViewPositionPacket::new, LimboProtocol.createMapping(64, ProtocolVersion.MINECRAFT_1_14, true), LimboProtocol.createMapping(65, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(64, ProtocolVersion.MINECRAFT_1_16, true), LimboProtocol.createMapping(73, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(72, ProtocolVersion.MINECRAFT_1_19, true), LimboProtocol.createMapping(75, ProtocolVersion.MINECRAFT_1_19_1, true), LimboProtocol.createMapping(74, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(78, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(80, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(82, ProtocolVersion.MINECRAFT_1_20_3, true), LimboProtocol.createMapping(84, ProtocolVersion.MINECRAFT_1_20_5, true), LimboProtocol.createMapping(88, ProtocolVersion.MINECRAFT_1_21_2, true), LimboProtocol.createMapping(87, ProtocolVersion.MINECRAFT_1_21_5, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.CLIENTBOUND, UpdateTagsPacket.class, UpdateTagsPacket::new, LimboProtocol.createMapping(85, ProtocolVersion.MINECRAFT_1_13, true), LimboProtocol.createMapping(91, ProtocolVersion.MINECRAFT_1_14, true), LimboProtocol.createMapping(92, ProtocolVersion.MINECRAFT_1_15, true), LimboProtocol.createMapping(91, ProtocolVersion.MINECRAFT_1_16, true), LimboProtocol.createMapping(102, ProtocolVersion.MINECRAFT_1_17, true), LimboProtocol.createMapping(103, ProtocolVersion.MINECRAFT_1_18, true), LimboProtocol.createMapping(104, ProtocolVersion.MINECRAFT_1_19, true), LimboProtocol.createMapping(107, ProtocolVersion.MINECRAFT_1_19_1, true), LimboProtocol.createMapping(106, ProtocolVersion.MINECRAFT_1_19_3, true), LimboProtocol.createMapping(110, ProtocolVersion.MINECRAFT_1_19_4, true), LimboProtocol.createMapping(112, ProtocolVersion.MINECRAFT_1_20_2, true), LimboProtocol.createMapping(116, ProtocolVersion.MINECRAFT_1_20_3, true), LimboProtocol.createMapping(120, ProtocolVersion.MINECRAFT_1_20_5, true), LimboProtocol.createMapping(127, ProtocolVersion.MINECRAFT_1_21_2, true));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.SERVERBOUND, MovePacket.class, MovePacket::new, LimboProtocol.createMapping(6, ProtocolVersion.MINECRAFT_1_7_2, false), LimboProtocol.createMapping(13, ProtocolVersion.MINECRAFT_1_9, false), LimboProtocol.createMapping(15, ProtocolVersion.MINECRAFT_1_12, false), LimboProtocol.createMapping(14, ProtocolVersion.MINECRAFT_1_12_1, false), LimboProtocol.createMapping(17, ProtocolVersion.MINECRAFT_1_13, false), LimboProtocol.createMapping(18, ProtocolVersion.MINECRAFT_1_14, false), LimboProtocol.createMapping(19, ProtocolVersion.MINECRAFT_1_16, false), LimboProtocol.createMapping(18, ProtocolVersion.MINECRAFT_1_17, false), LimboProtocol.createMapping(20, ProtocolVersion.MINECRAFT_1_19, false), LimboProtocol.createMapping(21, ProtocolVersion.MINECRAFT_1_19_1, false), LimboProtocol.createMapping(20, ProtocolVersion.MINECRAFT_1_19_3, false), LimboProtocol.createMapping(21, ProtocolVersion.MINECRAFT_1_19_4, false), LimboProtocol.createMapping(23, ProtocolVersion.MINECRAFT_1_20_2, false), LimboProtocol.createMapping(24, ProtocolVersion.MINECRAFT_1_20_3, false), LimboProtocol.createMapping(27, ProtocolVersion.MINECRAFT_1_20_5, false), LimboProtocol.createMapping(29, ProtocolVersion.MINECRAFT_1_21_2, false), LimboProtocol.createMapping(30, ProtocolVersion.MINECRAFT_1_21_6, false));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.SERVERBOUND, MovePositionOnlyPacket.class, MovePositionOnlyPacket::new, LimboProtocol.createMapping(4, ProtocolVersion.MINECRAFT_1_7_2, false), LimboProtocol.createMapping(12, ProtocolVersion.MINECRAFT_1_9, false), LimboProtocol.createMapping(14, ProtocolVersion.MINECRAFT_1_12, false), LimboProtocol.createMapping(13, ProtocolVersion.MINECRAFT_1_12_1, false), LimboProtocol.createMapping(16, ProtocolVersion.MINECRAFT_1_13, false), LimboProtocol.createMapping(17, ProtocolVersion.MINECRAFT_1_14, false), LimboProtocol.createMapping(18, ProtocolVersion.MINECRAFT_1_16, false), LimboProtocol.createMapping(17, ProtocolVersion.MINECRAFT_1_17, false), LimboProtocol.createMapping(19, ProtocolVersion.MINECRAFT_1_19, false), LimboProtocol.createMapping(20, ProtocolVersion.MINECRAFT_1_19_1, false), LimboProtocol.createMapping(19, ProtocolVersion.MINECRAFT_1_19_3, false), LimboProtocol.createMapping(20, ProtocolVersion.MINECRAFT_1_19_4, false), LimboProtocol.createMapping(22, ProtocolVersion.MINECRAFT_1_20_2, false), LimboProtocol.createMapping(23, ProtocolVersion.MINECRAFT_1_20_3, false), LimboProtocol.createMapping(26, ProtocolVersion.MINECRAFT_1_20_5, false), LimboProtocol.createMapping(28, ProtocolVersion.MINECRAFT_1_21_2, false), LimboProtocol.createMapping(29, ProtocolVersion.MINECRAFT_1_21_6, false));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.SERVERBOUND, MoveRotationOnlyPacket.class, MoveRotationOnlyPacket::new, LimboProtocol.createMapping(5, ProtocolVersion.MINECRAFT_1_7_2, false), LimboProtocol.createMapping(14, ProtocolVersion.MINECRAFT_1_9, false), LimboProtocol.createMapping(16, ProtocolVersion.MINECRAFT_1_12, false), LimboProtocol.createMapping(15, ProtocolVersion.MINECRAFT_1_12_1, false), LimboProtocol.createMapping(18, ProtocolVersion.MINECRAFT_1_13, false), LimboProtocol.createMapping(19, ProtocolVersion.MINECRAFT_1_14, false), LimboProtocol.createMapping(20, ProtocolVersion.MINECRAFT_1_16, false), LimboProtocol.createMapping(19, ProtocolVersion.MINECRAFT_1_17, false), LimboProtocol.createMapping(21, ProtocolVersion.MINECRAFT_1_19, false), LimboProtocol.createMapping(22, ProtocolVersion.MINECRAFT_1_19_1, false), LimboProtocol.createMapping(21, ProtocolVersion.MINECRAFT_1_19_3, false), LimboProtocol.createMapping(22, ProtocolVersion.MINECRAFT_1_19_4, false), LimboProtocol.createMapping(24, ProtocolVersion.MINECRAFT_1_20_2, false), LimboProtocol.createMapping(25, ProtocolVersion.MINECRAFT_1_20_3, false), LimboProtocol.createMapping(28, ProtocolVersion.MINECRAFT_1_20_5, false), LimboProtocol.createMapping(30, ProtocolVersion.MINECRAFT_1_21_2, false), LimboProtocol.createMapping(31, ProtocolVersion.MINECRAFT_1_21_6, false));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.SERVERBOUND, MoveOnGroundOnlyPacket.class, MoveOnGroundOnlyPacket::new, LimboProtocol.createMapping(3, ProtocolVersion.MINECRAFT_1_7_2, false), LimboProtocol.createMapping(15, ProtocolVersion.MINECRAFT_1_9, false), LimboProtocol.createMapping(13, ProtocolVersion.MINECRAFT_1_12, false), LimboProtocol.createMapping(12, ProtocolVersion.MINECRAFT_1_12_1, false), LimboProtocol.createMapping(15, ProtocolVersion.MINECRAFT_1_13, false), LimboProtocol.createMapping(20, ProtocolVersion.MINECRAFT_1_14, false), LimboProtocol.createMapping(21, ProtocolVersion.MINECRAFT_1_16, false), LimboProtocol.createMapping(20, ProtocolVersion.MINECRAFT_1_17, false), LimboProtocol.createMapping(22, ProtocolVersion.MINECRAFT_1_19, false), LimboProtocol.createMapping(23, ProtocolVersion.MINECRAFT_1_19_1, false), LimboProtocol.createMapping(22, ProtocolVersion.MINECRAFT_1_19_3, false), LimboProtocol.createMapping(23, ProtocolVersion.MINECRAFT_1_19_4, false), LimboProtocol.createMapping(25, ProtocolVersion.MINECRAFT_1_20_2, false), LimboProtocol.createMapping(26, ProtocolVersion.MINECRAFT_1_20_3, false), LimboProtocol.createMapping(29, ProtocolVersion.MINECRAFT_1_20_5, false), LimboProtocol.createMapping(31, ProtocolVersion.MINECRAFT_1_21_2, false), LimboProtocol.createMapping(32, ProtocolVersion.MINECRAFT_1_21_6, false));
        LimboProtocol.register(LIMBO_STATE_REGISTRY, PacketDirection.SERVERBOUND, TeleportConfirmPacket.class, TeleportConfirmPacket::new, LimboProtocol.createMapping(0, ProtocolVersion.MINECRAFT_1_9, false));
        LimboProtocol.register(PLAY_SERVERBOUND_REGISTRY, PlayerChatSessionPacket.class, PlayerChatSessionPacket::new, LimboProtocol.createMapping(32, ProtocolVersion.MINECRAFT_1_19_3, false), LimboProtocol.createMapping(6, ProtocolVersion.MINECRAFT_1_19_4, false), LimboProtocol.createMapping(7, ProtocolVersion.MINECRAFT_1_20_5, false), LimboProtocol.createMapping(8, ProtocolVersion.MINECRAFT_1_21_2, false), LimboProtocol.createMapping(9, ProtocolVersion.MINECRAFT_1_21_6, false));
    }

    public static StateRegistry createLocalStateRegistry() {
        try {
            StateRegistry stateRegistry = (StateRegistry)UNSAFE.allocateInstance(StateRegistry.class);
            LimboProtocol.overlayRegistry(stateRegistry, "clientbound", LIMBO_CLIENTBOUND_REGISTRY);
            LimboProtocol.overlayRegistry(stateRegistry, "serverbound", LIMBO_SERVERBOUND_REGISTRY);
            return stateRegistry;
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }

    public static void register(StateRegistry stateRegistry, PacketDirection direction, Class<?> packetClass, Supplier<?> packetSupplier, PacketMapping[] mappings) {
        LimboProtocol.register(stateRegistry, direction, packetClass, packetSupplier, (StateRegistry.PacketMapping[])Arrays.stream(mappings).map(mapping -> {
            try {
                return LimboProtocol.createMapping(mapping.getID(), mapping.getProtocolVersion(), mapping.getLastValidProtocolVersion(), mapping.isEncodeOnly());
            }
            catch (Throwable e) {
                throw new ReflectionException(e);
            }
        }).toArray(StateRegistry.PacketMapping[]::new));
    }

    public static void register(StateRegistry stateRegistry, PacketDirection direction, Class<?> packetClass, Supplier<?> packetSupplier, StateRegistry.PacketMapping ... mappings) {
        MethodHandle registryGetter = switch (direction) {
            case PacketDirection.CLIENTBOUND -> CLIENTBOUND_REGISTRY_GETTER;
            case PacketDirection.SERVERBOUND -> SERVERBOUND_REGISTRY_GETTER;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)direction));
        };
        try {
            LimboProtocol.register(registryGetter.invokeExact(stateRegistry), packetClass, packetSupplier, mappings);
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }

    public static void register(StateRegistry.PacketRegistry registry, Class<?> packetClass, Supplier<?> packetSupplier, StateRegistry.PacketMapping ... mappings) {
        try {
            Map versions = VERSIONS_GETTER.invokeExact(registry);
            List overlayMaps = versions.values().stream().flatMap(protocolRegistry -> {
                try {
                    IntObjectMap idToSupplier = PACKET_ID_TO_SUPPLIER_GETTER.invokeExact((StateRegistry.PacketRegistry.ProtocolRegistry)protocolRegistry);
                    Object2IntMap classToId = PACKET_CLASS_TO_ID_GETTER.invokeExact((StateRegistry.PacketRegistry.ProtocolRegistry)protocolRegistry);
                    if (idToSupplier instanceof OverlayMap && classToId instanceof OverlayMap) {
                        return Stream.of((OverlayMap)idToSupplier, (OverlayMap)classToId);
                    }
                    return Stream.empty();
                }
                catch (Throwable e) {
                    throw new ReflectionException(e);
                }
            }).toList();
            overlayMaps.forEach(overlayMap -> overlayMap.setOverride(true));
            REGISTER_METHOD.invokeExact(registry, packetClass, packetSupplier, mappings);
            overlayMaps.forEach(overlayMap -> overlayMap.setOverride(false));
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }

    private static StateRegistry.PacketMapping createMapping(int id, ProtocolVersion version, boolean encodeOnly) throws Throwable {
        return LimboProtocol.createMapping(id, version, null, encodeOnly);
    }

    private static StateRegistry.PacketMapping createMapping(int id, ProtocolVersion version, ProtocolVersion lastValidProtocolVersion, boolean encodeOnly) throws Throwable {
        return PACKET_MAPPING_CONSTRUCTOR.invokeExact(id, version, lastValidProtocolVersion, encodeOnly);
    }

    public static StateRegistry getLimboStateRegistry() {
        return LIMBO_STATE_REGISTRY;
    }

    static {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            UNSAFE = (Unsafe)unsafeField.get(null);
            LIMBO_STATE_REGISTRY = (StateRegistry)UNSAFE.allocateInstance(StateRegistry.class);
            VERSIONS_GETTER = MethodHandles.privateLookupIn(StateRegistry.PacketRegistry.class, MethodHandles.lookup()).findGetter(StateRegistry.PacketRegistry.class, "versions", Map.class);
            VERSIONS_FIELD = StateRegistry.PacketRegistry.class.getDeclaredField("versions");
            VERSIONS_FIELD.setAccessible(true);
            PACKET_ID_TO_SUPPLIER_GETTER = MethodHandles.privateLookupIn(StateRegistry.PacketRegistry.ProtocolRegistry.class, MethodHandles.lookup()).findGetter(StateRegistry.PacketRegistry.ProtocolRegistry.class, "packetIdToSupplier", IntObjectMap.class);
            PACKET_ID_TO_SUPPLIER_FIELD = StateRegistry.PacketRegistry.ProtocolRegistry.class.getDeclaredField("packetIdToSupplier");
            PACKET_ID_TO_SUPPLIER_FIELD.setAccessible(true);
            PACKET_CLASS_TO_ID_GETTER = MethodHandles.privateLookupIn(StateRegistry.PacketRegistry.ProtocolRegistry.class, MethodHandles.lookup()).findGetter(StateRegistry.PacketRegistry.ProtocolRegistry.class, "packetClassToId", Object2IntMap.class);
            PACKET_CLASS_TO_ID_FIELD = StateRegistry.PacketRegistry.ProtocolRegistry.class.getDeclaredField("packetClassToId");
            PACKET_CLASS_TO_ID_FIELD.setAccessible(true);
            CLIENTBOUND_REGISTRY_GETTER = MethodHandles.privateLookupIn(StateRegistry.class, MethodHandles.lookup()).findGetter(StateRegistry.class, "clientbound", StateRegistry.PacketRegistry.class);
            SERVERBOUND_REGISTRY_GETTER = MethodHandles.privateLookupIn(StateRegistry.class, MethodHandles.lookup()).findGetter(StateRegistry.class, "serverbound", StateRegistry.PacketRegistry.class);
            PLAY_CLIENTBOUND_REGISTRY = CLIENTBOUND_REGISTRY_GETTER.invokeExact(StateRegistry.PLAY);
            PLAY_SERVERBOUND_REGISTRY = SERVERBOUND_REGISTRY_GETTER.invokeExact(StateRegistry.PLAY);
            LimboProtocol.overlayRegistry(LIMBO_STATE_REGISTRY, "clientbound", PLAY_CLIENTBOUND_REGISTRY);
            LimboProtocol.overlayRegistry(LIMBO_STATE_REGISTRY, "serverbound", PLAY_SERVERBOUND_REGISTRY);
            LIMBO_CLIENTBOUND_REGISTRY = CLIENTBOUND_REGISTRY_GETTER.invokeExact(LIMBO_STATE_REGISTRY);
            LIMBO_SERVERBOUND_REGISTRY = SERVERBOUND_REGISTRY_GETTER.invokeExact(LIMBO_STATE_REGISTRY);
            REGISTER_METHOD = MethodHandles.privateLookupIn(StateRegistry.PacketRegistry.class, MethodHandles.lookup()).findVirtual(StateRegistry.PacketRegistry.class, "register", MethodType.methodType(Void.TYPE, Class.class, Supplier.class, StateRegistry.PacketMapping[].class));
            PACKET_MAPPING_CONSTRUCTOR = MethodHandles.privateLookupIn(StateRegistry.PacketRegistry.class, MethodHandles.lookup()).findConstructor(StateRegistry.PacketMapping.class, MethodType.methodType(Void.TYPE, Integer.TYPE, ProtocolVersion.class, ProtocolVersion.class, Boolean.TYPE));
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }
}

