/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.data;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.elytrium.limboapi.api.chunk.VirtualBlock;
import net.elytrium.limboapi.api.chunk.data.BlockStorage;
import net.elytrium.limboapi.api.mcprotocollib.NibbleArray3D;
import net.elytrium.limboapi.server.world.SimpleBlock;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BlockStorage17
implements BlockStorage {
    private final VirtualBlock[] blocks;

    public BlockStorage17() {
        this(new VirtualBlock[4096]);
    }

    private BlockStorage17(VirtualBlock[] blocks) {
        this.blocks = blocks;
    }

    @Override
    public void write(Object byteBufObject, ProtocolVersion version, int pass) {
        Preconditions.checkArgument((boolean)(byteBufObject instanceof ByteBuf));
        ByteBuf buf = (ByteBuf)byteBufObject;
        if (pass == 0) {
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0) {
                byte[] raw = new byte[this.blocks.length];
                for (int i = 0; i < this.blocks.length; ++i) {
                    VirtualBlock block = this.blocks[i];
                    raw[i] = (byte)(block == null ? 0 : block.getBlockStateID(ProtocolVersion.MINECRAFT_1_7_2) >> 4);
                }
                buf.writeBytes(raw);
            } else {
                short[] raw = new short[this.blocks.length];
                for (int i = 0; i < this.blocks.length; ++i) {
                    VirtualBlock block = this.blocks[i];
                    raw[i] = block == null ? (short)0 : block.getBlockStateID(ProtocolVersion.MINECRAFT_1_8);
                }
                for (short s : raw) {
                    buf.writeShortLE((int)s);
                }
            }
        } else if (pass == 1 && version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0) {
            NibbleArray3D metadata = new NibbleArray3D(4096);
            for (int i = 0; i < this.blocks.length; ++i) {
                VirtualBlock block = this.blocks[i];
                metadata.set(i, block == null ? 0 : block.getBlockStateID(ProtocolVersion.MINECRAFT_1_7_2) & 0xFFFF);
            }
            buf.writeBytes(metadata.getData());
        }
    }

    @Override
    public void set(int posX, int posY, int posZ, @NonNull VirtualBlock block) {
        this.blocks[BlockStorage.index((int)posX, (int)posY, (int)posZ)] = block;
    }

    @Override
    public @NonNull VirtualBlock get(int posX, int posY, int posZ) {
        VirtualBlock block = this.blocks[BlockStorage.index(posX, posY, posZ)];
        return block == null ? SimpleBlock.AIR : block;
    }

    @Override
    public int getDataLength(ProtocolVersion version) {
        return version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0 ? this.blocks.length + 2048 : this.blocks.length * 2;
    }

    @Override
    public BlockStorage copy() {
        return new BlockStorage17(Arrays.copyOf(this.blocks, this.blocks.length));
    }

    public String toString() {
        return "BlockStorage17{blocks=" + Arrays.toString(this.blocks) + "}";
    }
}

