/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.data;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.elytrium.limboapi.api.chunk.VirtualBlock;
import net.elytrium.limboapi.api.chunk.data.BlockStorage;
import net.elytrium.limboapi.api.chunk.util.CompactStorage;
import net.elytrium.limboapi.mcprotocollib.BitStorage116;
import net.elytrium.limboapi.mcprotocollib.BitStorage19;
import net.elytrium.limboapi.protocol.data.StorageUtils;
import net.elytrium.limboapi.server.world.SimpleBlock;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BlockStorage19
implements BlockStorage {
    private final ProtocolVersion version;
    private final List<VirtualBlock> palette;
    private final Map<Short, VirtualBlock> rawToBlock;
    private CompactStorage storage;

    public BlockStorage19(ProtocolVersion version) {
        this.version = version;
        this.palette = new ArrayList<VirtualBlock>();
        this.rawToBlock = new HashMap<Short, VirtualBlock>();
        this.palette.add(SimpleBlock.AIR);
        this.rawToBlock.put(SimpleBlock.AIR.getBlockStateID(version), SimpleBlock.AIR);
        this.storage = this.createStorage(4);
    }

    private BlockStorage19(ProtocolVersion version, List<VirtualBlock> palette, Map<Short, VirtualBlock> rawToBlock, CompactStorage storage) {
        this.version = version;
        this.palette = palette;
        this.rawToBlock = rawToBlock;
        this.storage = storage;
    }

    @Override
    public void write(Object byteBufObject, ProtocolVersion version, int pass) {
        Preconditions.checkArgument((boolean)(byteBufObject instanceof ByteBuf));
        ByteBuf buf = (ByteBuf)byteBufObject;
        buf.writeByte(this.storage.getBitsPerEntry());
        if (this.storage.getBitsPerEntry() > 8) {
            if (this.version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13) < 0) {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
            }
        } else {
            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.palette.size());
            for (VirtualBlock state : this.palette) {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)state.getBlockStateID(this.version));
            }
        }
        this.storage.write(buf, version);
    }

    @Override
    public void set(int posX, int posY, int posZ, @NonNull VirtualBlock block) {
        int id = this.getIndex(block);
        this.storage.set(BlockStorage.index(posX, posY, posZ), id);
    }

    private int getIndex(VirtualBlock block) {
        if (this.storage.getBitsPerEntry() > 8) {
            short raw = block.getBlockStateID(this.version);
            this.rawToBlock.put(raw, block);
            return raw;
        }
        int id = this.palette.indexOf(block);
        if (id == -1) {
            if (this.palette.size() >= 1 << this.storage.getBitsPerEntry()) {
                int bitsPerEntry = StorageUtils.fixBitsPerEntry(this.version, this.storage.getBitsPerEntry() + 1);
                CompactStorage newStorage = this.createStorage(bitsPerEntry);
                for (int i = 0; i < 4096; ++i) {
                    newStorage.set(i, bitsPerEntry > 8 ? (int)this.palette.get(this.storage.get(i)).getBlockStateID(this.version) : this.storage.get(i));
                }
                this.storage = newStorage;
                return this.getIndex(block);
            }
            this.palette.add(block);
            id = this.palette.size() - 1;
        }
        return id;
    }

    private CompactStorage createStorage(int bitsPerEntry) {
        return this.version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_16) < 0 ? new BitStorage19(bitsPerEntry, 4096) : new BitStorage116(bitsPerEntry, 4096);
    }

    @Override
    public @NonNull VirtualBlock get(int posX, int posY, int posZ) {
        int id = this.storage.get(BlockStorage.index(posX, posY, posZ));
        if (this.storage.getBitsPerEntry() > 8) {
            return this.rawToBlock.get((short)id);
        }
        return this.palette.get(id);
    }

    @Override
    public int getDataLength(ProtocolVersion version) {
        int length = 1;
        if (this.storage.getBitsPerEntry() > 8) {
            if (this.version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13) < 0) {
                ++length;
            }
        } else {
            length += ProtocolUtils.varIntBytes((int)this.palette.size());
            for (VirtualBlock state : this.palette) {
                length += ProtocolUtils.varIntBytes((int)state.getBlockStateID(this.version));
            }
        }
        return length + this.storage.getDataLength(version);
    }

    @Override
    public BlockStorage copy() {
        return new BlockStorage19(this.version, new ArrayList<VirtualBlock>(this.palette), new HashMap<Short, VirtualBlock>(this.rawToBlock), this.storage.copy());
    }

    public String toString() {
        return "BlockStorage19{version=" + String.valueOf(this.version) + ", palette=" + String.valueOf(this.palette) + ", rawToBlock=" + String.valueOf(this.rawToBlock) + ", storage=" + String.valueOf(this.storage) + "}";
    }
}

