/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.packets.c2s;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import net.elytrium.limboapi.server.LimboSessionHandlerImpl;

public class MoveRotationOnlyPacket
implements MinecraftPacket {
    private float yaw;
    private float pitch;
    private boolean onGround;
    private boolean collideHorizontally;

    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.yaw = buf.readFloat();
        this.pitch = buf.readFloat();
        if (protocolVersion.lessThan((Object)ProtocolVersion.MINECRAFT_1_21_2)) {
            this.onGround = buf.readBoolean();
        } else {
            short flags = buf.readUnsignedByte();
            this.onGround = (flags & 1) != 0;
            this.collideHorizontally = (flags & 2) != 0;
        }
    }

    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        throw new IllegalStateException();
    }

    public boolean handle(MinecraftSessionHandler handler) {
        if (handler instanceof LimboSessionHandlerImpl) {
            return ((LimboSessionHandlerImpl)handler).handle(this);
        }
        return true;
    }

    public int expectedMaxLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        return 9;
    }

    public int expectedMinLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        return 9;
    }

    public String toString() {
        return "PlayerLook{, yaw=" + this.yaw + ", pitch=" + this.pitch + ", onGround=" + this.onGround + ", collideHorizontally=" + this.collideHorizontally + "}";
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean isCollideHorizontally() {
        return this.collideHorizontally;
    }
}

