/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.packets.c2s;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.elytrium.limboapi.Settings;

public class PlayerChatSessionPacket
implements MinecraftPacket {
    private UUID holderId;
    private IdentifiedKey playerKey;

    public void decode(ByteBuf byteBuf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.holderId = ProtocolUtils.readUuid((ByteBuf)byteBuf);
        this.playerKey = ProtocolUtils.readPlayerKey((ProtocolVersion)protocolVersion, (ByteBuf)byteBuf);
    }

    public void encode(ByteBuf byteBuf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeUuid((ByteBuf)byteBuf, (UUID)this.holderId);
        ProtocolUtils.writePlayerKey((ByteBuf)byteBuf, (IdentifiedKey)this.playerKey);
    }

    public boolean handle(MinecraftSessionHandler minecraftSessionHandler) {
        if (minecraftSessionHandler instanceof ClientPlaySessionHandler) {
            return Settings.IMP.MAIN.FORCE_DISABLE_MODERN_CHAT_SIGNING;
        }
        return false;
    }

    public UUID getHolderId() {
        return this.holderId;
    }

    public void setHolderId(UUID holderId) {
        this.holderId = holderId;
    }

    public IdentifiedKey getPlayerKey() {
        return this.playerKey;
    }

    public void setPlayerKey(IdentifiedKey playerKey) {
        this.playerKey = playerKey;
    }
}

