/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.packets.s2c;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import net.elytrium.limboapi.api.protocol.packets.data.MapData;

public class MapDataPacket
implements MinecraftPacket {
    private final int mapID;
    private final byte scale;
    private final MapData mapData;

    public MapDataPacket(int mapID, byte scale, MapData mapData) {
        this.mapID = mapID;
        this.scale = scale;
        this.mapData = mapData;
    }

    public MapDataPacket() {
        throw new IllegalStateException();
    }

    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        throw new IllegalStateException();
    }

    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.mapID);
        byte[] data = this.mapData.getData();
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0) {
            buf.writeShort(data.length + 3);
            buf.writeByte(0);
            buf.writeByte(this.mapData.getX());
            buf.writeByte(this.mapData.getY());
            buf.writeBytes(data);
        } else {
            buf.writeByte((int)this.scale);
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_9) >= 0 && version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17) < 0) {
                buf.writeBoolean(false);
            }
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_14) >= 0) {
                buf.writeBoolean(false);
            }
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17) >= 0) {
                buf.writeBoolean(false);
            } else {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
            }
            buf.writeByte(this.mapData.getColumns());
            buf.writeByte(this.mapData.getRows());
            buf.writeByte(this.mapData.getX());
            buf.writeByte(this.mapData.getY());
            ProtocolUtils.writeByteArray((ByteBuf)buf, (byte[])data);
        }
    }

    public boolean handle(MinecraftSessionHandler handler) {
        return true;
    }

    public String toString() {
        return "MapDataPacket{mapID=" + this.mapID + ", scale=" + this.scale + ", mapData=" + String.valueOf(this.mapData) + "}";
    }
}

