/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.packets.s2c;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;

public class PositionRotationPacket
implements MinecraftPacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final float yaw;
    private final float pitch;
    private final boolean onGround;
    private final int teleportID;
    private final boolean dismountVehicle;

    @Deprecated(forRemoval=true)
    public PositionRotationPacket(double posX, double posY, double posZ, float yaw, float pitch, int teleportID, boolean onGround, boolean dismountVehicle) {
        this(posX, posY, posZ, yaw, pitch, onGround, teleportID, dismountVehicle);
    }

    public PositionRotationPacket(double posX, double posY, double posZ, float yaw, float pitch, boolean onGround, int teleportID, boolean dismountVehicle) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.yaw = yaw;
        this.pitch = pitch;
        this.onGround = onGround;
        this.teleportID = teleportID;
        this.dismountVehicle = dismountVehicle;
    }

    public PositionRotationPacket() {
        throw new IllegalStateException();
    }

    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        throw new IllegalStateException();
    }

    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (protocolVersion.noLessThan((Object)ProtocolVersion.MINECRAFT_1_21_2)) {
            this.encodeModern(buf, protocolVersion);
        } else {
            this.encodeLegacy(buf, protocolVersion);
        }
    }

    public void encodeModern(ByteBuf buf, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.teleportID);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(0.0);
        buf.writeDouble(0.0);
        buf.writeDouble(0.0);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.writeInt(0);
    }

    public void encodeLegacy(ByteBuf buf, ProtocolVersion protocolVersion) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0) {
            buf.writeBoolean(this.onGround);
        } else {
            buf.writeByte(0);
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_9) >= 0) {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.teleportID);
            }
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17) >= 0 && protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_19_3) <= 0) {
                buf.writeBoolean(this.dismountVehicle);
            }
        }
    }

    public boolean handle(MinecraftSessionHandler handler) {
        return true;
    }

    public String toString() {
        return "PlayerPositionAndLook{posX=" + this.posX + ", posY=" + this.posY + ", posZ=" + this.posZ + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ", teleportID=" + this.teleportID + ", onGround=" + this.onGround + ", dismountVehicle=" + this.dismountVehicle + "}";
    }
}

