/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.packets.s2c;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import net.elytrium.limboapi.api.material.VirtualItem;
import net.elytrium.limboapi.api.protocol.item.ItemComponentMap;
import net.elytrium.limboapi.utils.ProtocolTools;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SetSlotPacket
implements MinecraftPacket {
    private final int windowID;
    private final int slot;
    private final VirtualItem item;
    private final int count;
    private final int data;
    private final @Nullable CompoundBinaryTag nbt;
    private final @Nullable ItemComponentMap map;

    public SetSlotPacket(int windowID, int slot, VirtualItem item, int count, int data, @Nullable CompoundBinaryTag nbt, @Nullable ItemComponentMap map) {
        this.windowID = windowID;
        this.slot = slot;
        this.item = item;
        this.count = count;
        this.data = data;
        this.nbt = nbt;
        this.map = map;
    }

    public SetSlotPacket() {
        throw new IllegalStateException();
    }

    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        throw new IllegalStateException();
    }

    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_5) >= 0) {
            this.encodeModern(buf, direction, protocolVersion);
        } else {
            this.encodeLegacy(buf, direction, protocolVersion);
        }
    }

    public void encodeModern(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolTools.writeContainerId(buf, protocolVersion, this.windowID);
        ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
        buf.writeShort(this.slot);
        short id = this.item.getID(protocolVersion);
        if (id == 0) {
            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
        } else {
            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.count);
            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)id);
            if (this.map != null) {
                this.map.write(protocolVersion, buf);
            } else {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
            }
        }
    }

    public void encodeLegacy(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        boolean present;
        buf.writeByte(this.windowID);
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17_1) >= 0) {
            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
        }
        buf.writeShort(this.slot);
        short id = this.item.getID(protocolVersion);
        boolean bl = present = id > 0;
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13_2) >= 0) {
            buf.writeBoolean(present);
        }
        if (!present && protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13_2) < 0) {
            buf.writeShort(-1);
        }
        if (present) {
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13_2) < 0) {
                buf.writeShort((int)id);
            } else {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)id);
            }
            buf.writeByte(this.count);
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13) < 0) {
                buf.writeShort(this.data);
            }
            if (this.nbt == null) {
                if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0) {
                    buf.writeShort(-1);
                } else {
                    buf.writeByte(0);
                }
            } else {
                ProtocolUtils.writeBinaryTag((ByteBuf)buf, (ProtocolVersion)protocolVersion, (BinaryTag)this.nbt);
            }
        }
    }

    public boolean handle(MinecraftSessionHandler handler) {
        return true;
    }

    public String toString() {
        return "SetSlot{windowID=" + this.windowID + ", slot=" + this.slot + ", count=" + this.count + ", data=" + this.data + ", nbt=" + String.valueOf(this.nbt) + ")";
    }
}

