/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.protocol.packets.s2c;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UpdateTagsPacket
implements MinecraftPacket {
    private final Map<String, Map<String, List<Integer>>> tags;

    public UpdateTagsPacket() {
        throw new IllegalStateException();
    }

    public UpdateTagsPacket(Map<String, Map<String, List<Integer>>> tags) {
        this.tags = tags;
    }

    public Map<String, Map<String, int[]>> toVelocityTags() {
        LinkedHashMap<String, Map<String, int[]>> newTags = new LinkedHashMap<String, Map<String, int[]>>();
        for (Map.Entry<String, Map<String, List<Integer>>> entry : this.tags.entrySet()) {
            LinkedHashMap<String, int[]> tagRegistry = new LinkedHashMap<String, int[]>();
            for (Map.Entry<String, List<Integer>> tagEntry : entry.getValue().entrySet()) {
                tagRegistry.put(tagEntry.getKey(), tagEntry.getValue().stream().mapToInt(Integer::intValue).toArray());
            }
            newTags.put(entry.getKey(), tagRegistry);
        }
        return newTags;
    }

    public void decode(ByteBuf byteBuf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        throw new IllegalStateException();
    }

    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_17) >= 0) {
            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.tags.size());
            this.tags.forEach((tagType, tagList) -> {
                ProtocolUtils.writeString((ByteBuf)buf, (CharSequence)tagType);
                UpdateTagsPacket.writeTagList(buf, tagList);
            });
        } else {
            UpdateTagsPacket.writeTagList(buf, this.tags.get("minecraft:block"));
            UpdateTagsPacket.writeTagList(buf, this.tags.get("minecraft:item"));
            UpdateTagsPacket.writeTagList(buf, this.tags.get("minecraft:fluid"));
            if (version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_14) >= 0) {
                UpdateTagsPacket.writeTagList(buf, this.tags.get("minecraft:entity_type"));
            }
        }
    }

    private static void writeTagList(ByteBuf buf, Map<String, List<Integer>> tagList) {
        ProtocolUtils.writeVarInt((ByteBuf)buf, (int)tagList.size());
        tagList.forEach((tagId, blockList) -> {
            ProtocolUtils.writeString((ByteBuf)buf, (CharSequence)tagId);
            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)blockList.size());
            blockList.forEach(blockId -> ProtocolUtils.writeVarInt((ByteBuf)buf, (int)blockId));
        });
    }

    public boolean handle(MinecraftSessionHandler handler) {
        return true;
    }
}

