/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.client.AuthSessionHandler;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.ClientSettingsPacket;
import com.velocitypowered.proxy.protocol.packet.KeepAlivePacket;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerCommandPacket;
import com.velocitypowered.proxy.protocol.packet.chat.legacy.LegacyChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerCommandPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.UnsignedPlayerCommandPacket;
import com.velocitypowered.proxy.protocol.packet.config.FinishedUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.config.StartUpdatePacket;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.elytrium.commons.utils.reflection.ReflectionException;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.Settings;
import net.elytrium.limboapi.api.LimboSessionHandler;
import net.elytrium.limboapi.api.player.LimboPlayer;
import net.elytrium.limboapi.injection.login.confirmation.LoginConfirmHandler;
import net.elytrium.limboapi.protocol.packets.c2s.MoveOnGroundOnlyPacket;
import net.elytrium.limboapi.protocol.packets.c2s.MovePacket;
import net.elytrium.limboapi.protocol.packets.c2s.MovePositionOnlyPacket;
import net.elytrium.limboapi.protocol.packets.c2s.MoveRotationOnlyPacket;
import net.elytrium.limboapi.protocol.packets.c2s.PlayerChatSessionPacket;
import net.elytrium.limboapi.protocol.packets.c2s.TeleportConfirmPacket;
import net.elytrium.limboapi.server.LimboImpl;

public class LimboSessionHandlerImpl
implements MinecraftSessionHandler {
    private static final MethodHandle TEARDOWN_METHOD;
    private final LimboAPI plugin;
    private final LimboImpl limbo;
    private final ConnectedPlayer player;
    private final LimboSessionHandler callback;
    private final StateRegistry originalState;
    private final MinecraftSessionHandler originalHandler;
    private final RegisteredServer previousServer;
    private final Supplier<String> limboName;
    private final CompletableFuture<Object> playTransition = new CompletableFuture();
    private final CompletableFuture<Object> configTransition = new CompletableFuture();
    private final CompletableFuture<Object> chatSession = new CompletableFuture();
    private LimboPlayer limboPlayer;
    private ClientSettingsPacket settings;
    private String brand;
    private ScheduledFuture<?> keepAliveTask;
    private ScheduledFuture<?> chatSessionTimeoutTask;
    private ScheduledFuture<?> respawnTask;
    private long keepAliveKey;
    private boolean keepAlivePending;
    private int keepAlivesSkipped;
    private long keepAliveSentTime;
    private int ping = -1;
    private int genericBytes;
    private boolean loaded;
    private boolean switching;
    private boolean disconnecting;
    private boolean joinGameTriggered;

    public LimboSessionHandlerImpl(LimboAPI plugin, LimboImpl limbo, ConnectedPlayer player, LimboSessionHandler callback, StateRegistry originalState, MinecraftSessionHandler originalHandler, RegisteredServer previousServer, Supplier<String> limboName) {
        this.plugin = plugin;
        this.limbo = limbo;
        this.player = player;
        this.callback = callback;
        this.originalState = originalState;
        this.originalHandler = originalHandler;
        this.previousServer = previousServer;
        this.limboName = limboName;
        boolean bl = this.loaded = player.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_18_2) < 0;
        if (originalHandler instanceof LimboSessionHandlerImpl) {
            LimboSessionHandlerImpl sessionHandler = (LimboSessionHandlerImpl)originalHandler;
            this.settings = sessionHandler.getSettings();
            this.brand = sessionHandler.getBrand();
        }
    }

    public void onConfig(LimboPlayer player) {
        this.loaded = true;
        this.limboPlayer = player;
        this.callback.onConfig(this.limbo, player);
        Integer serverReadTimeout = this.limbo.getReadTimeout();
        if (serverReadTimeout == null) {
            serverReadTimeout = this.plugin.getServer().getConfiguration().getReadTimeout();
        }
        serverReadTimeout = serverReadTimeout / 2;
        this.keepAliveTask = player.getScheduledExecutor().scheduleAtFixedRate(() -> {
            MinecraftSessionHandler patt0$temp;
            MinecraftConnection connection = this.player.getConnection();
            if (connection.isClosed()) {
                this.keepAliveTask.cancel(true);
                return;
            }
            if (this.keepAlivePending) {
                if (++this.keepAlivesSkipped == 2) {
                    connection.closeWith((Object)this.plugin.getPackets().getTimeOut(this.player.getConnection().getState()));
                    if (Settings.IMP.MAIN.LOGGING_ENABLED) {
                        LimboAPI.getLogger().warn("{} was kicked due to keepalive timeout.", (Object)this.player);
                    }
                }
            } else if (this.keepAliveSentTime == 0L && (patt0$temp = this.originalHandler) instanceof LimboSessionHandlerImpl) {
                LimboSessionHandlerImpl sessionHandler = (LimboSessionHandlerImpl)patt0$temp;
                this.keepAliveKey = sessionHandler.keepAliveKey;
                this.keepAlivePending = sessionHandler.keepAlivePending;
                this.keepAlivesSkipped = sessionHandler.keepAlivesSkipped;
                this.keepAliveSentTime = sessionHandler.keepAliveSentTime;
                this.ping = sessionHandler.ping;
            } else {
                this.keepAliveKey = ThreadLocalRandom.current().nextInt();
                KeepAlivePacket keepAlive = new KeepAlivePacket();
                keepAlive.setRandomId(this.keepAliveKey);
                connection.write((Object)keepAlive);
                this.keepAlivePending = true;
                this.keepAlivesSkipped = 0;
                this.keepAliveSentTime = System.currentTimeMillis();
            }
        }, 250L, serverReadTimeout.intValue(), TimeUnit.MILLISECONDS);
    }

    public void onSpawn() {
        this.callback.onSpawn(this.limbo, this.limboPlayer);
        this.playTransition.complete(this);
    }

    public void disconnectToConfig(Runnable runnable) {
        if (this.configTransition.isDone()) {
            runnable.run();
            return;
        }
        this.release();
        this.switching = true;
        this.loaded = false;
        if (this.player.isOnlineMode() && this.player.getProtocolVersion().lessThan((Object)ProtocolVersion.MINECRAFT_1_21_2) && this.joinGameTriggered) {
            if (!this.chatSession.isDone() && this.chatSessionTimeoutTask == null) {
                this.chatSessionTimeoutTask = this.player.getConnection().eventLoop().schedule(() -> this.chatSession.complete(this), (long)Settings.IMP.MAIN.CHAT_SESSION_PACKET_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            this.chatSession.thenRunAsync(() -> {
                this.player.getConnection().write((Object)StartUpdatePacket.INSTANCE);
                ((CompletableFuture)this.configTransition.thenRun(this::disconnected)).thenRun(runnable);
            }, (Executor)this.player.getConnection().eventLoop());
        } else {
            this.player.getConnection().write((Object)StartUpdatePacket.INSTANCE);
            ((CompletableFuture)this.configTransition.thenRun(this::disconnected)).thenRun(runnable);
        }
    }

    public boolean handle(FinishedUpdatePacket packet) {
        if (this.player.getConnection().getState() != StateRegistry.CONFIG) {
            this.plugin.setActiveSessionHandler(this.player.getConnection(), StateRegistry.CONFIG, this);
            if (!this.loaded && !this.disconnecting) {
                this.limbo.spawnPlayerLocal(this.callback.getClass(), this, this.player, this.player.getConnection());
            } else if (this.switching) {
                this.switching = false;
                this.configTransition.complete(this);
            } else {
                this.player.getConnection().closeWith((Object)this.plugin.getPackets().getInvalidSwitch());
                if (Settings.IMP.MAIN.LOGGING_ENABLED) {
                    LimboAPI.getLogger().warn("{} sent an unexpected state switch confirmation.", (Object)this.player);
                }
            }
            return true;
        }
        this.limbo.onSpawn(this.callback.getClass(), this.player.getConnection(), this.player, this);
        this.player.getConnection().flush();
        return true;
    }

    public boolean handle(MovePacket packet) {
        if (this.loaded) {
            this.callback.onGround(packet.isOnGround());
            this.callback.onMove(packet.getX(), packet.getY(), packet.getZ());
            this.callback.onMove(packet.getX(), packet.getY(), packet.getZ(), packet.getYaw(), packet.getPitch());
            this.callback.onRotate(packet.getYaw(), packet.getPitch());
        }
        return true;
    }

    public boolean handle(MovePositionOnlyPacket packet) {
        if (this.loaded) {
            this.callback.onGround(packet.isOnGround());
            this.callback.onMove(packet.getX(), packet.getY(), packet.getZ());
        }
        return true;
    }

    public boolean handle(MoveRotationOnlyPacket packet) {
        if (this.loaded) {
            this.callback.onGround(packet.isOnGround());
            this.callback.onRotate(packet.getYaw(), packet.getPitch());
        }
        return true;
    }

    public boolean handle(MoveOnGroundOnlyPacket packet) {
        if (this.loaded) {
            this.callback.onGround(packet.isOnGround());
        }
        return true;
    }

    public boolean handle(TeleportConfirmPacket packet) {
        if (this.loaded) {
            this.callback.onTeleport(packet.getTeleportID());
        }
        return true;
    }

    public boolean handle(KeepAlivePacket packet) {
        MinecraftConnection connection = this.player.getConnection();
        if (this.keepAlivePending) {
            if (packet.getRandomId() != this.keepAliveKey) {
                connection.closeWith((Object)this.plugin.getPackets().getInvalidPing());
                if (Settings.IMP.MAIN.LOGGING_ENABLED) {
                    LimboAPI.getLogger().warn("{} sent an invalid keepalive.", (Object)this.player);
                }
                return false;
            }
            this.keepAlivePending = false;
            this.keepAlivesSkipped = 0;
            int currentPing = (int)(System.currentTimeMillis() - this.keepAliveSentTime);
            this.ping = this.ping == -1 ? currentPing : (this.ping * 3 + currentPing) / 4;
            return true;
        }
        connection.closeWith((Object)this.plugin.getPackets().getInvalidPing());
        if (Settings.IMP.MAIN.LOGGING_ENABLED) {
            LimboAPI.getLogger().warn("{} sent an unexpected keepalive.", (Object)this.player);
        }
        return false;
    }

    public boolean handle(LegacyChatPacket packet) {
        return this.handleChat(packet.getMessage());
    }

    public boolean handle(KeyedPlayerChatPacket packet) {
        return this.handleChat(packet.getMessage());
    }

    public boolean handle(KeyedPlayerCommandPacket packet) {
        return this.handleChat("/" + packet.getCommand());
    }

    public boolean handle(SessionPlayerChatPacket packet) {
        return this.handleChat(packet.getMessage());
    }

    public boolean handle(SessionPlayerCommandPacket packet) {
        return this.handleChat("/" + packet.getCommand());
    }

    private boolean handleChat(String message) {
        int messageLength = message.length();
        if (messageLength > Settings.IMP.MAIN.MAX_CHAT_MESSAGE_LENGTH) {
            this.kickTooBigPacket("chat", messageLength);
        } else {
            this.callback.onChat(message);
        }
        return true;
    }

    public void handleUnknown(ByteBuf packet) {
        int readableBytes = packet.readableBytes();
        this.genericBytes += readableBytes;
        if (readableBytes > Settings.IMP.MAIN.MAX_UNKNOWN_PACKET_LENGTH) {
            this.kickTooBigPacket("unknown", readableBytes);
        } else if (this.genericBytes > Settings.IMP.MAIN.MAX_MULTI_GENERIC_PACKET_LENGTH) {
            this.kickTooBigPacket("unknown, multi", this.genericBytes);
        }
    }

    public void handleGeneric(MinecraftPacket packet) {
        if (packet instanceof ClientSettingsPacket) {
            ClientSettingsPacket clientSettings;
            this.settings = clientSettings = (ClientSettingsPacket)packet;
        } else if (packet instanceof PlayerChatSessionPacket) {
            if (this.chatSessionTimeoutTask != null) {
                this.chatSessionTimeoutTask.cancel(true);
            }
            this.chatSession.complete(this);
        } else if (packet instanceof PluginMessagePacket) {
            PluginMessagePacket pluginMessage = (PluginMessagePacket)packet;
            int singleLength = pluginMessage.content().readableBytes() + pluginMessage.getChannel().length() * 4;
            this.genericBytes += singleLength;
            if (singleLength > Settings.IMP.MAIN.MAX_SINGLE_GENERIC_PACKET_LENGTH) {
                this.kickTooBigPacket("generic (PluginMessage packet (custom payload)), single", singleLength);
                return;
            }
            if (this.genericBytes > Settings.IMP.MAIN.MAX_MULTI_GENERIC_PACKET_LENGTH) {
                this.kickTooBigPacket("generic (PluginMessage packet (custom payload)), multi", this.genericBytes);
                return;
            }
            if (this.player.getConnection().getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) >= 0 && PluginMessageUtil.isMcBrand((PluginMessagePacket)pluginMessage)) {
                try {
                    this.brand = ProtocolUtils.readString((ByteBuf)pluginMessage.content().slice(), (int)Settings.IMP.MAIN.MAX_BRAND_NAME_LENGTH);
                }
                catch (QuietDecoderException ignored) {
                    this.kickTooBigPacket("brand name", pluginMessage.content().readableBytes());
                    return;
                }
            }
        } else if (packet instanceof UnsignedPlayerCommandPacket) {
            UnsignedPlayerCommandPacket commandPacket = (UnsignedPlayerCommandPacket)packet;
            this.handleChat("/" + commandPacket.getCommand());
            return;
        }
        this.callback.onGeneric(packet);
    }

    private void kickTooBigPacket(String type, int length) {
        this.player.getConnection().closeWith((Object)this.plugin.getPackets().getTooBigPacket());
        if (Settings.IMP.MAIN.LOGGING_ENABLED) {
            LimboAPI.getLogger().warn("{} sent too big packet. (type: {}, length: {})", new Object[]{this.player, type, length});
        }
    }

    public void release() {
        if (this.keepAliveTask != null) {
            this.keepAliveTask.cancel(true);
        }
        if (this.respawnTask != null) {
            this.respawnTask.cancel(true);
        }
        if (this.loaded) {
            this.limbo.onDisconnect();
            this.callback.onDisconnect();
        }
    }

    public void disconnected() {
        ChannelPipeline pipeline;
        MinecraftConnection connection;
        this.release();
        if (Settings.IMP.MAIN.LOGGING_ENABLED) {
            LimboAPI.getLogger().info("{} ({}) has disconnected from the {} Limbo", new Object[]{this.player.getUsername(), this.player.getRemoteAddress(), this.limboName.get()});
        }
        if ((connection = this.player.getConnection()).isClosed()) {
            try {
                TEARDOWN_METHOD.invokeExact(this.player);
            }
            catch (Throwable e) {
                throw new ReflectionException(e);
            }
            return;
        }
        if (!(this.originalHandler instanceof AuthSessionHandler || this.originalHandler instanceof LimboSessionHandlerImpl || this.originalHandler instanceof ClientPlaySessionHandler || this.originalHandler instanceof LoginConfirmHandler)) {
            connection.eventLoop().execute(() -> {
                if (connection.getState() != this.originalState) {
                    connection.addSessionHandler(this.originalState, this.originalHandler);
                } else {
                    this.plugin.setActiveSessionHandler(connection, connection.getState(), this.originalHandler);
                }
            });
        }
        if ((pipeline = connection.getChannel().pipeline()).get("limboapi-read-timeout") != null) {
            pipeline.replace("limboapi-read-timeout", "read-timeout", (ChannelHandler)new ReadTimeoutHandler((long)this.plugin.getServer().getConfiguration().getReadTimeout(), TimeUnit.MILLISECONDS));
        }
    }

    public void disconnect(Runnable runnable) {
        if (!this.disconnecting) {
            this.disconnecting = true;
            if (this.player.getConnection().getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_2) < 0) {
                runnable.run();
            } else {
                this.playTransition.thenRun(runnable);
            }
        }
    }

    public RegisteredServer getPreviousServer() {
        return this.previousServer;
    }

    public int getPing() {
        return this.ping;
    }

    public void setJoinGameTriggered(boolean joinGameTriggered) {
        this.joinGameTriggered = joinGameTriggered;
    }

    public void setRespawnTask(ScheduledFuture<?> respawnTask) {
        if (this.respawnTask != null) {
            this.respawnTask.cancel(true);
        }
        this.respawnTask = respawnTask;
    }

    public ClientSettingsPacket getSettings() {
        return this.settings;
    }

    public String getBrand() {
        return this.brand;
    }

    static {
        try {
            TEARDOWN_METHOD = MethodHandles.privateLookupIn(ConnectedPlayer.class, MethodHandles.lookup()).findVirtual(ConnectedPlayer.class, "teardown", MethodType.methodType(Void.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }
}

