/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server.item;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.elytrium.limboapi.api.protocol.item.ItemComponent;
import net.elytrium.limboapi.api.protocol.item.ItemComponentMap;
import net.elytrium.limboapi.server.item.SimpleItemComponentManager;
import net.elytrium.limboapi.server.item.type.WriteableItemComponent;

public class SimpleItemComponentMap
implements ItemComponentMap {
    private final List<WriteableItemComponent<?>> addedComponents = new ArrayList();
    private final List<WriteableItemComponent<?>> removedComponents = new ArrayList();
    private final SimpleItemComponentManager manager;

    public SimpleItemComponentMap(SimpleItemComponentManager manager) {
        this.manager = manager;
    }

    @Override
    public <T> ItemComponentMap add(ProtocolVersion version, String name, T value) {
        this.addedComponents.add((WriteableItemComponent)this.manager.createComponent(version, name).setValue(value));
        return this;
    }

    @Override
    public ItemComponentMap remove(ProtocolVersion version, String name) {
        this.removedComponents.add(this.manager.createComponent(version, name));
        return null;
    }

    @Override
    public List<ItemComponent> getAdded() {
        return this.addedComponents;
    }

    @Override
    public List<ItemComponent> getRemoved() {
        return this.removedComponents;
    }

    @Override
    public void read(ProtocolVersion version, Object buffer) {
        throw new UnsupportedOperationException("read");
    }

    @Override
    public void write(ProtocolVersion version, Object buffer) {
        ByteBuf buf = (ByteBuf)buffer;
        ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.getAdded().size());
        ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.getRemoved().size());
        for (WriteableItemComponent<?> component : this.addedComponents) {
            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.manager.getId(component.getName(), version));
            component.write(version, buf);
        }
        for (WriteableItemComponent<?> component : this.removedComponents) {
            ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.manager.getId(component.getName(), version));
        }
    }
}

