/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server.world;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.velocitypowered.api.network.ProtocolVersion;
import io.netty.util.collection.ShortObjectHashMap;
import io.netty.util.collection.ShortObjectMap;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.api.chunk.VirtualBlock;
import net.elytrium.limboapi.api.material.WorldVersion;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SimpleBlock
implements VirtualBlock {
    private static final Gson GSON = new Gson();
    private static final ShortObjectHashMap<SimpleBlock> LEGACY_BLOCK_STATE_IDS_MAP = new ShortObjectHashMap();
    private static final Map<ProtocolVersion, ShortObjectMap<Short>> MODERN_BLOCK_STATE_IDS_MAP = new EnumMap<ProtocolVersion, ShortObjectMap<Short>>(ProtocolVersion.class);
    private static final ShortObjectHashMap<String> MODERN_BLOCK_STATE_PROTOCOL_ID_MAP = new ShortObjectHashMap();
    private static final Map<String, Map<Set<String>, Short>> MODERN_BLOCK_STATE_STRING_MAP = new HashMap<String, Map<Set<String>, Short>>();
    private static final Map<String, Short> MODERN_BLOCK_STRING_MAP = new HashMap<String, Short>();
    private static final ShortObjectHashMap<Map<WorldVersion, Short>> LEGACY_BLOCK_IDS_MAP = new ShortObjectHashMap();
    private static final Map<String, Map<String, String>> DEFAULT_PROPERTIES_MAP = new HashMap<String, Map<String, String>>();
    private static final Map<String, String> MODERN_ID_REMAP = new HashMap<String, String>();
    public static final SimpleBlock AIR = new SimpleBlock(false, true, false, "minecraft:air", 0, 0);
    private final boolean solid;
    private final boolean air;
    private final boolean motionBlocking;
    private final String modernID;
    private final short blockStateID;
    private final short blockID;

    public static void init() {
        LinkedTreeMap blocks = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/blocks.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        blocks.forEach((modernId, protocolId) -> MODERN_BLOCK_STRING_MAP.put((String)modernId, Short.valueOf(protocolId)));
        LinkedTreeMap blockVersionMapping = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/blocks_mapping.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        blockVersionMapping.forEach((protocolId, versionMap) -> {
            EnumMap deserializedVersionMap = new EnumMap(WorldVersion.class);
            versionMap.forEach((version, id) -> deserializedVersionMap.put(WorldVersion.parse(version), Short.valueOf(id)));
            LEGACY_BLOCK_IDS_MAP.put(Short.valueOf(protocolId), deserializedVersionMap);
        });
        LinkedTreeMap blockStates = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/blockstates.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        blockStates.forEach((key, value) -> {
            MODERN_BLOCK_STATE_PROTOCOL_ID_MAP.put(Short.valueOf(value), key);
            String[] stringIDArgs = key.split("\\[");
            if (!MODERN_BLOCK_STATE_STRING_MAP.containsKey(stringIDArgs[0])) {
                MODERN_BLOCK_STATE_STRING_MAP.put(stringIDArgs[0], new HashMap());
            }
            if (stringIDArgs.length == 1) {
                MODERN_BLOCK_STATE_STRING_MAP.get(stringIDArgs[0]).put(null, Short.valueOf(value));
            } else {
                stringIDArgs[1] = stringIDArgs[1].substring(0, stringIDArgs[1].length() - 1);
                MODERN_BLOCK_STATE_STRING_MAP.get(stringIDArgs[0]).put(new HashSet<String>(Arrays.asList(stringIDArgs[1].split(","))), Short.valueOf(value));
            }
        });
        LinkedTreeMap legacyBlocks = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/legacyblocks.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        legacyBlocks.forEach((legacyBlockID, modernID) -> LEGACY_BLOCK_STATE_IDS_MAP.put(Short.valueOf(legacyBlockID), (Object)SimpleBlock.solid(Short.parseShort(modernID))));
        LEGACY_BLOCK_STATE_IDS_MAP.put((short)0, (Object)AIR);
        LinkedTreeMap modernMap = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/blockstates_mapping.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        modernMap.forEach((modernID, versionMap) -> {
            Short id = null;
            for (ProtocolVersion version : ProtocolVersion.SUPPORTED_VERSIONS) {
                id = Short.valueOf((String)versionMap.getOrDefault((Object)version.toString(), (Object)String.valueOf(id)));
                MODERN_BLOCK_STATE_IDS_MAP.computeIfAbsent(version, k -> new ShortObjectHashMap()).put(Short.parseShort(modernID), (Object)id);
            }
        });
        LinkedTreeMap properties = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/defaultblockproperties.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        properties.forEach((key, value) -> DEFAULT_PROPERTIES_MAP.put((String)key, new HashMap(value)));
        LinkedTreeMap modernIdRemap = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/modern_block_id_remap.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        MODERN_ID_REMAP.putAll((Map<String, String>)modernIdRemap);
    }

    public SimpleBlock(boolean solid, boolean air, boolean motionBlocking, short blockStateID) {
        this(solid, air, motionBlocking, (String)MODERN_BLOCK_STATE_PROTOCOL_ID_MAP.get(blockStateID), blockStateID);
    }

    public SimpleBlock(boolean solid, boolean air, boolean motionBlocking, String modernID, short blockStateID) {
        this(solid, air, motionBlocking, modernID, blockStateID, SimpleBlock.findId(modernID));
    }

    private static short findId(String modernID) {
        String block = modernID.split("\\[")[0];
        Short id = MODERN_BLOCK_STRING_MAP.get(block);
        if (id == null) {
            throw new IllegalStateException("failed to find local id for specific block: " + block);
        }
        return id;
    }

    public SimpleBlock(boolean solid, boolean air, boolean motionBlocking, String modernID, short blockStateID, short blockID) {
        this.solid = solid;
        this.air = air;
        this.motionBlocking = motionBlocking;
        this.modernID = modernID;
        this.blockStateID = blockStateID;
        this.blockID = blockID;
    }

    public SimpleBlock(boolean solid, boolean air, boolean motionBlocking, String modernID, Map<String, String> properties) {
        this(solid, air, motionBlocking, modernID, SimpleBlock.transformID(modernID, properties));
    }

    public SimpleBlock(boolean solid, boolean air, boolean motionBlocking, String modernID, Map<String, String> properties, short blockID) {
        this(solid, air, motionBlocking, modernID, SimpleBlock.transformID(modernID, properties), blockID);
    }

    public SimpleBlock(SimpleBlock block) {
        this.solid = block.solid;
        this.air = block.air;
        this.motionBlocking = block.motionBlocking;
        this.modernID = block.modernID;
        this.blockStateID = block.blockStateID;
        this.blockID = block.blockID;
    }

    @Override
    public short getModernID() {
        return this.blockStateID;
    }

    @Override
    public String getModernStringID() {
        return this.modernID;
    }

    @Override
    public short getID(ProtocolVersion version) {
        return this.getBlockStateID(version);
    }

    @Override
    public short getBlockID(WorldVersion version) {
        return (Short)((Map)LEGACY_BLOCK_IDS_MAP.get(this.blockID)).get((Object)version);
    }

    @Override
    public short getBlockID(ProtocolVersion version) {
        return this.getBlockID(WorldVersion.from(version));
    }

    @Override
    public boolean isSupportedOn(WorldVersion version) {
        return ((Map)LEGACY_BLOCK_IDS_MAP.get(this.blockID)).containsKey((Object)version);
    }

    @Override
    public boolean isSupportedOn(ProtocolVersion version) {
        return this.isSupportedOn(WorldVersion.from(version));
    }

    @Override
    public short getBlockStateID(ProtocolVersion version) {
        return (Short)MODERN_BLOCK_STATE_IDS_MAP.get(version).getOrDefault((Object)this.blockStateID, (Object)this.blockStateID);
    }

    @Override
    public boolean isSolid() {
        return this.solid;
    }

    @Override
    public boolean isAir() {
        return this.air;
    }

    @Override
    public boolean isMotionBlocking() {
        return this.motionBlocking;
    }

    public static VirtualBlock fromModernID(String modernID) {
        String[] deserializedModernId = modernID.split("[\\[\\]]");
        if (deserializedModernId.length < 2) {
            return SimpleBlock.fromModernID(modernID, Map.of());
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String property : deserializedModernId[1].split(",")) {
            String[] propertyKeyValue = property.split("=");
            properties.put(propertyKeyValue[0], propertyKeyValue[1]);
        }
        return SimpleBlock.fromModernID(deserializedModernId[0], properties);
    }

    public static VirtualBlock fromModernID(String modernID, Map<String, String> properties) {
        modernID = SimpleBlock.remapModernID(modernID);
        return SimpleBlock.solid(modernID, SimpleBlock.transformID(modernID, properties));
    }

    private static short transformID(String modernID, Map<String, String> properties) {
        Map<String, String> defaultProperties = DEFAULT_PROPERTIES_MAP.get(modernID);
        if (defaultProperties == null || defaultProperties.isEmpty()) {
            return SimpleBlock.transformID(modernID, (Set<String>)null);
        }
        HashSet<String> propertiesSet = new HashSet<String>();
        defaultProperties.forEach((key, value) -> {
            if (properties != null) {
                value = properties.getOrDefault(key, (String)value);
            }
            propertiesSet.add(key + "=" + value.toLowerCase(Locale.ROOT));
        });
        return SimpleBlock.transformID(modernID, propertiesSet);
    }

    private static short transformID(String modernID, Set<String> properties) {
        Map<Set<String>, Short> blockInfo = MODERN_BLOCK_STATE_STRING_MAP.get(modernID);
        if (blockInfo == null) {
            LimboAPI.getLogger().warn("Block " + modernID + " is not supported, and was replaced with air.");
            return AIR.getModernID();
        }
        Short id = properties == null || properties.isEmpty() ? blockInfo.get(null) : blockInfo.get(properties);
        if (id == null) {
            LimboAPI.getLogger().warn("Block " + modernID + " is not supported with " + String.valueOf(properties) + " properties, and was replaced with air.");
            return AIR.getModernID();
        }
        return id;
    }

    private static String remapModernID(String modernID) {
        String strippedID = ((String)modernID).split("\\[")[0];
        String remappedID = MODERN_ID_REMAP.get(strippedID);
        if (remappedID != null) {
            modernID = remappedID + ((String)modernID).substring(strippedID.length());
        }
        return modernID;
    }

    public static @NonNull SimpleBlock solid(short id) {
        return SimpleBlock.solid(true, (String)MODERN_BLOCK_STATE_PROTOCOL_ID_MAP.get(id), id);
    }

    public static @NonNull SimpleBlock solid(String modernID, short id) {
        return SimpleBlock.solid(true, SimpleBlock.remapModernID(modernID), id);
    }

    public static @NonNull SimpleBlock solid(boolean motionBlocking, short id) {
        return new SimpleBlock(true, false, motionBlocking, (String)MODERN_BLOCK_STATE_PROTOCOL_ID_MAP.get(id), id);
    }

    public static @NonNull SimpleBlock solid(boolean motionBlocking, String modernID, short id) {
        return new SimpleBlock(true, false, motionBlocking, SimpleBlock.remapModernID(modernID), id);
    }

    public static @NonNull SimpleBlock nonSolid(short id) {
        return SimpleBlock.nonSolid(true, (String)MODERN_BLOCK_STATE_PROTOCOL_ID_MAP.get(id), id);
    }

    public static @NonNull SimpleBlock nonSolid(String modernID, short id) {
        return SimpleBlock.nonSolid(true, SimpleBlock.remapModernID(modernID), id);
    }

    public static @NonNull SimpleBlock nonSolid(boolean motionBlocking, short id) {
        return new SimpleBlock(false, false, motionBlocking, (String)MODERN_BLOCK_STATE_PROTOCOL_ID_MAP.get(id), id);
    }

    public static @NonNull SimpleBlock nonSolid(boolean motionBlocking, String modernID, short id) {
        return new SimpleBlock(false, false, motionBlocking, SimpleBlock.remapModernID(modernID), id);
    }

    public static @NonNull SimpleBlock fromLegacyID(short id) {
        if (LEGACY_BLOCK_STATE_IDS_MAP.containsKey(id)) {
            return (SimpleBlock)LEGACY_BLOCK_STATE_IDS_MAP.get(id);
        }
        LimboAPI.getLogger().warn("Block #" + id + " is not supported, and was replaced with air.");
        return AIR;
    }

    public String toString() {
        return "SimpleBlock{solid=" + this.solid + ", air=" + this.air + ", motionBlocking=" + this.motionBlocking + ", id=" + this.blockStateID + "}";
    }
}

