/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server.world;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.velocitypowered.api.network.ProtocolVersion;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.api.material.Item;
import net.elytrium.limboapi.api.material.VirtualItem;
import net.elytrium.limboapi.api.material.WorldVersion;

public class SimpleItem
implements VirtualItem {
    private static final Gson GSON = new Gson();
    private static final Map<String, SimpleItem> MODERN_ID_MAP = new HashMap<String, SimpleItem>();
    private static final Map<Integer, SimpleItem> LEGACY_ID_MAP = new HashMap<Integer, SimpleItem>();
    private final String modernId;
    private final Map<WorldVersion, Short> versionIDs = new EnumMap<WorldVersion, Short>(WorldVersion.class);

    public SimpleItem(String modernId) {
        this.modernId = modernId;
    }

    @Override
    public short getID(ProtocolVersion version) {
        return this.getID(WorldVersion.from(version));
    }

    @Override
    public short getID(WorldVersion version) {
        return this.versionIDs.get((Object)version);
    }

    @Override
    public boolean isSupportedOn(ProtocolVersion version) {
        return this.isSupportedOn(WorldVersion.from(version));
    }

    @Override
    public boolean isSupportedOn(WorldVersion version) {
        return this.versionIDs.containsKey((Object)version);
    }

    @Override
    public String getModernID() {
        return this.modernId;
    }

    public static void init() {
        LinkedTreeMap itemsMapping = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/items_mapping.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        LinkedTreeMap modernItems = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/items.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        LinkedTreeMap legacyItems = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/legacyitems.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        LinkedTreeMap modernIdRemap = (LinkedTreeMap)GSON.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/modern_item_id_remap.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        modernItems.forEach((modernId, modernProtocolId) -> {
            SimpleItem simpleItem = new SimpleItem((String)modernId);
            ((LinkedTreeMap)itemsMapping.get(modernProtocolId)).forEach((key, value) -> simpleItem.versionIDs.put(WorldVersion.parse(key), Short.parseShort(value)));
            MODERN_ID_MAP.put((String)modernId, simpleItem);
            String remapped = (String)modernIdRemap.get(modernId);
            if (remapped != null) {
                if (MODERN_ID_MAP.containsKey(remapped)) {
                    throw new IllegalStateException("Remapped id " + remapped + " (from " + modernId + ") already exists");
                }
                MODERN_ID_MAP.put(remapped, simpleItem);
            }
        });
        legacyItems.forEach((legacyProtocolId, modernId) -> LEGACY_ID_MAP.put(Integer.parseInt(legacyProtocolId), MODERN_ID_MAP.get(modernId)));
    }

    public static SimpleItem fromItem(Item item) {
        return LEGACY_ID_MAP.get(item.getLegacyID());
    }

    public static SimpleItem fromLegacyID(int id) {
        return LEGACY_ID_MAP.get(id);
    }

    public static SimpleItem fromModernID(String id) {
        return MODERN_ID_MAP.get(id);
    }
}

