/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server.world;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.velocitypowered.api.network.ProtocolVersion;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.elytrium.limboapi.LimboAPI;
import net.elytrium.limboapi.api.material.WorldVersion;
import net.elytrium.limboapi.protocol.packets.s2c.UpdateTagsPacket;
import net.elytrium.limboapi.server.world.SimpleBlock;
import net.elytrium.limboapi.server.world.SimpleItem;

public class SimpleTagManager {
    private static final Map<String, Integer> FLUIDS = new HashMap<String, Integer>();
    private static final Map<WorldVersion, UpdateTagsPacket> VERSION_MAP = new EnumMap<WorldVersion, UpdateTagsPacket>(WorldVersion.class);

    public static void init() {
        Gson gson = new Gson();
        LinkedTreeMap fluids = (LinkedTreeMap)gson.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/fluids.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        fluids.forEach((id, protocolId) -> FLUIDS.put((String)id, Integer.valueOf(protocolId)));
        LinkedTreeMap tags = (LinkedTreeMap)gson.fromJson((Reader)new InputStreamReader(Objects.requireNonNull(LimboAPI.class.getResourceAsStream("/mapping/tags.json")), StandardCharsets.UTF_8), LinkedTreeMap.class);
        for (WorldVersion version : WorldVersion.values()) {
            VERSION_MAP.put(version, SimpleTagManager.localGetTagsForVersion((LinkedTreeMap<String, LinkedTreeMap<String, List<String>>>)tags, version));
        }
    }

    public static UpdateTagsPacket getUpdateTagsPacket(ProtocolVersion version) {
        return VERSION_MAP.get((Object)WorldVersion.from(version));
    }

    public static UpdateTagsPacket getUpdateTagsPacket(WorldVersion version) {
        return VERSION_MAP.get((Object)version);
    }

    private static UpdateTagsPacket localGetTagsForVersion(LinkedTreeMap<String, LinkedTreeMap<String, List<String>>> defaultTags, WorldVersion version) {
        LinkedTreeMap tags = new LinkedTreeMap();
        defaultTags.forEach((arg_0, arg_1) -> SimpleTagManager.lambda$localGetTagsForVersion$10(version, (Map)tags, arg_0, arg_1));
        return new UpdateTagsPacket((Map<String, Map<String, List<Integer>>>)tags);
    }

    private static /* synthetic */ void lambda$localGetTagsForVersion$10(WorldVersion version, Map tags, String tagType, LinkedTreeMap defaultTagList) {
        LinkedTreeMap tagList = new LinkedTreeMap();
        switch (tagType) {
            case "minecraft:block": {
                defaultTagList.forEach((tagName, blockList) -> tagList.put(tagName, blockList.stream().map(e -> SimpleBlock.fromModernID(e, Map.of())).filter(e -> e.isSupportedOn(version)).map(e -> e.getBlockID(version)).collect(Collectors.toList())));
                break;
            }
            case "minecraft:fluid": {
                defaultTagList.forEach((tagName, fluidList) -> tagList.put(tagName, fluidList.stream().map(FLUIDS::get).collect(Collectors.toList())));
                break;
            }
            case "minecraft:item": {
                defaultTagList.forEach((tagName, itemList) -> tagList.put(tagName, itemList.stream().map(SimpleItem::fromModernID).filter(item -> item.isSupportedOn(version)).map(item -> item.getID(version)).collect(Collectors.toList())));
                break;
            }
            default: {
                defaultTagList.forEach((tagName, entryList) -> {
                    if (!entryList.isEmpty()) {
                        throw new IllegalStateException("The " + tagType + " tag type is not supported yet.");
                    }
                    tagList.put(tagName, List.of());
                });
            }
        }
        tags.put(tagType, tagList);
    }
}

