/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.server.world;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.elytrium.limboapi.api.chunk.Dimension;
import net.elytrium.limboapi.api.chunk.VirtualBiome;
import net.elytrium.limboapi.api.chunk.VirtualBlock;
import net.elytrium.limboapi.api.chunk.VirtualBlockEntity;
import net.elytrium.limboapi.api.chunk.VirtualChunk;
import net.elytrium.limboapi.api.chunk.VirtualWorld;
import net.elytrium.limboapi.material.Biome;
import net.elytrium.limboapi.server.world.SimpleBlock;
import net.elytrium.limboapi.server.world.chunk.SimpleChunk;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleWorld
implements VirtualWorld {
    private final Map<Long, SimpleChunk> chunks = new HashMap<Long, SimpleChunk>();
    private final List<List<VirtualChunk>> distanceChunkMap = new ArrayList<List<VirtualChunk>>();
    private final @NonNull Dimension dimension;
    private final VirtualBiome defaultBiome;
    private final double spawnX;
    private final double spawnY;
    private final double spawnZ;
    private final float yaw;
    private final float pitch;

    public SimpleWorld(@NonNull Dimension dimension, double posX, double posY, double posZ, float yaw, float pitch) {
        this.dimension = dimension;
        this.defaultBiome = Biome.of(dimension.getDefaultBiome());
        this.spawnX = posX;
        this.spawnY = posY;
        this.spawnZ = posZ;
        this.yaw = yaw;
        this.pitch = pitch;
        this.getChunkOrNew((int)posX, (int)posZ);
    }

    @Override
    public void setBlock(int posX, int posY, int posZ, @Nullable VirtualBlock block) {
        this.getChunkOrNew(posX, posZ).setBlock(SimpleWorld.getChunkCoordinate(posX), posY, SimpleWorld.getChunkCoordinate(posZ), block);
    }

    @Override
    public void setBlockEntity(int posX, int posY, int posZ, @Nullable CompoundBinaryTag nbt, @Nullable VirtualBlockEntity blockEntity) {
        this.getChunkOrNew(posX, posZ).setBlockEntity(SimpleWorld.getChunkCoordinate(posX), posY, SimpleWorld.getChunkCoordinate(posZ), nbt, blockEntity);
    }

    @Override
    public @NonNull VirtualBlock getBlock(int posX, int posY, int posZ) {
        return this.chunkAction(posX, posZ, chunk -> chunk.getBlock(SimpleWorld.getChunkCoordinate(posX), posY, SimpleWorld.getChunkCoordinate(posZ)), () -> SimpleBlock.AIR);
    }

    @Override
    public void setBiome2d(int posX, int posZ, @NonNull VirtualBiome biome) {
        this.getChunkOrNew(posX, posZ).setBiome2D(SimpleWorld.getChunkCoordinate(posX), SimpleWorld.getChunkCoordinate(posZ), biome);
    }

    @Override
    public void setBiome3d(int posX, int posY, int posZ, @NonNull VirtualBiome biome) {
        this.getChunkOrNew(posX, posZ).setBiome3D(SimpleWorld.getChunkCoordinate(posX), posY, SimpleWorld.getChunkCoordinate(posZ), biome);
    }

    @Override
    public VirtualBiome getBiome(int posX, int posY, int posZ) {
        return this.chunkAction(posX, posZ, chunk -> chunk.getBiome(posX, posY, posZ), () -> Biome.PLAINS);
    }

    @Override
    public byte getBlockLight(int posX, int posY, int posZ) {
        return this.chunkAction(posX, posZ, chunk -> chunk.getBlockLight(SimpleWorld.getChunkCoordinate(posX), posY, SimpleWorld.getChunkCoordinate(posZ)), () -> (byte)0);
    }

    @Override
    public void setBlockLight(int posX, int posY, int posZ, byte light) {
        this.getChunkOrNew(posX, posZ).setBlockLight(SimpleWorld.getChunkCoordinate(posX), posY, SimpleWorld.getChunkCoordinate(posZ), light);
    }

    @Override
    public void fillBlockLight(int level) {
        for (SimpleChunk chunk : this.chunks.values()) {
            chunk.fillBlockLight(level);
        }
    }

    @Override
    public void fillSkyLight(int level) {
        for (SimpleChunk chunk : this.chunks.values()) {
            chunk.fillSkyLight(level);
        }
    }

    @Override
    public List<VirtualChunk> getChunks() {
        return ImmutableList.copyOf(this.chunks.values());
    }

    @Override
    public List<List<VirtualChunk>> getOrderedChunks() {
        return this.distanceChunkMap.stream().map(Collections::unmodifiableList).toList();
    }

    private int getDistanceToSpawn(VirtualChunk chunk) {
        int diffX = SimpleWorld.getChunkXZ((int)this.spawnX) - chunk.getPosX();
        int diffZ = SimpleWorld.getChunkXZ((int)this.spawnZ) - chunk.getPosZ();
        return (int)Math.sqrt(diffX * diffX + diffZ * diffZ);
    }

    @Override
    public @Nullable SimpleChunk getChunk(int posX, int posZ) {
        return this.chunks.get(SimpleWorld.getChunkIndex(SimpleWorld.getChunkXZ(posX), SimpleWorld.getChunkXZ(posZ)));
    }

    @Override
    public SimpleChunk getChunkOrNew(int posX, int posZ) {
        posX = SimpleWorld.getChunkXZ(posX);
        posZ = SimpleWorld.getChunkXZ(posZ);
        for (int chunkX = posX - 1; chunkX <= posX + 1; ++chunkX) {
            for (int chunkZ = posZ - 1; chunkZ <= posZ + 1; ++chunkZ) {
                this.localCreateChunk(chunkX, chunkZ);
            }
        }
        return this.chunks.get(SimpleWorld.getChunkIndex(posX, posZ));
    }

    private void localCreateChunk(int posX, int posZ) {
        long index = SimpleWorld.getChunkIndex(posX, posZ);
        if (!this.chunks.containsKey(index)) {
            SimpleChunk chunk = new SimpleChunk(posX, posZ, this.defaultBiome);
            this.chunks.put(index, chunk);
            int distance = this.getDistanceToSpawn(chunk);
            for (int i = this.distanceChunkMap.size(); i <= distance; ++i) {
                this.distanceChunkMap.add(new LinkedList());
            }
            this.distanceChunkMap.get(distance).add(chunk);
        }
    }

    @Override
    public @NonNull Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public double getSpawnX() {
        return this.spawnX;
    }

    @Override
    public double getSpawnY() {
        return this.spawnY;
    }

    @Override
    public double getSpawnZ() {
        return this.spawnZ;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    private <T> T chunkAction(int posX, int posZ, Function<SimpleChunk, T> function, Supplier<T> ifNull) {
        SimpleChunk chunk = this.getChunk(posX, posZ);
        if (chunk == null) {
            return ifNull.get();
        }
        return function.apply(chunk);
    }

    private static long getChunkIndex(int posX, int posZ) {
        return (long)posX << 32 | (long)posZ & 0xFFFFFFFFL;
    }

    private static int getChunkXZ(int pos) {
        return pos >> 4;
    }

    private static int getChunkCoordinate(int pos) {
        return pos & 0xF;
    }
}

