/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.thirdparty.commons.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.elytrium.limboapi.thirdparty.commons.config.ConfigLoadException;
import net.elytrium.limboapi.thirdparty.commons.config.ConfigSaveException;
import net.elytrium.limboapi.thirdparty.commons.config.ConfigSerializer;
import net.elytrium.limboapi.thirdparty.commons.config.ConfigSerializerCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YamlConfig {
    private final Yaml yaml = new Yaml();
    private YamlConfig original;
    private String prefix = null;
    private final List<Integer> placeholders = new LinkedList<Integer>();
    private final Map<Class<? extends ConfigSerializer<?, ?>>, ConfigSerializer<?, ?>> cachedSerializers = new HashMap();
    private final Map<Class<?>, ConfigSerializer<?, ?>> registeredSerializers = new HashMap();
    private final FieldNameStyle classFieldNameStyle;
    private final FieldNameStyle nodeFieldNameStyle;
    private Logger logger = LoggerFactory.getLogger(YamlConfig.class);

    public YamlConfig() {
        this.classFieldNameStyle = FieldNameStyle.MACRO_CASE;
        this.nodeFieldNameStyle = FieldNameStyle.KEBAB_CASE;
    }

    public YamlConfig(FieldNameStyle classFieldNameStyle, FieldNameStyle nodeFieldNameStyle) {
        this.classFieldNameStyle = classFieldNameStyle;
        this.nodeFieldNameStyle = nodeFieldNameStyle;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public <T, F> void registerSerializer(ConfigSerializer<T, F> configSerializer) {
        this.registeredSerializers.put(configSerializer.getToClass(), configSerializer);
    }

    public void registerSerializers(ConfigSerializerCollection configSerializerCollection) {
        for (ConfigSerializer<?, ?> configSerializer : configSerializerCollection.serializers()) {
            this.registerSerializer(configSerializer);
        }
    }

    public LoadResult reload(@NonNull File configFile) {
        return this.reload(configFile.toPath(), null);
    }

    public LoadResult reload(@NonNull Path configFile) {
        return this.reload(configFile, null);
    }

    public LoadResult reload(@NonNull File configFile, @Nullable String prefix) {
        return this.reload(configFile.toPath(), prefix);
    }

    public LoadResult reload(@NonNull Path configFile, @Nullable String prefix) {
        LoadResult result = this.load(configFile, prefix);
        switch (result) {
            case SUCCESS: {
                this.save(configFile);
                break;
            }
            case FAIL: 
            case CONFIG_NOT_EXISTS: {
                this.save(configFile);
                this.load(configFile, prefix);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid Result.");
            }
        }
        return result;
    }

    public LoadResult load(@NonNull File configFile) {
        return this.load(configFile.toPath(), null);
    }

    public LoadResult load(@NonNull File configFile, @Nullable String prefix) {
        return this.load(configFile.toPath(), prefix);
    }

    public LoadResult load(@NonNull Path configFile) {
        return this.load(configFile, null);
    }

    public LoadResult load(@NonNull Path configFile, @Nullable String prefix) {
        try {
            this.original = (YamlConfig)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create new instance of " + this.getClass().getName());
        }
        if (!Files.exists(configFile, new LinkOption[0])) {
            return LoadResult.CONFIG_NOT_EXISTS;
        }
        this.dispose();
        this.prefix = prefix;
        String now = LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).replace("T", "_").replace(":", ".");
        now = now.substring(0, now.lastIndexOf("."));
        try (InputStream fileInputStream = Files.newInputStream(configFile, new OpenOption[0]);){
            Map data = (Map)this.yaml.load(fileInputStream);
            if (data != null && !data.isEmpty()) {
                this.processMap(data, this.original, "", null, now, false);
                this.processMap(data, this, "", configFile, now, true);
            }
        }
        catch (Throwable t) {
            try {
                Path parent = configFile.getParent();
                if (parent == null) {
                    throw new NullPointerException("Config parent path is null for " + configFile);
                }
                String newFileName = configFile.getFileName() + "_invalid_" + now;
                Path configFileCopy = parent.resolve(newFileName);
                Files.copy(configFile, configFileCopy, StandardCopyOption.REPLACE_EXISTING);
                throw new ConfigLoadException("Unable to load config. File was copied to " + newFileName, t);
            }
            catch (IOException e) {
                throw new ConfigLoadException("Unable to load config and to make a copy.", e);
            }
        }
        return LoadResult.SUCCESS;
    }

    private void processMap(Map<String, Object> input, Object instance, String oldPath, @Nullable Path configFile, String now, boolean usePrefix) {
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            String key = oldPath + (oldPath.isEmpty() ? oldPath : ".") + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String stringValue = ((String)value).replace("{NL}", "\n");
                if (usePrefix) {
                    if (this.prefix != null) {
                        stringValue = stringValue.replace("{PRFX}", this.prefix);
                    }
                    value = stringValue;
                    if (key.equals("prefix")) {
                        this.prefix = stringValue;
                    }
                }
            }
            this.setFieldByKey(key, instance, value, configFile, now, usePrefix);
        }
    }

    private void setFieldByKey(String key, Object dest, Object value, @Nullable Path configFile, String now, boolean usePrefix) {
        block19: {
            Field field;
            String[] split = key.split("\\.");
            Object instance = this.getInstance(dest, split);
            if (instance != null && (field = this.getField(split, instance)) != null) {
                try {
                    if (field.getType() != Map.class && value instanceof Map) {
                        this.processMap((Map)value, dest, key, configFile, now, usePrefix);
                    } else if (field.getAnnotation(Final.class) == null) {
                        if (field.getType() == String.class && !(value instanceof String)) {
                            value = String.valueOf(value);
                        } else if (usePrefix && field.getAnnotation(Placeholders.class) != null) {
                            if (field.getType() != String.class) {
                                throw new IllegalAccessException(field.getType() + " is incompatible with placeholders");
                            }
                            Placeholders placeholders = field.getAnnotation(Placeholders.class);
                            int hash = net.elytrium.limboapi.thirdparty.commons.config.Placeholders.addPlaceholders(value, placeholders.value());
                            this.placeholders.add(hash);
                        } else if (field.getGenericType() instanceof ParameterizedType) {
                            Class parameter;
                            Type parameterType;
                            if (field.getType() == Map.class && value instanceof Map) {
                                Class parameter2;
                                Type parameterType2 = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1];
                                if (parameterType2 instanceof Class && this.isNodeMapping(parameter2 = (Class)parameterType2)) {
                                    value = ((Map)value).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.createNodeSequence(parameter2, e.getValue(), usePrefix)));
                                }
                            } else if (field.getType() == List.class && value instanceof List && (parameterType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class && this.isNodeMapping(parameter = (Class)parameterType)) {
                                value = ((List)value).stream().map(obj -> this.createNodeSequence(parameter, obj, usePrefix)).collect(Collectors.toList());
                            }
                        }
                        this.setField(field, instance, value);
                    }
                }
                catch (Throwable t) {
                    this.logger.debug("Failed to set config option: " + key + ": " + value + " | " + instance);
                    if (configFile == null) break block19;
                    Path parent = configFile.getParent();
                    if (parent == null) {
                        throw new NullPointerException("Config parent path is null for " + configFile);
                    }
                    Path configFileBackup = parent.resolve(configFile.getFileName() + "_backup_" + now);
                    if (Files.exists(configFileBackup, new LinkOption[0])) break block19;
                    try {
                        Files.copy(configFile, configFileBackup, StandardCopyOption.REPLACE_EXISTING);
                        this.logger.warn("Unable to load some of the config options. File was copied to {}", (Object)configFileBackup.getFileName());
                    }
                    catch (Throwable t2) {
                        this.logger.warn("Unable to load some of the config options and to make a copy.", t2);
                    }
                }
            }
        }
    }

    private Object getInstance(@NonNull Object instance, String[] split) {
        try {
            for (int i = 0; i < split.length - 1; ++i) {
                String name = this.toClassFieldName(split[i]);
                Field field = instance.getClass().getDeclaredField(name);
                field.setAccessible(true);
                Object value = field.get(instance);
                if (value == null) {
                    value = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.setField(field, instance, value);
                }
                instance = value;
            }
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Unable to find field " + e.getMessage() + " in " + instance.getClass().getName());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create new instance: " + e.getMessage());
        }
        return instance;
    }

    @Nullable
    private Field getField(String[] split, Object instance) {
        try {
            Field field = instance.getClass().getField(this.toClassFieldName(split[split.length - 1]));
            field.setAccessible(true);
            return field;
        }
        catch (Throwable t) {
            this.logger.debug("Invalid config field: " + String.join((CharSequence)".", split) + " for " + instance.getClass().getSimpleName());
            return null;
        }
    }

    private boolean isNodeMapping(Class<?> cls) {
        return cls.getAnnotation(NodeSequence.class) != null || !cls.isPrimitive() && !cls.isEnum() && !Number.class.isAssignableFrom(cls) && !Map.class.isAssignableFrom(cls) && !List.class.isAssignableFrom(cls) && !String.class.isAssignableFrom(cls);
    }

    public void save(@NonNull File configFile) {
        this.save(configFile.toPath());
    }

    public void save(@NonNull Path configFile) {
        try {
            Path parent = configFile.getParent();
            if (!Files.exists(configFile, new LinkOption[0]) && parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
                Files.createFile(configFile, new FileAttribute[0]);
            }
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(Files.newOutputStream(configFile, new OpenOption[0])), StandardCharsets.UTF_8));
            this.writeConfigKeyValue(writer, this.getClass(), this, this.original, 0, true);
            writer.close();
        }
        catch (Throwable t) {
            throw new ConfigSaveException(t);
        }
    }

    private void writeConfigKeyValue(PrintWriter writer, Class<?> clazz, Object instance, Object original, int indent, boolean usePrefix) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        String lineSeparator = System.lineSeparator();
        String spacing = this.getSpacing(indent);
        for (Field field : clazz.getFields()) {
            Class<?> current;
            if (field.getAnnotation(Ignore.class) != null || Modifier.isTransient(field.getModifiers()) || (current = field.getType()).getAnnotation(Ignore.class) != null) continue;
            this.writeNewLines(field.getAnnotation(NewLine.class), writer, lineSeparator);
            Comment[] comments = (Comment[])field.getAnnotationsByType(Comment.class);
            this.writePrependComments(comments, writer, spacing, lineSeparator);
            if (field.getAnnotation(Create.class) != null) {
                Object originalValue;
                this.writeNewLines(current.getAnnotation(NewLine.class), writer, lineSeparator);
                if (indent == 0) {
                    writer.write(lineSeparator);
                }
                comments = (Comment[])current.getAnnotationsByType(Comment.class);
                this.writePrependComments(comments, writer, spacing, lineSeparator);
                writer.write(spacing);
                writer.write(this.toNodeFieldName(current.getSimpleName()));
                writer.write(58);
                this.writeComments(comments, writer, lineSeparator, spacing + "  ");
                field.setAccessible(true);
                Object value = field.get(instance);
                if (value == null) {
                    value = current.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.setField(field, instance, value);
                }
                if ((originalValue = field.get(original)) == null) {
                    originalValue = current.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.setField(field, original, originalValue);
                }
                this.writeConfigKeyValue(writer, current, value, originalValue, indent + 2, usePrefix);
                continue;
            }
            String fieldName = field.getName();
            String fieldValue = this.toYamlString(field, field.get(instance), lineSeparator, spacing, usePrefix);
            String originalFieldValue = this.toYamlString(field, field.get(original), lineSeparator, spacing, usePrefix);
            String valueToWrite = fieldValue;
            if (this.prefix != null) {
                if (fieldValue.startsWith("\"") && fieldValue.endsWith("\"")) {
                    if (fieldValue.replace("{PRFX}", this.prefix).equals(originalFieldValue.replace("{PRFX}", this.prefix))) {
                        valueToWrite = originalFieldValue;
                    }
                } else if (fieldValue.contains(lineSeparator)) {
                    StringBuilder builder = new StringBuilder();
                    String[] lines = fieldValue.split(lineSeparator);
                    String[] originalLines = originalFieldValue.split(lineSeparator);
                    for (int i = 0; i < lines.length; ++i) {
                        String line;
                        String toAppend = line = lines[i];
                        if (i < originalLines.length) {
                            String originalLine = originalLines[i];
                            if (line.replace("{PRFX}", this.prefix).equals(originalLine.replace("{PRFX}", this.prefix))) {
                                toAppend = originalLine;
                            }
                        }
                        builder.append(toAppend).append(lineSeparator);
                    }
                    builder.setLength(builder.length() - lineSeparator.length());
                    valueToWrite = builder.toString();
                }
            }
            writer.write(spacing);
            writer.write(this.toNodeFieldName(fieldName));
            writer.write(valueToWrite.contains(lineSeparator) ? ":" : ": ");
            writer.write(valueToWrite);
            this.writeComments(comments, writer, lineSeparator, spacing);
        }
    }

    private String getSpacing(int indent) {
        return new String(new char[indent]).replace('\u0000', ' ');
    }

    private void writeNewLines(@Nullable NewLine newLine, PrintWriter writer, String lineSeparator) {
        if (newLine != null) {
            for (int i = 0; i < newLine.amount(); ++i) {
                writer.write(lineSeparator);
            }
        }
    }

    private void writePrependComments(Comment[] comments, PrintWriter writer, String spacing, String lineSeparator) {
        for (Comment comment : comments) {
            if (!comment.at().equals((Object)Comment.At.PREPEND)) continue;
            for (String commentLine : comment.value()) {
                writer.write(spacing);
                writer.write("# ");
                writer.write(commentLine.replace("\n", lineSeparator));
                writer.write(lineSeparator);
            }
        }
    }

    private void writeComments(Comment[] comments, PrintWriter writer, String lineSeparator, String spacing) {
        Map<Comment.At, List<Comment>> groups = Arrays.stream(comments).collect(Collectors.groupingBy(Comment::at));
        if (groups.containsKey((Object)Comment.At.SAME_LINE)) {
            writer.write(" # ");
            writer.write(groups.get((Object)Comment.At.SAME_LINE).get(0).value()[0]);
        }
        writer.write(lineSeparator);
        for (Comment comment : groups.getOrDefault((Object)Comment.At.APPEND, Collections.emptyList())) {
            for (String commentLine : comment.value()) {
                writer.write(spacing + "# " + commentLine.replace("\n", lineSeparator) + lineSeparator);
            }
        }
    }

    private void setField(Field field, Object owner, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        CustomSerializer customSerializer;
        int modifiers = field.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw new IllegalStateException("This field shouldn't be static.");
        }
        if (Modifier.isFinal(modifiers)) {
            throw new IllegalStateException("This field shouldn't be final.");
        }
        if (field.getType() == Map.class && value instanceof Map) {
            if (((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0] != String.class) {
                throw new IllegalStateException("Key type of this map should be " + String.class);
            }
            value = ((Map)value).entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), Map.Entry::getValue));
        } else if (field.getType().isEnum()) {
            String stringValue = String.valueOf(value);
            value = stringValue.isEmpty() || stringValue.equals("null") ? null : Enum.valueOf(field.getType(), stringValue.toUpperCase(Locale.ROOT));
        }
        ConfigSerializer<?, ?> configSerializer = this.registeredSerializers.get(field.getType());
        if (configSerializer != null) {
            value = configSerializer.deserializeRaw(value);
        }
        if ((customSerializer = field.getAnnotation(CustomSerializer.class)) != null) {
            value = this.getAndCacheSerializer(customSerializer).deserializeRaw(value);
        }
        field.set(owner, value);
    }

    protected static <T> T createNodeSequence(Class<T> nodeSequenceClass) {
        try {
            Constructor<T> constructor = nodeSequenceClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Method not found: " + e.getMessage());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create instance of " + nodeSequenceClass.getName());
        }
    }

    private <T> T createNodeSequence(Class<T> nodeSequenceClass, Object objects, boolean usePrefix) {
        if (!(objects instanceof Map)) {
            return (T)objects;
        }
        T instance = YamlConfig.createNodeSequence(nodeSequenceClass);
        this.processMap((Map)objects, instance, "", null, null, usePrefix);
        return instance;
    }

    protected static <T> T createNodeSequence(Class<T> nodeSequenceClass, Object ... values) {
        try {
            T instance = YamlConfig.createNodeSequence(nodeSequenceClass);
            Field[] fields = nodeSequenceClass.getDeclaredFields();
            int idx = 0;
            for (Field field : fields) {
                Object value;
                if (field.getAnnotation(Final.class) != null || field.getAnnotation(Ignore.class) != null || field.getType().getAnnotation(Ignore.class) != null || Modifier.isTransient(field.getModifiers())) continue;
                int modifiers = field.getModifiers();
                if (Modifier.isFinal(modifiers)) {
                    throw new IllegalStateException("Field " + field.getName() + " can't be final");
                }
                if (Modifier.isStatic(modifiers)) {
                    throw new IllegalStateException("Field " + field.getName() + " can't be static");
                }
                field.setAccessible(true);
                Object object = value = idx >= values.length ? null : values[idx];
                if (field.getAnnotation(Create.class) != null && !field.getType().isInstance(value)) {
                    field.set(instance, field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    continue;
                }
                if (value == null) continue;
                field.set(instance, value);
                ++idx;
            }
            return instance;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to set field: " + e.getMessage());
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create new instance: " + e.getMessage());
        }
    }

    private String toNodeFieldName(String field) {
        if (field.matches("^\\d+")) {
            return this.toNodeFieldName('\"' + field + '\"');
        }
        return this.nodeFieldNameStyle.fromMacroCase(this.classFieldNameStyle.toMacroCase(field));
    }

    private String toClassFieldName(String field) {
        return this.classFieldNameStyle.fromMacroCase(this.nodeFieldNameStyle.toMacroCase(field));
    }

    private String toYamlString(Field field, Object value, String lineSeparator, String spacing, boolean usePrefix) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return this.toYamlString(field, value, lineSeparator, spacing, false, false, 0, usePrefix);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String toYamlString(Field field, Object value, String lineSeparator, String spacing, boolean isCollection, boolean isMap, int nested, boolean usePrefix) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        ConfigSerializer<?, ?> configSerializer;
        CustomSerializer customSerializer = field.getAnnotation(CustomSerializer.class);
        if (customSerializer != null) {
            value = this.getAndCacheSerializer(customSerializer).serializeRaw(value);
        }
        if ((configSerializer = this.registeredSerializers.get(field.getType())) != null) {
            value = configSerializer.serializeRaw(value);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                return "{}";
            }
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object mapValue = entry.getValue();
                String data = this.toYamlString(field, mapValue, lineSeparator, spacing, true, true, 0, usePrefix);
                builder.append(lineSeparator).append(spacing).append("  ").append(this.toNodeFieldName(String.valueOf(key))).append(data.startsWith(lineSeparator) ? ":" : ": ").append(data);
            }
            return builder.toString();
        }
        if (value instanceof List) {
            List listValue = (List)value;
            if (listValue.isEmpty()) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            boolean newLine = nested == 0;
            for (Object obj : listValue) {
                if (newLine) {
                    builder.append(lineSeparator).append(spacing).append(this.getSpacing(2 + nested * 2));
                } else {
                    newLine = true;
                }
                builder.append("- ").append(this.toYamlString(field, obj, lineSeparator, spacing, true, false, nested + 1, usePrefix));
            }
            return builder.toString();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.isEmpty()) {
                return "\"\"";
            }
            return ('\"' + stringValue.replace("\\", "\\\\").replace("\"", "\\\"") + '\"').replace("\n", "{NL}");
        }
        if (value != null && isCollection && this.isNodeMapping(value.getClass())) {
            try (StringWriter stringWriter = new StringWriter();){
                PrintWriter writer = new PrintWriter(stringWriter);
                try {
                    if (isMap) {
                        writer.write(lineSeparator);
                    }
                    int indent = spacing.length() + 4;
                    this.writeConfigKeyValue(writer, value.getClass(), value, value, indent, usePrefix);
                    writer.flush();
                    String data = stringWriter.toString();
                    String string = data.substring(isMap ? 0 : indent, data.length() - lineSeparator.length());
                    writer.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return String.valueOf(value);
    }

    private ConfigSerializer<?, ?> getAndCacheSerializer(CustomSerializer serializer) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<ConfigSerializer<?, ?>> serializerClass = serializer.serializerClass();
        ConfigSerializer<?, ?> configSerializer = this.cachedSerializers.get(serializerClass);
        if (configSerializer == null) {
            configSerializer = serializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.cachedSerializers.put(serializerClass, configSerializer);
        }
        return configSerializer;
    }

    public void dispose() {
        this.placeholders.forEach(net.elytrium.limboapi.thirdparty.commons.config.Placeholders.placeholders::remove);
        this.placeholders.clear();
        this.cachedSerializers.clear();
        this.prefix = null;
    }

    protected static enum FieldNameStyle {
        KEBAB_CASE(s -> s.replace("_", "-").toLowerCase(Locale.ROOT), s -> s.replace("-", "_").toUpperCase(Locale.ROOT)),
        CAMEL_CASE(s -> FieldNameStyle.toCamelCase(s, false), s -> {
            StringBuilder sb = new StringBuilder();
            char previous = '\u0000';
            for (char c : s.toCharArray()) {
                if (Character.isUpperCase(c) && Character.isLowerCase(previous) || Character.isAlphabetic(c) && Character.isDigit(previous) || Character.isDigit(c) && Character.isAlphabetic(previous)) {
                    sb.append('_');
                }
                sb.append(Character.toUpperCase(c));
                previous = c;
            }
            return sb.toString();
        }),
        CAPITAL_CAMEL_CASE(s -> FieldNameStyle.toCamelCase(s, true), FieldNameStyle.CAMEL_CASE.toMacroCase),
        SNAKE_CASE(s -> s.toLowerCase(Locale.ROOT), s -> s.toUpperCase(Locale.ROOT)),
        MACRO_CASE(s -> s, s -> s),
        COBOL_CASE(s -> s.replace("_", "-"), s -> s.replace("-", "_"));

        private final Function<String, String> fromMacroCase;
        private final Function<String, String> toMacroCase;

        private FieldNameStyle(Function<String, String> fromMacroCase, Function<String, String> toMacroCase) {
            this.fromMacroCase = fromMacroCase;
            this.toMacroCase = toMacroCase;
        }

        private String fromMacroCase(String fieldName) {
            return this.fromMacroCase.apply(fieldName);
        }

        private String toMacroCase(String fieldName) {
            return this.toMacroCase.apply(fieldName);
        }

        private static String toCamelCase(String s, boolean nextCharUppercase) {
            StringBuilder sb = new StringBuilder();
            for (char c : s.toCharArray()) {
                if (c == '_') {
                    nextCharUppercase = true;
                    continue;
                }
                sb.append(nextCharUppercase ? c : Character.toLowerCase(c));
                nextCharUppercase = false;
            }
            return sb.toString();
        }
    }

    public static enum LoadResult {
        SUCCESS,
        FAIL,
        CONFIG_NOT_EXISTS;

    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Final {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Placeholders {
        public String[] value();
    }

    @Deprecated
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface NodeSequence {
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Ignore {
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface NewLine {
        public int amount() default 1;
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Repeatable(value=CommentsHolder.class)
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Comment {
        public String[] value();

        public At at() default At.PREPEND;

        public static enum At {
            PREPEND,
            SAME_LINE,
            APPEND;

        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface Create {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface CustomSerializer {
        public Class<? extends ConfigSerializer<?, ?>> serializerClass();
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface CommentsHolder {
        public Comment[] value();
    }
}

