/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboapi.thirdparty.fastprepare;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.natives.NativeSetupException;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.compression.VelocityCompressorFactory;
import com.velocitypowered.natives.encryption.JavaVelocityCipher;
import com.velocitypowered.natives.util.BufferPreference;
import com.velocitypowered.natives.util.Natives;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.netty.MinecraftCompressorAndLengthEncoder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.ReferenceCounted;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.elytrium.commons.utils.reflection.ReflectionException;
import net.elytrium.limboapi.thirdparty.fastprepare.PreparedPacket;
import net.elytrium.limboapi.thirdparty.fastprepare.PreparedPacketConstructor;
import net.elytrium.limboapi.thirdparty.fastprepare.dummy.DummyChannelHandlerContext;
import net.elytrium.limboapi.thirdparty.fastprepare.handler.CompressionEventHandler;
import net.elytrium.limboapi.thirdparty.fastprepare.handler.PreparedPacketEncoder;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
public class PreparedPacketFactory {
    public static final String PREPARED_ENCODER = "fastprepare-encoder";
    public static final String COMPRESSION_HANDLER = "fastprepare-compression-handler";
    private static final MethodHandle HANDLE_COMPRESSED;
    private static final MethodHandle ALLOCATE_COMPRESSED;
    private static final MethodHandle CLIENTBOUND_FIELD;
    private static final MethodHandle GET_PROTOCOL_REGISTRY;
    private static final MethodHandle PACKET_CLASS_TO_ID;
    private static final boolean DIRECT_BYTEBUF_PREFERRED_FOR_COMPRESSOR;
    private static final boolean JAVA_CIPHER;
    private final Set<StateRegistry> stateRegistries = ConcurrentHashMap.newKeySet();
    private final PreparedPacketConstructor constructor;
    private final Map<Thread, MinecraftCompressorAndLengthEncoder> compressionEncoder;
    private final boolean releaseReferenceCounted;
    private final ByteBufAllocator preparedPacketAllocator;
    private final ChannelHandlerContext dummyContext;
    private boolean enableCompression;
    private int compressionThreshold;
    private int compressionLevel;
    private boolean compatibilityMode;
    private boolean saveUncompressed;

    public PreparedPacketFactory(PreparedPacketConstructor constructor, StateRegistry stateRegistry, boolean enableCompression, int compressionLevel, int compressionThreshold, boolean saveUncompressed, boolean releaseReferenceCounted, boolean compatibilityMode) {
        this(constructor, stateRegistry, enableCompression, compressionLevel, compressionThreshold, saveUncompressed, releaseReferenceCounted, compatibilityMode, (ByteBufAllocator)new PooledByteBufAllocator());
    }

    public PreparedPacketFactory(PreparedPacketConstructor constructor, StateRegistry stateRegistry, boolean enableCompression, int compressionLevel, int compressionThreshold, boolean saveUncompressed, boolean releaseReferenceCounted, boolean compatibilityMode, ByteBufAllocator preparedPacketAllocator) {
        this(constructor, Collections.singleton(stateRegistry), enableCompression, compressionLevel, compressionThreshold, saveUncompressed, releaseReferenceCounted, compatibilityMode, preparedPacketAllocator);
    }

    public PreparedPacketFactory(PreparedPacketConstructor constructor, Collection<StateRegistry> stateRegistries, boolean enableCompression, int compressionLevel, int compressionThreshold, boolean saveUncompressed, boolean releaseReferenceCounted, boolean compatibilityMode, ByteBufAllocator preparedPacketAllocator) {
        this.constructor = constructor;
        this.stateRegistries.addAll(stateRegistries);
        this.compressionEncoder = Collections.synchronizedMap(new HashMap());
        this.updateCompressor(enableCompression, compressionLevel, compressionThreshold, saveUncompressed, compatibilityMode);
        this.releaseReferenceCounted = releaseReferenceCounted;
        this.preparedPacketAllocator = preparedPacketAllocator;
        this.dummyContext = new DummyChannelHandlerContext(preparedPacketAllocator);
    }

    public void updateCompressor(boolean enableCompression, int compressionLevel, int compressionThreshold, boolean saveUncompressed, boolean compatibilityMode) {
        this.enableCompression = enableCompression;
        this.compressionLevel = compressionLevel;
        this.compressionThreshold = compressionThreshold;
        this.saveUncompressed = saveUncompressed && enableCompression;
        this.compatibilityMode = compatibilityMode;
    }

    public void releaseThread(Thread thread) {
        if (this.compressionEncoder.containsKey(thread)) {
            try {
                this.compressionEncoder.remove(thread).handlerRemoved(this.dummyContext);
            }
            catch (Exception e) {
                throw new NativeSetupException((Throwable)e);
            }
        }
    }

    private MinecraftCompressorAndLengthEncoder getThreadLocalCompressionEncoder() {
        return this.compressionEncoder.computeIfAbsent(Thread.currentThread(), key -> new MinecraftCompressorAndLengthEncoder(this.compressionThreshold, ((VelocityCompressorFactory)Natives.compress.get()).create(this.compressionLevel)));
    }

    public PreparedPacket createPreparedPacket(ProtocolVersion minVersion, ProtocolVersion maxVersion) {
        return this.constructor.construct(minVersion, maxVersion, this);
    }

    public void encodeId(MinecraftPacket packet, ByteBuf out, ProtocolVersion version) {
        try {
            StateRegistry stateRegistry;
            StateRegistry.PacketRegistry packetRegistry;
            StateRegistry.PacketRegistry.ProtocolRegistry protocolRegistry;
            Object2IntMap classToId;
            int packetId = Integer.MIN_VALUE;
            Iterator<StateRegistry> iterator = this.stateRegistries.iterator();
            while (iterator.hasNext() && (packetId = (classToId = PACKET_CLASS_TO_ID.invokeExact(protocolRegistry = GET_PROTOCOL_REGISTRY.invokeExact(packetRegistry = CLIENTBOUND_FIELD.invokeExact(stateRegistry = iterator.next()), version))).getInt(packet.getClass())) == Integer.MIN_VALUE) {
            }
            if (packetId == Integer.MIN_VALUE) {
                throw new IllegalArgumentException(String.format("Unable to find id for packet of type %s in clientbound protocol %s.", packet.getClass().getName(), version));
            }
            ProtocolUtils.writeVarInt((ByteBuf)out, (int)packetId);
            packet.encode(out, ProtocolUtils.Direction.CLIENTBOUND, version);
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
    }

    public ByteBuf compress(ByteBuf packetData, boolean enableCompression) {
        ByteBuf networkPacket;
        try {
            if (enableCompression) {
                networkPacket = ALLOCATE_COMPRESSED.invokeExact(this.getThreadLocalCompressionEncoder(), this.dummyContext, packetData, false);
                HANDLE_COMPRESSED.invokeExact(this.getThreadLocalCompressionEncoder(), this.dummyContext, packetData, networkPacket);
            } else {
                int capacity = ProtocolUtils.varIntBytes((int)packetData.readableBytes()) + packetData.readableBytes();
                networkPacket = JAVA_CIPHER ? this.preparedPacketAllocator.heapBuffer(capacity) : this.preparedPacketAllocator.directBuffer(capacity);
                ProtocolUtils.writeVarInt((ByteBuf)networkPacket, (int)packetData.readableBytes());
                networkPacket.writeBytes(packetData);
            }
        }
        catch (Throwable e) {
            throw new ReflectionException(e);
        }
        packetData.release();
        return networkPacket;
    }

    public ByteBuf encodeSingle(MinecraftPacket packet, ProtocolVersion version) {
        return this.encodeSingle(packet, version, this.enableCompression);
    }

    public ByteBuf encodeSingle(MinecraftPacket packet, ProtocolVersion version, ByteBufAllocator alloc) {
        return this.encodeSingle(packet, version, this.enableCompression, this.releaseReferenceCounted, alloc);
    }

    public ByteBuf encodeSingle(MinecraftPacket packet, ProtocolVersion version, boolean enableCompression) {
        return this.encodeSingle(packet, version, enableCompression, this.releaseReferenceCounted, this.preparedPacketAllocator);
    }

    public ByteBuf encodeSingle(MinecraftPacket packet, ProtocolVersion version, boolean enableCompression, boolean releaseReferenceCounted) {
        return this.encodeSingle(packet, version, enableCompression, releaseReferenceCounted, this.preparedPacketAllocator);
    }

    public ByteBuf encodeSingle(MinecraftPacket packet, ProtocolVersion version, boolean enableCompression, ByteBufAllocator alloc) {
        return this.encodeSingle(packet, version, enableCompression, this.releaseReferenceCounted, alloc);
    }

    public ByteBuf encodeSingle(MinecraftPacket packet, ProtocolVersion version, boolean enableCompression, boolean releaseReferenceCounted, ByteBufAllocator alloc) {
        ByteBuf packetData = enableCompression ? (DIRECT_BYTEBUF_PREFERRED_FOR_COMPRESSOR ? alloc.directBuffer() : alloc.buffer()) : alloc.directBuffer();
        this.encodeId(packet, packetData, version);
        if (releaseReferenceCounted && packet instanceof ReferenceCounted) {
            ReferenceCounted referenceCounted = (ReferenceCounted)packet;
            referenceCounted.release();
        }
        return this.compress(packetData, version.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) >= 0 && enableCompression);
    }

    public void inject(Player player, MinecraftConnection connection, ChannelPipeline pipeline) {
        this.inject(player.isOnlineMode(), connection, pipeline);
    }

    public void inject(boolean onlineMode, MinecraftConnection connection, ChannelPipeline pipeline) {
        pipeline.addAfter("minecraft-encoder", PREPARED_ENCODER, (ChannelHandler)new PreparedPacketEncoder(this, connection.getProtocolVersion(), onlineMode));
        pipeline.addFirst(COMPRESSION_HANDLER, (ChannelHandler)new CompressionEventHandler(this));
    }

    public void replace(ChannelPipeline pipeline) {
        ((PreparedPacketEncoder)pipeline.get(PreparedPacketEncoder.class)).setFactory(this);
    }

    public void setShouldSendUncompressed(ChannelPipeline pipeline, boolean shouldSendUncompressed) {
        ((PreparedPacketEncoder)pipeline.get(PreparedPacketEncoder.class)).setShouldSendUncompressed(shouldSendUncompressed);
    }

    public void deject(ChannelPipeline pipeline) {
        if (pipeline.names().contains(PREPARED_ENCODER)) {
            pipeline.remove(PreparedPacketEncoder.class);
            pipeline.remove(CompressionEventHandler.class);
        }
    }

    public boolean isCompressionEnabled() {
        return this.enableCompression;
    }

    public boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    public boolean shouldSaveUncompressed() {
        return this.saveUncompressed;
    }

    public boolean shouldReleaseReferenceCounted() {
        return this.releaseReferenceCounted;
    }

    public ByteBufAllocator getPreparedPacketAllocator() {
        return this.preparedPacketAllocator;
    }

    public void addStateRegistries(Collection<StateRegistry> stateRegistries) {
        this.stateRegistries.addAll(stateRegistries);
    }

    public void addStateRegistry(StateRegistry stateRegistry) {
        this.stateRegistries.add(stateRegistry);
    }

    static {
        try {
            HANDLE_COMPRESSED = MethodHandles.privateLookupIn(MinecraftCompressorAndLengthEncoder.class, MethodHandles.lookup()).findVirtual(MinecraftCompressorAndLengthEncoder.class, "encode", MethodType.methodType(Void.TYPE, ChannelHandlerContext.class, ByteBuf.class, ByteBuf.class));
            ALLOCATE_COMPRESSED = MethodHandles.privateLookupIn(MinecraftCompressorAndLengthEncoder.class, MethodHandles.lookup()).findVirtual(MinecraftCompressorAndLengthEncoder.class, "allocateBuffer", MethodType.methodType(ByteBuf.class, ChannelHandlerContext.class, ByteBuf.class, Boolean.TYPE));
            CLIENTBOUND_FIELD = MethodHandles.privateLookupIn(StateRegistry.class, MethodHandles.lookup()).findGetter(StateRegistry.class, "clientbound", StateRegistry.PacketRegistry.class);
            GET_PROTOCOL_REGISTRY = MethodHandles.privateLookupIn(StateRegistry.PacketRegistry.class, MethodHandles.lookup()).findVirtual(StateRegistry.PacketRegistry.class, "getProtocolRegistry", MethodType.methodType(StateRegistry.PacketRegistry.ProtocolRegistry.class, ProtocolVersion.class));
            PACKET_CLASS_TO_ID = MethodHandles.privateLookupIn(StateRegistry.PacketRegistry.ProtocolRegistry.class, MethodHandles.lookup()).findGetter(StateRegistry.PacketRegistry.ProtocolRegistry.class, "packetClassToId", Object2IntMap.class);
            try (VelocityCompressor compressor = ((VelocityCompressorFactory)Natives.compress.get()).create(1);){
                BufferPreference bufferType = compressor.preferredBufferType();
                DIRECT_BYTEBUF_PREFERRED_FOR_COMPRESSOR = bufferType.equals((Object)BufferPreference.DIRECT_PREFERRED) || bufferType.equals((Object)BufferPreference.DIRECT_REQUIRED);
            }
            JAVA_CIPHER = Natives.cipher.get() == JavaVelocityCipher.FACTORY;
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }
}

