/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.siphash;

import io.whitfin.siphash.SipHasherContainer;
import io.whitfin.siphash.SipHasherStream;

public final class SipHasher {
    static final int DEFAULT_C = 2;
    static final int DEFAULT_D = 4;
    static final long INITIAL_V0 = 8317987319222330741L;
    static final long INITIAL_V1 = 7237128888997146477L;
    static final long INITIAL_V2 = 7816392313619706465L;
    static final long INITIAL_V3 = 8387220255154660723L;

    public static SipHasherContainer container(byte[] key) {
        return new SipHasherContainer(key);
    }

    public static long hash(byte[] key, byte[] data) {
        return SipHasher.hash(key, data, 2, 4);
    }

    public static long hash(byte[] key, byte[] data, int c, int d) {
        if (key.length != 16) {
            throw new IllegalArgumentException("Key must be exactly 16 bytes!");
        }
        long k0 = SipHasher.bytesToLong(key, 0);
        long k1 = SipHasher.bytesToLong(key, 8);
        return SipHasher.hash(c, d, 0x736F6D6570736575L ^ k0, 0x646F72616E646F6DL ^ k1, 0x6C7967656E657261L ^ k0, 0x7465646279746573L ^ k1, data);
    }

    public static SipHasherStream init(byte[] key) {
        return SipHasher.init(key, 2, 4);
    }

    public static SipHasherStream init(byte[] key, int c, int d) {
        return new SipHasherStream(key, c, d);
    }

    public static String toHexString(long hash) {
        String hex = Long.toHexString(hash);
        if (hex.length() == 16) {
            return hex;
        }
        StringBuilder sb = new StringBuilder();
        int j = 16 - hex.length();
        for (int i = 0; i < j; ++i) {
            sb.append('0');
        }
        return sb.append(hex).toString();
    }

    static long bytesToLong(byte[] bytes, int offset) {
        long m = 0L;
        for (int i = 0; i < 8; ++i) {
            m |= ((long)bytes[i + offset] & 0xFFL) << 8 * i;
        }
        return m;
    }

    static long hash(int c, int d, long v0, long v1, long v2, long v3, byte[] data) {
        int r;
        long m;
        int last = data.length / 8 * 8;
        int i = 0;
        while (i < last) {
            m = (long)data[i++] & 0xFFL;
            for (r = 1; r < 8; ++r) {
                m |= ((long)data[i++] & 0xFFL) << r * 8;
            }
            v3 ^= m;
            for (r = 0; r < c; ++r) {
                v0 += v1;
                v2 += v3;
                v1 = SipHasher.rotateLeft(v1, 13);
                v3 = SipHasher.rotateLeft(v3, 16);
                v1 ^= v0;
                v3 ^= v2;
                v0 = SipHasher.rotateLeft(v0, 32);
                v2 += v1;
                v0 += v3;
                v1 = SipHasher.rotateLeft(v1, 17);
                v3 = SipHasher.rotateLeft(v3, 21);
                v1 ^= v2;
                v3 ^= v0;
                v2 = SipHasher.rotateLeft(v2, 32);
            }
            v0 ^= m;
        }
        m = 0L;
        for (i = data.length - 1; i >= last; --i) {
            m <<= 8;
            m |= (long)data[i] & 0xFFL;
        }
        v3 ^= (m |= (long)data.length << 56);
        for (r = 0; r < c; ++r) {
            v0 += v1;
            v2 += v3;
            v1 = SipHasher.rotateLeft(v1, 13);
            v3 = SipHasher.rotateLeft(v3, 16);
            v1 ^= v0;
            v3 ^= v2;
            v0 = SipHasher.rotateLeft(v0, 32);
            v2 += v1;
            v0 += v3;
            v1 = SipHasher.rotateLeft(v1, 17);
            v3 = SipHasher.rotateLeft(v3, 21);
            v1 ^= v2;
            v3 ^= v0;
            v2 = SipHasher.rotateLeft(v2, 32);
        }
        v0 ^= m;
        v2 ^= 0xFFL;
        for (r = 0; r < d; ++r) {
            v0 += v1;
            v2 += v3;
            v1 = SipHasher.rotateLeft(v1, 13);
            v3 = SipHasher.rotateLeft(v3, 16);
            v1 ^= v0;
            v3 ^= v2;
            v0 = SipHasher.rotateLeft(v0, 32);
            v2 += v1;
            v0 += v3;
            v1 = SipHasher.rotateLeft(v1, 17);
            v3 = SipHasher.rotateLeft(v3, 21);
            v1 ^= v2;
            v3 ^= v0;
            v2 = SipHasher.rotateLeft(v2, 32);
        }
        return v0 ^ v1 ^ v2 ^ v3;
    }

    static long rotateLeft(long value, int shift) {
        return value << shift | value >>> 64 - shift;
    }
}

