/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.siphash;

import io.whitfin.siphash.SipHasher;

public final class SipHasherContainer {
    private final long v0;
    private final long v1;
    private final long v2;
    private final long v3;

    SipHasherContainer(byte[] key) {
        if (key.length != 16) {
            throw new IllegalArgumentException("Key must be exactly 16 bytes!");
        }
        long k0 = SipHasher.bytesToLong(key, 0);
        long k1 = SipHasher.bytesToLong(key, 8);
        this.v0 = 0x736F6D6570736575L ^ k0;
        this.v1 = 0x646F72616E646F6DL ^ k1;
        this.v2 = 0x6C7967656E657261L ^ k0;
        this.v3 = 0x7465646279746573L ^ k1;
    }

    public final long hash(byte[] data) {
        return this.hash(data, 2, 4);
    }

    public final long hash(byte[] data, int c, int d) {
        return SipHasher.hash(c, d, this.v0, this.v1, this.v2, this.v3, data);
    }
}

