/*
 * Decompiled with CFR 0.152.
 */
package io.whitfin.siphash;

import io.whitfin.siphash.SipHasher;

public final class SipHasherStream {
    private final int c;
    private final int d;
    private byte len;
    private int m_idx;
    private long m;
    private long v0;
    private long v1;
    private long v2;
    private long v3;

    SipHasherStream(byte[] key, int c, int d) {
        if (key.length != 16) {
            throw new IllegalArgumentException("Key must be exactly 16 bytes!");
        }
        long k0 = SipHasher.bytesToLong(key, 0);
        long k1 = SipHasher.bytesToLong(key, 8);
        this.v0 = 0x736F6D6570736575L ^ k0;
        this.v1 = 0x646F72616E646F6DL ^ k1;
        this.v2 = 0x6C7967656E657261L ^ k0;
        this.v3 = 0x7465646279746573L ^ k1;
        this.c = c;
        this.d = d;
        this.m = 0L;
        this.len = 0;
        this.m_idx = 0;
    }

    public final SipHasherStream update(byte b) {
        this.len = (byte)(this.len + 1);
        this.m |= ((long)b & 0xFFL) << this.m_idx++ * 8;
        if (this.m_idx < 8) {
            return this;
        }
        this.v3 ^= this.m;
        for (int i = 0; i < this.c; ++i) {
            this.round();
        }
        this.v0 ^= this.m;
        this.m_idx = 0;
        this.m = 0L;
        return this;
    }

    public final SipHasherStream update(byte[] bytes) {
        for (byte b : bytes) {
            this.update(b);
        }
        return this;
    }

    public final long digest() {
        byte msgLenMod256 = this.len;
        while (this.m_idx < 7) {
            this.update((byte)0);
        }
        this.update(msgLenMod256);
        this.v2 ^= 0xFFL;
        for (int i = 0; i < this.d; ++i) {
            this.round();
        }
        return this.v0 ^ this.v1 ^ this.v2 ^ this.v3;
    }

    private void round() {
        this.v0 += this.v1;
        this.v2 += this.v3;
        this.v1 = SipHasher.rotateLeft(this.v1, 13);
        this.v3 = SipHasher.rotateLeft(this.v3, 16);
        this.v1 ^= this.v0;
        this.v3 ^= this.v2;
        this.v0 = SipHasher.rotateLeft(this.v0, 32);
        this.v2 += this.v1;
        this.v0 += this.v3;
        this.v1 = SipHasher.rotateLeft(this.v1, 17);
        this.v3 = SipHasher.rotateLeft(this.v3, 21);
        this.v1 ^= this.v2;
        this.v3 ^= this.v0;
        this.v2 = SipHasher.rotateLeft(this.v2, 32);
    }
}

