/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.LegacyChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.scheduler.ScheduledTask;
import com.velocitypowered.proxy.util.ratelimit.Ratelimiter;
import com.velocitypowered.proxy.util.ratelimit.Ratelimiters;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.whitfin.siphash.SipHasher;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.elytrium.commons.utils.reflection.ReflectionException;
import net.elytrium.commons.utils.updates.UpdatesChecker;
import net.elytrium.limboapi.api.Limbo;
import net.elytrium.limboapi.api.LimboFactory;
import net.elytrium.limboapi.api.LimboSessionHandler;
import net.elytrium.limboapi.api.chunk.VirtualWorld;
import net.elytrium.limboapi.api.command.LimboCommandMeta;
import net.elytrium.limboapi.api.file.WorldFile;
import net.elytrium.limboapi.thirdparty.commons.kyori.serialization.Serializer;
import net.elytrium.limboapi.thirdparty.commons.kyori.serialization.Serializers;
import net.elytrium.limboauth.Settings;
import net.elytrium.limboauth.command.ChangePasswordCommand;
import net.elytrium.limboauth.command.DestroySessionCommand;
import net.elytrium.limboauth.command.ForceChangePasswordCommand;
import net.elytrium.limboauth.command.ForceRegisterCommand;
import net.elytrium.limboauth.command.ForceUnregisterCommand;
import net.elytrium.limboauth.command.LimboAuthCommand;
import net.elytrium.limboauth.command.PremiumCommand;
import net.elytrium.limboauth.command.TotpCommand;
import net.elytrium.limboauth.command.UnregisterCommand;
import net.elytrium.limboauth.dependencies.DatabaseLibrary;
import net.elytrium.limboauth.event.AuthPluginReloadEvent;
import net.elytrium.limboauth.event.PreAuthorizationEvent;
import net.elytrium.limboauth.event.PreEvent;
import net.elytrium.limboauth.event.PreRegisterEvent;
import net.elytrium.limboauth.event.TaskEvent;
import net.elytrium.limboauth.floodgate.FloodgateApiHolder;
import net.elytrium.limboauth.handler.AuthSessionHandler;
import net.elytrium.limboauth.listener.AuthListener;
import net.elytrium.limboauth.model.RegisteredPlayer;
import net.elytrium.limboauth.model.SQLRuntimeException;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.Dao;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.DaoManager;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.GenericRawResults;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.db.DatabaseType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.FieldType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt.QueryBuilder;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt.UpdateBuilder;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.support.ConnectionSource;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.table.TableInfo;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.table.TableUtils;
import net.elytrium.limboauth.thirdparty.org.bstats.charts.SimplePie;
import net.elytrium.limboauth.thirdparty.org.bstats.charts.SingleLineChart;
import net.elytrium.limboauth.thirdparty.org.bstats.velocity.Metrics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.title.Title;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

@Plugin(id="limboauth", name="LimboAuth", version="1.1.14", url="https://elytrium.net/", authors={"Elytrium (https://elytrium.net/)"}, dependencies={@Dependency(id="limboapi"), @Dependency(id="floodgate", optional=true)})
public class LimboAuth {
    public static final Ratelimiter<InetAddress> RATELIMITER = Ratelimiters.createWithMilliseconds((long)5000L);
    private static final ChannelIdentifier MOD_CHANNEL = MinecraftChannelIdentifier.create((String)"limboauth", (String)"mod/541f59e4256a337ea252bc482a009d46");
    private static final ChannelIdentifier LEGACY_MOD_CHANNEL = new LegacyChannelIdentifier("LIMBOAUTH|MOD");
    private static @MonotonicNonNull Logger LOGGER;
    private static @MonotonicNonNull Serializer SERIALIZER;
    private final Map<String, CachedSessionUser> cachedAuthChecks = new ConcurrentHashMap<String, CachedSessionUser>();
    private final Map<String, CachedPremiumUser> premiumCache = new ConcurrentHashMap<String, CachedPremiumUser>();
    private final Map<InetAddress, CachedBruteforceUser> bruteforceCache = new ConcurrentHashMap<InetAddress, CachedBruteforceUser>();
    private final Map<UUID, Runnable> postLoginTasks = new ConcurrentHashMap<UUID, Runnable>();
    private final Set<String> unsafePasswords = new HashSet<String>();
    private final Set<String> forcedPreviously = Collections.synchronizedSet(new HashSet());
    private final Set<String> pendingLogins = ConcurrentHashMap.newKeySet();
    private final HttpClient client = HttpClient.newHttpClient();
    private final ProxyServer server;
    private final Metrics.Factory metricsFactory;
    private final Path dataDirectory;
    private final File dataDirectoryFile;
    private final File configFile;
    private final LimboFactory factory;
    private final FloodgateApiHolder floodgateApi;
    private @Nullable Component loginPremium;
    private @Nullable Title loginPremiumTitle;
    private @Nullable Component loginFloodgate;
    private @Nullable Title loginFloodgateTitle;
    private Component registrationsDisabledKick;
    private Component bruteforceAttemptKick;
    private Component nicknameInvalidKick;
    private Component reconnectKick;
    private ScheduledTask purgeCacheTask;
    private ScheduledTask purgePremiumCacheTask;
    private ScheduledTask purgeBruteforceCacheTask;
    private ConnectionSource connectionSource;
    private Dao<RegisteredPlayer, String> playerDao;
    private Pattern nicknameValidationPattern;
    private Limbo authServer;

    @Inject
    public LimboAuth(Logger logger, ProxyServer server, Metrics.Factory metricsFactory, @DataDirectory Path dataDirectory) {
        LimboAuth.setLogger(logger);
        this.server = server;
        this.metricsFactory = metricsFactory;
        this.dataDirectory = dataDirectory;
        this.dataDirectoryFile = dataDirectory.toFile();
        this.configFile = new File(this.dataDirectoryFile, "config.yml");
        this.factory = (LimboFactory)this.server.getPluginManager().getPlugin("limboapi").flatMap(PluginContainer::getInstance).orElseThrow();
        this.floodgateApi = this.server.getPluginManager().getPlugin("floodgate").isPresent() ? new FloodgateApiHolder() : null;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        System.setProperty("com.j256.simplelogging.level", "ERROR");
        try {
            this.reload();
        }
        catch (SQLRuntimeException exception) {
            LOGGER.error("SQL EXCEPTION CAUGHT.", (Throwable)exception);
            this.server.shutdown();
        }
        Metrics metrics = this.metricsFactory.make(this, 13700);
        metrics.addCustomChart(new SimplePie("floodgate_auth", () -> String.valueOf(Settings.IMP.MAIN.FLOODGATE_NEED_AUTH)));
        metrics.addCustomChart(new SimplePie("premium_auth", () -> String.valueOf(Settings.IMP.MAIN.ONLINE_MODE_NEED_AUTH)));
        metrics.addCustomChart(new SimplePie("db_type", () -> String.valueOf((Object)Settings.IMP.DATABASE.STORAGE_TYPE)));
        metrics.addCustomChart(new SimplePie("load_world", () -> String.valueOf(Settings.IMP.MAIN.LOAD_WORLD)));
        metrics.addCustomChart(new SimplePie("totp_enabled", () -> String.valueOf(Settings.IMP.MAIN.ENABLE_TOTP)));
        metrics.addCustomChart(new SimplePie("dimension", () -> String.valueOf(Settings.IMP.MAIN.DIMENSION)));
        metrics.addCustomChart(new SimplePie("save_uuid", () -> String.valueOf(Settings.IMP.MAIN.SAVE_UUID)));
        metrics.addCustomChart(new SingleLineChart("registered_players", () -> Math.toIntExact(this.playerDao.countOf())));
        this.server.getScheduler().buildTask((Object)this, () -> {
            if (!UpdatesChecker.checkVersionByURL((String)"https://raw.githubusercontent.com/Elytrium/LimboAuth/master/VERSION", (String)Settings.IMP.VERSION)) {
                LOGGER.error("****************************************");
                LOGGER.warn("The new LimboAuth update was found, please update.");
                LOGGER.error("https://github.com/Elytrium/LimboAuth/releases/");
                LOGGER.error("****************************************");
            }
        }).schedule();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="LEGACY_AMPERSAND can't be null in velocity.")
    public void reload() {
        Settings.IMP.reload(this.configFile, Settings.IMP.PREFIX);
        if (!Settings.IMP.MAIN.ONLINE_MODE_NEED_AUTH_STRICT && !Settings.IMP.MAIN.SAVE_PREMIUM_ACCOUNTS) {
            Settings.IMP.MAIN.SAVE_PREMIUM_ACCOUNTS = true;
            LOGGER.error("As you have online-mode-need-auth-strict disabled, save-premium-accounts was forcibly enabled to prevent online-mode accounts hijacking.");
        }
        if (this.floodgateApi == null && !Settings.IMP.MAIN.FLOODGATE_NEED_AUTH) {
            throw new IllegalStateException("If you want floodgate players to automatically pass auth (floodgate-need-auth: false), please install floodgate plugin.");
        }
        ComponentSerializer serializer = Settings.IMP.SERIALIZER.getSerializer();
        if (serializer == null) {
            LOGGER.warn("The specified serializer could not be founded, using default. (LEGACY_AMPERSAND)");
            LimboAuth.setSerializer(new Serializer(Objects.requireNonNull(Serializers.LEGACY_AMPERSAND.getSerializer())));
        } else {
            LimboAuth.setSerializer(new Serializer(serializer));
        }
        TaskEvent.reload();
        AuthSessionHandler.reload();
        this.loginPremium = Settings.IMP.MAIN.STRINGS.LOGIN_PREMIUM.isEmpty() ? null : SERIALIZER.deserialize(Settings.IMP.MAIN.STRINGS.LOGIN_PREMIUM);
        this.loginPremiumTitle = Settings.IMP.MAIN.STRINGS.LOGIN_PREMIUM_TITLE.isEmpty() && Settings.IMP.MAIN.STRINGS.LOGIN_PREMIUM_SUBTITLE.isEmpty() ? null : Title.title((Component)SERIALIZER.deserialize(Settings.IMP.MAIN.STRINGS.LOGIN_PREMIUM_TITLE), (Component)SERIALIZER.deserialize(Settings.IMP.MAIN.STRINGS.LOGIN_PREMIUM_SUBTITLE), (Title.Times)Settings.IMP.MAIN.PREMIUM_TITLE_SETTINGS.toTimes());
        this.loginFloodgate = Settings.IMP.MAIN.STRINGS.LOGIN_FLOODGATE.isEmpty() ? null : SERIALIZER.deserialize(Settings.IMP.MAIN.STRINGS.LOGIN_FLOODGATE);
        this.loginFloodgateTitle = Settings.IMP.MAIN.STRINGS.LOGIN_FLOODGATE_TITLE.isEmpty() && Settings.IMP.MAIN.STRINGS.LOGIN_FLOODGATE_SUBTITLE.isEmpty() ? null : Title.title((Component)SERIALIZER.deserialize(Settings.IMP.MAIN.STRINGS.LOGIN_FLOODGATE_TITLE), (Component)SERIALIZER.deserialize(Settings.IMP.MAIN.STRINGS.LOGIN_FLOODGATE_SUBTITLE), (Title.Times)Settings.IMP.MAIN.PREMIUM_TITLE_SETTINGS.toTimes());
        this.bruteforceAttemptKick = SERIALIZER.deserialize(Settings.IMP.MAIN.STRINGS.LOGIN_WRONG_PASSWORD_KICK);
        this.nicknameInvalidKick = SERIALIZER.deserialize(Settings.IMP.MAIN.STRINGS.NICKNAME_INVALID_KICK);
        this.reconnectKick = SERIALIZER.deserialize(Settings.IMP.MAIN.STRINGS.RECONNECT_KICK);
        this.registrationsDisabledKick = SERIALIZER.deserialize(Settings.IMP.MAIN.STRINGS.REGISTRATIONS_DISABLED_KICK);
        if (Settings.IMP.MAIN.CHECK_PASSWORD_STRENGTH) {
            try {
                this.unsafePasswords.clear();
                Path unsafePasswordsPath = Paths.get(this.dataDirectoryFile.getAbsolutePath(), Settings.IMP.MAIN.UNSAFE_PASSWORDS_FILE);
                if (!unsafePasswordsPath.toFile().exists()) {
                    Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/unsafe_passwords.txt")), unsafePasswordsPath, new CopyOption[0]);
                }
                try (Stream<String> unsafePasswordsStream = Files.lines(unsafePasswordsPath);){
                    this.unsafePasswords.addAll(unsafePasswordsStream.collect(Collectors.toList()));
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.cachedAuthChecks.clear();
        this.premiumCache.clear();
        this.bruteforceCache.clear();
        Settings.DATABASE dbConfig = Settings.IMP.DATABASE;
        DatabaseLibrary databaseLibrary = dbConfig.STORAGE_TYPE;
        try {
            this.connectionSource = databaseLibrary.connectToORM(this.dataDirectoryFile.toPath().toAbsolutePath(), dbConfig.HOSTNAME, dbConfig.DATABASE + dbConfig.CONNECTION_PARAMETERS, dbConfig.USER, dbConfig.PASSWORD);
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.nicknameValidationPattern = Pattern.compile(Settings.IMP.MAIN.ALLOWED_NICKNAME_REGEX);
        try {
            block32: {
                try {
                    TableUtils.createTableIfNotExists(this.connectionSource, RegisteredPlayer.class);
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("CREATE INDEX")) break block32;
                    throw e;
                }
            }
            this.playerDao = DaoManager.createDao(this.connectionSource, RegisteredPlayer.class);
            this.migrateDb(this.playerDao);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        CommandManager manager = this.server.getCommandManager();
        manager.unregister("unregister");
        manager.unregister("forceregister");
        manager.unregister("premium");
        manager.unregister("forceunregister");
        manager.unregister("changepassword");
        manager.unregister("forcechangepassword");
        manager.unregister("destroysession");
        manager.unregister("2fa");
        manager.unregister("limboauth");
        manager.register("unregister", (Command)new UnregisterCommand(this, this.playerDao), new String[]{"unreg"});
        manager.register("forceregister", (Command)new ForceRegisterCommand(this, this.playerDao), new String[]{"forcereg"});
        manager.register("premium", (Command)new PremiumCommand(this, this.playerDao), new String[]{"license"});
        manager.register("forceunregister", (Command)new ForceUnregisterCommand(this, this.server, this.playerDao), new String[]{"forceunreg"});
        manager.register("changepassword", (Command)new ChangePasswordCommand(this, this.playerDao), new String[]{"changepass", "cp"});
        manager.register("forcechangepassword", (Command)new ForceChangePasswordCommand(this, this.server, this.playerDao), new String[]{"forcechangepass", "fcp"});
        manager.register("destroysession", (Command)new DestroySessionCommand(this), new String[]{"logout"});
        if (Settings.IMP.MAIN.ENABLE_TOTP) {
            manager.register("2fa", (Command)new TotpCommand(this.playerDao), new String[]{"totp"});
        }
        manager.register("limboauth", (Command)new LimboAuthCommand(this), new String[]{"la", "auth", "lauth"});
        Settings.MAIN.AUTH_COORDS authCoords = Settings.IMP.MAIN.AUTH_COORDS;
        VirtualWorld authWorld = this.factory.createVirtualWorld(Settings.IMP.MAIN.DIMENSION, authCoords.X, authCoords.Y, authCoords.Z, (float)authCoords.YAW, (float)authCoords.PITCH);
        if (Settings.IMP.MAIN.LOAD_WORLD) {
            try {
                Path path = this.dataDirectory.resolve(Settings.IMP.MAIN.WORLD_FILE_PATH);
                WorldFile file = this.factory.openWorldFile(Settings.IMP.MAIN.WORLD_FILE_TYPE, path);
                Settings.MAIN.WORLD_COORDS coords = Settings.IMP.MAIN.WORLD_COORDS;
                file.toWorld(this.factory, authWorld, coords.X, coords.Y, coords.Z, Settings.IMP.MAIN.WORLD_LIGHT_LEVEL);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.authServer != null) {
            this.authServer.dispose();
        }
        this.authServer = this.factory.createLimbo(authWorld).setName("LimboAuth").setWorldTime(Settings.IMP.MAIN.WORLD_TICKS).setGameMode(Settings.IMP.MAIN.GAME_MODE).registerCommand(new LimboCommandMeta(this.filterCommands(Settings.IMP.MAIN.REGISTER_COMMAND))).registerCommand(new LimboCommandMeta(this.filterCommands(Settings.IMP.MAIN.LOGIN_COMMAND)));
        if (Settings.IMP.MAIN.ENABLE_TOTP) {
            this.authServer.registerCommand(new LimboCommandMeta(this.filterCommands(Settings.IMP.MAIN.TOTP_COMMAND)));
        }
        EventManager eventManager = this.server.getEventManager();
        eventManager.unregisterListeners((Object)this);
        eventManager.register((Object)this, (Object)new AuthListener(this, this.playerDao, this.floodgateApi));
        if (this.purgeCacheTask != null) {
            this.purgeCacheTask.cancel();
        }
        this.purgeCacheTask = this.server.getScheduler().buildTask((Object)this, () -> this.checkCache(this.cachedAuthChecks, Settings.IMP.MAIN.PURGE_CACHE_MILLIS)).delay(Settings.IMP.MAIN.PURGE_CACHE_MILLIS, TimeUnit.MILLISECONDS).repeat(Settings.IMP.MAIN.PURGE_CACHE_MILLIS, TimeUnit.MILLISECONDS).schedule();
        if (this.purgePremiumCacheTask != null) {
            this.purgePremiumCacheTask.cancel();
        }
        this.purgePremiumCacheTask = this.server.getScheduler().buildTask((Object)this, () -> this.checkCache(this.premiumCache, Settings.IMP.MAIN.PURGE_PREMIUM_CACHE_MILLIS)).delay(Settings.IMP.MAIN.PURGE_PREMIUM_CACHE_MILLIS, TimeUnit.MILLISECONDS).repeat(Settings.IMP.MAIN.PURGE_PREMIUM_CACHE_MILLIS, TimeUnit.MILLISECONDS).schedule();
        if (this.purgeBruteforceCacheTask != null) {
            this.purgeBruteforceCacheTask.cancel();
        }
        this.purgeBruteforceCacheTask = this.server.getScheduler().buildTask((Object)this, () -> this.checkCache(this.bruteforceCache, Settings.IMP.MAIN.PURGE_BRUTEFORCE_CACHE_MILLIS)).delay(Settings.IMP.MAIN.PURGE_BRUTEFORCE_CACHE_MILLIS, TimeUnit.MILLISECONDS).repeat(Settings.IMP.MAIN.PURGE_BRUTEFORCE_CACHE_MILLIS, TimeUnit.MILLISECONDS).schedule();
        eventManager.fireAndForget((Object)new AuthPluginReloadEvent());
    }

    private List<String> filterCommands(List<String> commands) {
        return commands.stream().filter(command -> command.startsWith("/")).map(command -> command.substring(1)).collect(Collectors.toList());
    }

    private void checkCache(Map<?, ? extends CachedUser> userMap, long time) {
        userMap.entrySet().stream().filter(userEntry -> ((CachedUser)userEntry.getValue()).getCheckTime() + time <= System.currentTimeMillis()).map(Map.Entry::getKey).forEach(userMap::remove);
    }

    public void migrateDb(Dao<?, ?> dao) {
        String findSql;
        TableInfo<?, ?> tableInfo = dao.getTableInfo();
        HashSet tables = new HashSet();
        Collections.addAll(tables, tableInfo.getFieldTypes());
        String database = Settings.IMP.DATABASE.DATABASE;
        String tableName = tableInfo.getTableName();
        DatabaseLibrary databaseLibrary = Settings.IMP.DATABASE.STORAGE_TYPE;
        switch (databaseLibrary) {
            case SQLITE: {
                findSql = "SELECT name FROM PRAGMA_TABLE_INFO('" + tableName + "')";
                break;
            }
            case H2: {
                findSql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '" + tableName + "';";
                break;
            }
            case POSTGRESQL: {
                findSql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_CATALOG = '" + database + "' AND TABLE_NAME = '" + tableName + "';";
                break;
            }
            case MARIADB: 
            case MYSQL: {
                findSql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" + database + "' AND TABLE_NAME = '" + tableName + "';";
                break;
            }
            default: {
                LOGGER.error("WRONG DATABASE TYPE.");
                this.server.shutdown();
                return;
            }
        }
        try (GenericRawResults<String[]> queryResult = dao.queryRaw(findSql, new String[0]);){
            queryResult.forEach(result -> tables.removeIf(table -> table.getColumnName().equalsIgnoreCase(result[0])));
            tables.forEach(table -> {
                try {
                    StringBuilder builder = new StringBuilder("ALTER TABLE ");
                    if (databaseLibrary == DatabaseLibrary.POSTGRESQL) {
                        builder.append('\"');
                    }
                    builder.append(tableName);
                    if (databaseLibrary == DatabaseLibrary.POSTGRESQL) {
                        builder.append('\"');
                    }
                    builder.append(" ADD ");
                    String columnDefinition = table.getColumnDefinition();
                    DatabaseType databaseType = dao.getConnectionSource().getDatabaseType();
                    if (columnDefinition == null) {
                        List<String> dummy = List.of();
                        databaseType.appendColumnArg(table.getTableName(), builder, (FieldType)table, dummy, dummy, dummy, dummy);
                    } else {
                        databaseType.appendEscapedEntityName(builder, table.getColumnName());
                        builder.append(" ").append(columnDefinition).append(" ");
                    }
                    dao.executeRawNoArgs(builder.toString());
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
    }

    public void cacheAuthUser(Player player) {
        String username = player.getUsername();
        String lowercaseUsername = username.toLowerCase(Locale.ROOT);
        this.cachedAuthChecks.put(lowercaseUsername, new CachedSessionUser(System.currentTimeMillis(), player.getRemoteAddress().getAddress(), username));
    }

    public void removePlayerFromCache(String username) {
        this.removePlayerFromCacheLowercased(username.toLowerCase(Locale.ROOT));
    }

    public void removePlayerFromCacheLowercased(String username) {
        this.cachedAuthChecks.remove(username);
        this.premiumCache.remove(username);
    }

    public boolean needAuth(Player player) {
        String username = player.getUsername();
        String lowercaseUsername = username.toLowerCase(Locale.ROOT);
        if (!this.cachedAuthChecks.containsKey(lowercaseUsername)) {
            return true;
        }
        CachedSessionUser sessionUser = this.cachedAuthChecks.get(lowercaseUsername);
        return !sessionUser.getInetAddress().equals(player.getRemoteAddress().getAddress()) || !sessionUser.getUsername().equals(username);
    }

    public void authPlayer(Player player) {
        boolean isFloodgate;
        boolean bl = isFloodgate = !Settings.IMP.MAIN.FLOODGATE_NEED_AUTH && this.floodgateApi.isFloodgatePlayer(player.getUniqueId());
        if (!isFloodgate && this.isForcedPreviously(player.getUsername()) && this.isPremium(player.getUsername())) {
            player.disconnect(this.reconnectKick);
            return;
        }
        if (this.getBruteforceAttempts(player.getRemoteAddress().getAddress()) >= Settings.IMP.MAIN.BRUTEFORCE_MAX_ATTEMPTS) {
            player.disconnect(this.bruteforceAttemptKick);
            return;
        }
        String nickname = player.getUsername();
        if (!this.nicknameValidationPattern.matcher(isFloodgate ? nickname.substring(this.floodgateApi.getPrefixLength()) : nickname).matches()) {
            player.disconnect(this.nicknameInvalidKick);
            return;
        }
        RegisteredPlayer registeredPlayer = AuthSessionHandler.fetchInfo(this.playerDao, nickname);
        boolean onlineMode = player.isOnlineMode();
        TaskEvent.Result result = TaskEvent.Result.NORMAL;
        if ((onlineMode || isFloodgate) && (registeredPlayer == null || registeredPlayer.getHash().isEmpty())) {
            RegisteredPlayer nicknameRegisteredPlayer = registeredPlayer;
            registeredPlayer = AuthSessionHandler.fetchInfo(this.playerDao, player.getUniqueId());
            if (nicknameRegisteredPlayer != null && registeredPlayer == null && nicknameRegisteredPlayer.getHash().isEmpty()) {
                registeredPlayer = nicknameRegisteredPlayer;
                registeredPlayer.setPremiumUuid(player.getUniqueId().toString());
                try {
                    this.playerDao.update(registeredPlayer);
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException(e);
                }
            }
            if (nicknameRegisteredPlayer == null && registeredPlayer == null && Settings.IMP.MAIN.SAVE_PREMIUM_ACCOUNTS) {
                registeredPlayer = new RegisteredPlayer(player).setPremiumUuid(player.getUniqueId());
                try {
                    this.playerDao.create(registeredPlayer);
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException(e);
                }
            }
            if (registeredPlayer == null || registeredPlayer.getHash().isEmpty()) {
                this.postLoginTasks.put(player.getUniqueId(), () -> {
                    if (onlineMode) {
                        if (this.loginPremium != null) {
                            player.sendMessage(this.loginPremium);
                        }
                        if (this.loginPremiumTitle != null) {
                            player.showTitle(this.loginPremiumTitle);
                        }
                    } else {
                        if (this.loginFloodgate != null) {
                            player.sendMessage(this.loginFloodgate);
                        }
                        if (this.loginFloodgateTitle != null) {
                            player.showTitle(this.loginFloodgateTitle);
                        }
                    }
                });
                result = TaskEvent.Result.BYPASS;
            }
        }
        EventManager eventManager = this.server.getEventManager();
        if (registeredPlayer == null) {
            if (Settings.IMP.MAIN.DISABLE_REGISTRATIONS) {
                player.disconnect(this.registrationsDisabledKick);
                return;
            }
            Consumer<TaskEvent> eventConsumer = event -> this.sendPlayer((TaskEvent)event, null);
            eventManager.fire((Object)new PreRegisterEvent(eventConsumer, result, player)).thenAcceptAsync(eventConsumer);
        } else {
            Consumer<TaskEvent> eventConsumer = event -> this.sendPlayer((TaskEvent)event, ((PreAuthorizationEvent)event).getPlayerInfo());
            eventManager.fire((Object)new PreAuthorizationEvent(eventConsumer, result, player, registeredPlayer)).thenAcceptAsync(eventConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPlayer(TaskEvent event, RegisteredPlayer registeredPlayer) {
        Player player = ((PreEvent)event).getPlayer();
        switch (event.getResult()) {
            case BYPASS: {
                try {
                    this.cacheAuthUser(player);
                    try {
                        this.updateLoginData(player);
                        break;
                    }
                    catch (SQLException e) {
                        throw new SQLRuntimeException(e);
                    }
                }
                finally {
                    this.factory.passLoginLimbo(player);
                }
            }
            case CANCEL: {
                player.disconnect(event.getReason());
                break;
            }
            case WAIT: {
                return;
            }
            default: {
                this.authServer.spawnPlayer(player, (LimboSessionHandler)new AuthSessionHandler(this.playerDao, player, this, registeredPlayer));
            }
        }
    }

    public void updateLoginData(Player player) throws SQLException {
        String lowercaseNickname = player.getUsername().toLowerCase(Locale.ROOT);
        UpdateBuilder<RegisteredPlayer, String> updateBuilder = this.playerDao.updateBuilder();
        updateBuilder.where().eq("username", lowercaseNickname);
        updateBuilder.updateColumnValue("ip", player.getRemoteAddress().getAddress().getHostAddress());
        updateBuilder.updateColumnValue("lastlogin", System.currentTimeMillis());
        updateBuilder.update();
        if (Settings.IMP.MAIN.MOD.ENABLED) {
            byte[] lowercaseNicknameSerialized = lowercaseNickname.getBytes(StandardCharsets.UTF_8);
            long issueTime = System.currentTimeMillis();
            long hash = SipHasher.init(Settings.IMP.MAIN.MOD.VERIFY_KEY).update(lowercaseNicknameSerialized).update(Longs.toByteArray((long)issueTime)).digest();
            player.sendPluginMessage(this.getChannelIdentifier(player), Bytes.concat((byte[][])new byte[][]{Longs.toByteArray((long)issueTime), Longs.toByteArray((long)hash)}));
        }
    }

    public ChannelIdentifier getChannelIdentifier(Player player) {
        return player.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_13) >= 0 ? MOD_CHANNEL : LEGACY_MOD_CHANNEL;
    }

    private boolean validateScheme(JsonElement jsonElement, List<String> scheme) {
        if (!scheme.isEmpty()) {
            if (!(jsonElement instanceof JsonObject)) {
                return false;
            }
            JsonObject object = (JsonObject)jsonElement;
            for (String field : scheme) {
                if (object.has(field)) continue;
                return false;
            }
        }
        return true;
    }

    public PremiumResponse isPremiumExternal(String nickname) {
        try {
            HttpResponse<String> response = this.client.send(HttpRequest.newBuilder().uri(URI.create(String.format(Settings.IMP.MAIN.ISPREMIUM_AUTH_URL, URLEncoder.encode(nickname, StandardCharsets.UTF_8)))).build(), HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            if (Settings.IMP.MAIN.STATUS_CODE_RATE_LIMIT.contains(statusCode)) {
                return new PremiumResponse(PremiumState.RATE_LIMIT);
            }
            JsonElement jsonElement = JsonParser.parseString((String)response.body());
            if (Settings.IMP.MAIN.STATUS_CODE_USER_EXISTS.contains(statusCode) && this.validateScheme(jsonElement, Settings.IMP.MAIN.USER_EXISTS_JSON_VALIDATOR_FIELDS)) {
                return new PremiumResponse(PremiumState.PREMIUM_USERNAME, ((JsonObject)jsonElement).get(Settings.IMP.MAIN.JSON_UUID_FIELD).getAsString());
            }
            if (Settings.IMP.MAIN.STATUS_CODE_USER_NOT_EXISTS.contains(statusCode) && this.validateScheme(jsonElement, Settings.IMP.MAIN.USER_NOT_EXISTS_JSON_VALIDATOR_FIELDS)) {
                return new PremiumResponse(PremiumState.CRACKED);
            }
            return new PremiumResponse(PremiumState.ERROR);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Unable to authenticate with Mojang.", (Throwable)e);
            return new PremiumResponse(PremiumState.ERROR);
        }
    }

    public PremiumResponse isPremiumInternal(String nickname) {
        try {
            QueryBuilder<RegisteredPlayer, String> crackedCountQuery = this.playerDao.queryBuilder();
            crackedCountQuery.where().eq("username", nickname).and().ne("password", "");
            crackedCountQuery.setCountOf(true);
            QueryBuilder<RegisteredPlayer, String> premiumCountQuery = this.playerDao.queryBuilder();
            premiumCountQuery.where().eq("username", nickname).and().eq("password", "");
            premiumCountQuery.setCountOf(true);
            if (this.playerDao.countOf(crackedCountQuery.prepare()) != 0L) {
                return new PremiumResponse(PremiumState.CRACKED);
            }
            if (this.playerDao.countOf(premiumCountQuery.prepare()) != 0L) {
                return new PremiumResponse(PremiumState.PREMIUM);
            }
            return new PremiumResponse(PremiumState.UNKNOWN);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to check if account is premium.", (Throwable)e);
            return new PremiumResponse(PremiumState.ERROR);
        }
    }

    public boolean isPremiumUuid(UUID uuid) {
        try {
            QueryBuilder<RegisteredPlayer, String> premiumCountQuery = this.playerDao.queryBuilder();
            premiumCountQuery.where().eq("PREMIUMUUID", uuid.toString()).and().eq("password", "");
            premiumCountQuery.setCountOf(true);
            return this.playerDao.countOf(premiumCountQuery.prepare()) != 0L;
        }
        catch (SQLException e) {
            LOGGER.error("Unable to check if account is premium.", (Throwable)e);
            return false;
        }
    }

    @SafeVarargs
    private boolean checkIsPremiumAndCache(String nickname, Function<String, PremiumResponse> ... functions) {
        String lowercaseNickname = nickname.toLowerCase(Locale.ROOT);
        if (this.premiumCache.containsKey(lowercaseNickname)) {
            return this.premiumCache.get(lowercaseNickname).isPremium();
        }
        boolean premium = false;
        boolean unknown = false;
        boolean wasRateLimited = false;
        boolean wasError = false;
        UUID uuid = null;
        block7: for (Function<String, PremiumResponse> function : functions) {
            PremiumResponse check = function.apply(lowercaseNickname);
            if (check.getUuid() != null) {
                uuid = check.getUuid();
            }
            switch (check.getState()) {
                case CRACKED: {
                    return this.setPremium(lowercaseNickname, false).isPremium();
                }
                case PREMIUM: {
                    CachedPremiumUser premiumUser = this.setPremium(lowercaseNickname, true);
                    premiumUser.setForcePremium(true);
                    return premiumUser.isPremium();
                }
                case PREMIUM_USERNAME: {
                    premium = true;
                    continue block7;
                }
                case UNKNOWN: {
                    unknown = true;
                    continue block7;
                }
                case RATE_LIMIT: {
                    wasRateLimited = true;
                    continue block7;
                }
                default: {
                    wasError = true;
                }
            }
        }
        if (unknown) {
            if (uuid != null && this.isPremiumUuid(uuid)) {
                CachedPremiumUser premiumUser = this.setPremium(lowercaseNickname, true);
                premiumUser.setForcePremium(true);
                return premiumUser.isPremium();
            }
            if (Settings.IMP.MAIN.ONLINE_MODE_NEED_AUTH) {
                return false;
            }
        }
        if (wasRateLimited && unknown || wasRateLimited && wasError) {
            return Settings.IMP.MAIN.ON_RATE_LIMIT_PREMIUM;
        }
        if (wasError && unknown || !premium) {
            return Settings.IMP.MAIN.ON_SERVER_ERROR_PREMIUM;
        }
        return this.setPremium(lowercaseNickname, true).isPremium();
    }

    public boolean isPremium(String nickname) {
        if (Settings.IMP.MAIN.FORCE_OFFLINE_MODE) {
            return false;
        }
        if (Settings.IMP.MAIN.CHECK_PREMIUM_PRIORITY_INTERNAL) {
            return this.checkIsPremiumAndCache(nickname, this::isPremiumInternal, this::isPremiumExternal);
        }
        return this.checkIsPremiumAndCache(nickname, this::isPremiumExternal, this::isPremiumInternal);
    }

    public CachedPremiumUser getPremiumCache(String nickname) {
        return this.premiumCache.get(nickname.toLowerCase(Locale.ROOT));
    }

    public CachedPremiumUser setPremium(String lowercasedNickname, boolean value) {
        CachedPremiumUser premiumUser = new CachedPremiumUser(System.currentTimeMillis(), value);
        this.premiumCache.put(lowercasedNickname, premiumUser);
        return premiumUser;
    }

    public void incrementBruteforceAttempts(InetAddress address) {
        this.getBruteforceUser(address).incrementAttempts();
    }

    public int getBruteforceAttempts(InetAddress address) {
        return this.getBruteforceUser(address).getAttempts();
    }

    private CachedBruteforceUser getBruteforceUser(InetAddress address) {
        CachedBruteforceUser user = this.bruteforceCache.get(address);
        if (user == null) {
            user = new CachedBruteforceUser(System.currentTimeMillis());
            this.bruteforceCache.put(address, user);
        }
        return user;
    }

    public void clearBruteforceAttempts(InetAddress address) {
        this.bruteforceCache.remove(address);
    }

    public void saveForceOfflineMode(String nickname) {
        this.forcedPreviously.add(nickname);
    }

    public void unsetForcedPreviously(String nickname) {
        this.forcedPreviously.remove(nickname);
    }

    public boolean isForcedPreviously(String nickname) {
        return this.forcedPreviously.contains(nickname);
    }

    public Set<String> getPendingLogins() {
        return this.pendingLogins;
    }

    public Map<UUID, Runnable> getPostLoginTasks() {
        return this.postLoginTasks;
    }

    public Set<String> getUnsafePasswords() {
        return this.unsafePasswords;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public Dao<RegisteredPlayer, String> getPlayerDao() {
        return this.playerDao;
    }

    private static void setLogger(Logger logger) {
        LOGGER = logger;
    }

    private static void setSerializer(Serializer serializer) {
        SERIALIZER = serializer;
    }

    public static Serializer getSerializer() {
        return SERIALIZER;
    }

    public Limbo getAuthServer() {
        return this.authServer;
    }

    public Pattern getNicknameValidationPattern() {
        return this.nicknameValidationPattern;
    }

    private static class CachedSessionUser
    extends CachedUser {
        private final InetAddress inetAddress;
        private final String username;

        public CachedSessionUser(long checkTime, InetAddress inetAddress, String username) {
            super(checkTime);
            this.inetAddress = inetAddress;
            this.username = username;
        }

        public InetAddress getInetAddress() {
            return this.inetAddress;
        }

        public String getUsername() {
            return this.username;
        }
    }

    public static class PremiumResponse {
        private final PremiumState state;
        private final UUID uuid;

        public PremiumResponse(PremiumState state) {
            this.state = state;
            this.uuid = null;
        }

        public PremiumResponse(PremiumState state, UUID uuid) {
            this.state = state;
            this.uuid = uuid;
        }

        public PremiumResponse(PremiumState state, String uuid) {
            this.state = state;
            this.uuid = uuid.contains("-") ? UUID.fromString(uuid) : new UUID(Long.parseUnsignedLong(uuid.substring(0, 16), 16), Long.parseUnsignedLong(uuid.substring(16), 16));
        }

        public PremiumState getState() {
            return this.state;
        }

        public UUID getUuid() {
            return this.uuid;
        }
    }

    public static enum PremiumState {
        PREMIUM,
        PREMIUM_USERNAME,
        CRACKED,
        UNKNOWN,
        RATE_LIMIT,
        ERROR;

    }

    public static class CachedPremiumUser
    extends CachedUser {
        private final boolean premium;
        private boolean forcePremium;

        public CachedPremiumUser(long checkTime, boolean premium) {
            super(checkTime);
            this.premium = premium;
        }

        public void setForcePremium(boolean forcePremium) {
            this.forcePremium = forcePremium;
        }

        public boolean isForcePremium() {
            return this.forcePremium;
        }

        public boolean isPremium() {
            return this.premium;
        }
    }

    private static class CachedBruteforceUser
    extends CachedUser {
        private int attempts;

        public CachedBruteforceUser(long checkTime) {
            super(checkTime);
        }

        public void incrementAttempts() {
            ++this.attempts;
        }

        public int getAttempts() {
            return this.attempts;
        }
    }

    public static class CachedUser {
        private final long checkTime;

        public CachedUser(long checkTime) {
            this.checkTime = checkTime;
        }

        public long getCheckTime() {
            return this.checkTime;
        }
    }
}

