/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.command;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.permission.PermissionSubject;
import com.velocitypowered.api.proxy.ProxyServer;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import net.elytrium.limboapi.thirdparty.commons.kyori.serialization.Serializer;
import net.elytrium.limboapi.thirdparty.commons.velocity.commands.SuggestUtils;
import net.elytrium.limboauth.LimboAuth;
import net.elytrium.limboauth.Settings;
import net.elytrium.limboauth.command.RatelimitedCommand;
import net.elytrium.limboauth.event.AuthUnregisterEvent;
import net.elytrium.limboauth.model.RegisteredPlayer;
import net.elytrium.limboauth.model.SQLRuntimeException;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.Dao;
import net.kyori.adventure.text.Component;

public class ForceUnregisterCommand
extends RatelimitedCommand {
    private final LimboAuth plugin;
    private final ProxyServer server;
    private final Dao<RegisteredPlayer, String> playerDao;
    private final Component kick;
    private final String successful;
    private final String notSuccessful;
    private final Component usage;

    public ForceUnregisterCommand(LimboAuth plugin, ProxyServer server, Dao<RegisteredPlayer, String> playerDao) {
        this.plugin = plugin;
        this.server = server;
        this.playerDao = playerDao;
        Serializer serializer = LimboAuth.getSerializer();
        this.kick = serializer.deserialize(Settings.IMP.MAIN.STRINGS.FORCE_UNREGISTER_KICK);
        this.successful = Settings.IMP.MAIN.STRINGS.FORCE_UNREGISTER_SUCCESSFUL;
        this.notSuccessful = Settings.IMP.MAIN.STRINGS.FORCE_UNREGISTER_NOT_SUCCESSFUL;
        this.usage = serializer.deserialize(Settings.IMP.MAIN.STRINGS.FORCE_UNREGISTER_USAGE);
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        return SuggestUtils.suggestPlayers((ProxyServer)this.server, (String[])((String[])invocation.arguments()), (int)0, (String[])new String[0]);
    }

    @Override
    public void execute(CommandSource source, String[] args) {
        if (args.length == 1) {
            String playerNick = args[0];
            String usernameLowercased = playerNick.toLowerCase(Locale.ROOT);
            Serializer serializer = LimboAuth.getSerializer();
            try {
                this.plugin.getServer().getEventManager().fireAndForget((Object)new AuthUnregisterEvent(playerNick));
                this.playerDao.deleteById(usernameLowercased);
                this.plugin.removePlayerFromCacheLowercased(usernameLowercased);
                this.server.getPlayer(playerNick).ifPresent(player -> player.disconnect(this.kick));
                source.sendMessage(serializer.deserialize(MessageFormat.format(this.successful, playerNick)));
            }
            catch (SQLException e) {
                source.sendMessage(serializer.deserialize(MessageFormat.format(this.notSuccessful, playerNick)));
                throw new SQLRuntimeException(e);
            }
        } else {
            source.sendMessage(this.usage);
        }
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return Settings.IMP.MAIN.COMMAND_PERMISSION_STATE.FORCE_UNREGISTER.hasPermission((PermissionSubject)invocation.source(), "limboauth.admin.forceunregister");
    }
}

