/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.command;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.permission.PermissionSubject;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.elytrium.limboauth.LimboAuth;
import net.elytrium.limboauth.Settings;
import net.elytrium.limboauth.command.CommandPermissionState;
import net.elytrium.limboauth.command.RatelimitedCommand;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class LimboAuthCommand
extends RatelimitedCommand {
    private static final List<Component> HELP_MESSAGE = List.of(Component.text((String)"This server is using LimboAuth and LimboAPI.", (TextColor)NamedTextColor.YELLOW), Component.text((String)"(C) 2021 - 2024 Elytrium", (TextColor)NamedTextColor.YELLOW), Component.text((String)"https://elytrium.net/github/", (TextColor)NamedTextColor.GREEN), Component.empty());
    private static final Component AVAILABLE_SUBCOMMANDS_MESSAGE = Component.text((String)"Available subcommands:", (TextColor)NamedTextColor.WHITE);
    private static final Component NO_AVAILABLE_SUBCOMMANDS_MESSAGE = Component.text((String)"There is no available subcommands for you.", (TextColor)NamedTextColor.WHITE);
    private final LimboAuth plugin;

    public LimboAuthCommand(LimboAuth plugin) {
        this.plugin = plugin;
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            return Arrays.stream(Subcommand.values()).filter(command -> command.hasPermission(source)).map(Subcommand::getCommand).collect(Collectors.toList());
        }
        if (args.length == 1) {
            String argument = args[0];
            return Arrays.stream(Subcommand.values()).filter(command -> command.hasPermission(source)).map(Subcommand::getCommand).filter(str -> str.regionMatches(true, 0, argument, 0, argument.length())).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    @Override
    public void execute(CommandSource source, String[] args) {
        int argsAmount = args.length;
        if (argsAmount > 0) {
            try {
                Subcommand subcommand = Subcommand.valueOf(args[0].toUpperCase(Locale.ROOT));
                if (!subcommand.hasPermission(source)) {
                    this.showHelp(source);
                    return;
                }
                subcommand.executor.execute(this, source, args);
            }
            catch (IllegalArgumentException e) {
                this.showHelp(source);
            }
        } else {
            this.showHelp(source);
        }
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return Settings.IMP.MAIN.COMMAND_PERMISSION_STATE.HELP.hasPermission((PermissionSubject)invocation.source(), "limboauth.commands.help");
    }

    private void showHelp(CommandSource source) {
        HELP_MESSAGE.forEach(arg_0 -> ((CommandSource)source).sendMessage(arg_0));
        List<Subcommand> availableSubcommands = Arrays.stream(Subcommand.values()).filter(command -> command.hasPermission(source)).collect(Collectors.toList());
        if (availableSubcommands.size() > 0) {
            source.sendMessage(AVAILABLE_SUBCOMMANDS_MESSAGE);
            availableSubcommands.forEach(command -> source.sendMessage(command.getMessageLine()));
        } else {
            source.sendMessage(NO_AVAILABLE_SUBCOMMANDS_MESSAGE);
        }
    }

    private static enum Subcommand {
        RELOAD("Reload config.", Settings.IMP.MAIN.COMMAND_PERMISSION_STATE.RELOAD, (parent, source, args) -> {
            parent.plugin.reload();
            source.sendMessage(LimboAuth.getSerializer().deserialize(Settings.IMP.MAIN.STRINGS.RELOAD));
        });

        private final String command;
        private final String description;
        private final CommandPermissionState permissionState;
        private final SubcommandExecutor executor;

        private Subcommand(String description, CommandPermissionState permissionState, SubcommandExecutor executor) {
            this.permissionState = permissionState;
            this.command = this.name().toLowerCase(Locale.ROOT);
            this.description = description;
            this.executor = executor;
        }

        public boolean hasPermission(CommandSource source) {
            return this.permissionState.hasPermission((PermissionSubject)source, "limboauth.admin." + this.command);
        }

        public Component getMessageLine() {
            return Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.text((String)("  /limboauth " + this.command), (TextColor)NamedTextColor.GREEN), Component.text((String)" - ", (TextColor)NamedTextColor.DARK_GRAY), Component.text((String)this.description, (TextColor)NamedTextColor.YELLOW)});
        }

        public String getCommand() {
            return this.command;
        }
    }

    private static interface SubcommandExecutor {
        public void execute(LimboAuthCommand var1, CommandSource var2, String[] var3);
    }
}

