/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.command;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.permission.PermissionSubject;
import com.velocitypowered.api.proxy.Player;
import java.sql.SQLException;
import java.util.Locale;
import net.elytrium.limboapi.thirdparty.commons.kyori.serialization.Serializer;
import net.elytrium.limboauth.LimboAuth;
import net.elytrium.limboauth.Settings;
import net.elytrium.limboauth.command.RatelimitedCommand;
import net.elytrium.limboauth.handler.AuthSessionHandler;
import net.elytrium.limboauth.model.RegisteredPlayer;
import net.elytrium.limboauth.model.SQLRuntimeException;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.Dao;
import net.kyori.adventure.text.Component;

public class PremiumCommand
extends RatelimitedCommand {
    private final LimboAuth plugin;
    private final Dao<RegisteredPlayer, String> playerDao;
    private final String confirmKeyword;
    private final Component notRegistered;
    private final Component alreadyPremium;
    private final Component successful;
    private final Component errorOccurred;
    private final Component notPremium;
    private final Component wrongPassword;
    private final Component usage;
    private final Component notPlayer;

    public PremiumCommand(LimboAuth plugin, Dao<RegisteredPlayer, String> playerDao) {
        this.plugin = plugin;
        this.playerDao = playerDao;
        Serializer serializer = LimboAuth.getSerializer();
        this.confirmKeyword = Settings.IMP.MAIN.CONFIRM_KEYWORD;
        this.notRegistered = serializer.deserialize(Settings.IMP.MAIN.STRINGS.NOT_REGISTERED);
        this.alreadyPremium = serializer.deserialize(Settings.IMP.MAIN.STRINGS.ALREADY_PREMIUM);
        this.successful = serializer.deserialize(Settings.IMP.MAIN.STRINGS.PREMIUM_SUCCESSFUL);
        this.errorOccurred = serializer.deserialize(Settings.IMP.MAIN.STRINGS.ERROR_OCCURRED);
        this.notPremium = serializer.deserialize(Settings.IMP.MAIN.STRINGS.NOT_PREMIUM);
        this.wrongPassword = serializer.deserialize(Settings.IMP.MAIN.STRINGS.WRONG_PASSWORD);
        this.usage = serializer.deserialize(Settings.IMP.MAIN.STRINGS.PREMIUM_USAGE);
        this.notPlayer = serializer.deserialize(Settings.IMP.MAIN.STRINGS.NOT_PLAYER);
    }

    @Override
    public void execute(CommandSource source, String[] args) {
        if (source instanceof Player) {
            if (args.length == 2 && this.confirmKeyword.equalsIgnoreCase(args[1])) {
                String usernameLowercase = ((Player)source).getUsername().toLowerCase(Locale.ROOT);
                RegisteredPlayer player = AuthSessionHandler.fetchInfoLowercased(this.playerDao, usernameLowercase);
                if (player == null) {
                    source.sendMessage(this.notRegistered);
                } else if (player.getHash().isEmpty()) {
                    source.sendMessage(this.alreadyPremium);
                } else if (AuthSessionHandler.checkPassword(args[0], player, this.playerDao)) {
                    if (this.plugin.isPremiumExternal(usernameLowercase).getState() == LimboAuth.PremiumState.PREMIUM_USERNAME) {
                        try {
                            player.setHash("");
                            this.playerDao.update(player);
                            this.plugin.removePlayerFromCacheLowercased(usernameLowercase);
                            ((Player)source).disconnect(this.successful);
                        }
                        catch (SQLException e) {
                            source.sendMessage(this.errorOccurred);
                            throw new SQLRuntimeException(e);
                        }
                    } else {
                        source.sendMessage(this.notPremium);
                    }
                } else {
                    source.sendMessage(this.wrongPassword);
                }
                return;
            }
            source.sendMessage(this.usage);
        } else {
            source.sendMessage(this.notPlayer);
        }
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return Settings.IMP.MAIN.COMMAND_PERMISSION_STATE.PREMIUM.hasPermission((PermissionSubject)invocation.source(), "limboauth.commands.premium");
    }
}

