/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.command;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.permission.PermissionSubject;
import com.velocitypowered.api.proxy.Player;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import net.elytrium.limboapi.thirdparty.commons.kyori.serialization.Serializer;
import net.elytrium.limboauth.LimboAuth;
import net.elytrium.limboauth.Settings;
import net.elytrium.limboauth.command.RatelimitedCommand;
import net.elytrium.limboauth.handler.AuthSessionHandler;
import net.elytrium.limboauth.model.RegisteredPlayer;
import net.elytrium.limboauth.model.SQLRuntimeException;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.Dao;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt.UpdateBuilder;
import net.elytrium.limboauth.thirdparty.dev.samstevens.totp.qr.QrData;
import net.elytrium.limboauth.thirdparty.dev.samstevens.totp.recovery.RecoveryCodeGenerator;
import net.elytrium.limboauth.thirdparty.dev.samstevens.totp.secret.DefaultSecretGenerator;
import net.elytrium.limboauth.thirdparty.dev.samstevens.totp.secret.SecretGenerator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;

public class TotpCommand
extends RatelimitedCommand {
    private final SecretGenerator secretGenerator = new DefaultSecretGenerator();
    private final RecoveryCodeGenerator codesGenerator = new RecoveryCodeGenerator();
    private final Dao<RegisteredPlayer, String> playerDao;
    private final Component notPlayer;
    private final Component usage;
    private final boolean needPassword;
    private final Component notRegistered;
    private final Component wrongPassword;
    private final Component alreadyEnabled;
    private final Component errorOccurred;
    private final Component successful;
    private final String issuer;
    private final String qrGeneratorUrl;
    private final Component qr;
    private final String token;
    private final int recoveryCodesAmount;
    private final String recovery;
    private final Component disabled;
    private final Component wrong;
    private final Component crackedCommand;

    public TotpCommand(Dao<RegisteredPlayer, String> playerDao) {
        this.playerDao = playerDao;
        Serializer serializer = LimboAuth.getSerializer();
        this.notPlayer = serializer.deserialize(Settings.IMP.MAIN.STRINGS.NOT_PLAYER);
        this.usage = serializer.deserialize(Settings.IMP.MAIN.STRINGS.TOTP_USAGE);
        this.needPassword = Settings.IMP.MAIN.TOTP_NEED_PASSWORD;
        this.notRegistered = serializer.deserialize(Settings.IMP.MAIN.STRINGS.NOT_REGISTERED);
        this.wrongPassword = serializer.deserialize(Settings.IMP.MAIN.STRINGS.WRONG_PASSWORD);
        this.alreadyEnabled = serializer.deserialize(Settings.IMP.MAIN.STRINGS.TOTP_ALREADY_ENABLED);
        this.errorOccurred = serializer.deserialize(Settings.IMP.MAIN.STRINGS.ERROR_OCCURRED);
        this.successful = serializer.deserialize(Settings.IMP.MAIN.STRINGS.TOTP_SUCCESSFUL);
        this.issuer = Settings.IMP.MAIN.TOTP_ISSUER;
        this.qrGeneratorUrl = Settings.IMP.MAIN.QR_GENERATOR_URL;
        this.qr = serializer.deserialize(Settings.IMP.MAIN.STRINGS.TOTP_QR);
        this.token = Settings.IMP.MAIN.STRINGS.TOTP_TOKEN;
        this.recoveryCodesAmount = Settings.IMP.MAIN.TOTP_RECOVERY_CODES_AMOUNT;
        this.recovery = Settings.IMP.MAIN.STRINGS.TOTP_RECOVERY;
        this.disabled = serializer.deserialize(Settings.IMP.MAIN.STRINGS.TOTP_DISABLED);
        this.wrong = serializer.deserialize(Settings.IMP.MAIN.STRINGS.TOTP_WRONG);
        this.crackedCommand = serializer.deserialize(Settings.IMP.MAIN.STRINGS.CRACKED_COMMAND);
    }

    @Override
    public void execute(CommandSource source, String[] args) {
        if (source instanceof Player) {
            if (args.length == 0) {
                source.sendMessage(this.usage);
            } else {
                String username = ((Player)source).getUsername();
                String usernameLowercase = username.toLowerCase(Locale.ROOT);
                if (args[0].equalsIgnoreCase("enable")) {
                    if (this.needPassword ? args.length == 2 : args.length == 1) {
                        RegisteredPlayer playerInfo = AuthSessionHandler.fetchInfoLowercased(this.playerDao, usernameLowercase);
                        if (playerInfo == null) {
                            source.sendMessage(this.notRegistered);
                            return;
                        }
                        if (playerInfo.getHash().isEmpty()) {
                            source.sendMessage(this.crackedCommand);
                            return;
                        }
                        if (this.needPassword && !AuthSessionHandler.checkPassword(args[1], playerInfo, this.playerDao)) {
                            source.sendMessage(this.wrongPassword);
                            return;
                        }
                        if (!playerInfo.getTotpToken().isEmpty()) {
                            source.sendMessage(this.alreadyEnabled);
                            return;
                        }
                        String secret = this.secretGenerator.generate();
                        try {
                            UpdateBuilder<RegisteredPlayer, String> updateBuilder = this.playerDao.updateBuilder();
                            updateBuilder.where().eq("username", usernameLowercase);
                            updateBuilder.updateColumnValue("TOTPTOKEN", secret);
                            updateBuilder.update();
                        }
                        catch (SQLException e) {
                            source.sendMessage(this.errorOccurred);
                            throw new SQLRuntimeException(e);
                        }
                        source.sendMessage(this.successful);
                        QrData data = new QrData.Builder().label(username).secret(secret).issuer(this.issuer).build();
                        String qrUrl = this.qrGeneratorUrl.replace("{data}", URLEncoder.encode(data.getUri(), StandardCharsets.UTF_8));
                        source.sendMessage(this.qr.clickEvent(ClickEvent.openUrl((String)qrUrl)));
                        Serializer serializer = LimboAuth.getSerializer();
                        source.sendMessage(serializer.deserialize(MessageFormat.format(this.token, secret)).clickEvent(ClickEvent.copyToClipboard((String)secret)));
                        String codes = String.join((CharSequence)", ", this.codesGenerator.generateCodes(this.recoveryCodesAmount));
                        source.sendMessage(serializer.deserialize(MessageFormat.format(this.recovery, codes)).clickEvent(ClickEvent.copyToClipboard((String)codes)));
                    } else {
                        source.sendMessage(this.usage);
                    }
                } else if (args[0].equalsIgnoreCase("disable")) {
                    if (args.length == 2) {
                        RegisteredPlayer playerInfo = AuthSessionHandler.fetchInfoLowercased(this.playerDao, usernameLowercase);
                        if (playerInfo == null) {
                            source.sendMessage(this.notRegistered);
                            return;
                        }
                        if (AuthSessionHandler.TOTP_CODE_VERIFIER.isValidCode(playerInfo.getTotpToken(), args[1])) {
                            try {
                                UpdateBuilder<RegisteredPlayer, String> updateBuilder = this.playerDao.updateBuilder();
                                updateBuilder.where().eq("username", usernameLowercase);
                                updateBuilder.updateColumnValue("TOTPTOKEN", "");
                                updateBuilder.update();
                                source.sendMessage(this.disabled);
                            }
                            catch (SQLException e) {
                                source.sendMessage(this.errorOccurred);
                                throw new SQLRuntimeException(e);
                            }
                        } else {
                            source.sendMessage(this.wrong);
                        }
                    } else {
                        source.sendMessage(this.usage);
                    }
                } else {
                    source.sendMessage(this.usage);
                }
            }
        } else {
            source.sendMessage(this.notPlayer);
        }
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return Settings.IMP.MAIN.COMMAND_PERMISSION_STATE.TOTP.hasPermission((PermissionSubject)invocation.source(), "limboauth.commands.totp");
    }
}

