/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.dependencies;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public enum BaseLibrary {
    H2_V1("com.h2database", "h2", "1.4.200"),
    H2_V2("com.h2database", "h2", "2.1.214"),
    MYSQL("com.mysql", "mysql-connector-j", "8.0.33"),
    MARIADB("org.mariadb.jdbc", "mariadb-java-client", "3.1.4"),
    POSTGRESQL("org.postgresql", "postgresql", "42.5.1"),
    SQLITE("org.xerial", "sqlite-jdbc", "3.40.0.0");

    private final Path filenamePath;
    private final URL mavenRepoURL;

    private BaseLibrary(String groupId, String artifactId, String version) {
        String mavenPath = String.format("%s/%s/%s/%s-%s.jar", groupId.replace(".", "/"), artifactId, version, artifactId, version);
        this.filenamePath = Path.of("libraries/" + mavenPath, new String[0]);
        try {
            this.mavenRepoURL = new URL("https://repo1.maven.org/maven2/" + mavenPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public URL getClassLoaderURL() throws MalformedURLException {
        if (!Files.exists(this.filenamePath, new LinkOption[0])) {
            try (InputStream in = this.mavenRepoURL.openStream();){
                Files.createDirectories(this.filenamePath.getParent(), new FileAttribute[0]);
                Files.copy(in, Files.createFile(this.filenamePath, new FileAttribute[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.filenamePath.toUri().toURL();
    }
}

