/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.dependencies;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import net.elytrium.limboauth.dependencies.BaseLibrary;
import net.elytrium.limboauth.dependencies.IsolatedClassLoader;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.jdbc.db.DatabaseTypeUtils;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.support.ConnectionSource;

public enum DatabaseLibrary {
    H2_LEGACY_V1(BaseLibrary.H2_V1, (classLoader, dir, jdbc, user, password) -> DatabaseLibrary.fromDriver(classLoader.loadClass("org.h2.Driver"), jdbc, null, null, false), (dir, hostname, database) -> "jdbc:h2:" + dir + "/limboauth"),
    H2(BaseLibrary.H2_V2, (classLoader, dir, jdbc, user, password) -> {
        Connection modernConnection = DatabaseLibrary.fromDriver(classLoader.loadClass("org.h2.Driver"), jdbc, null, null, true);
        Path legacyDatabase = dir.resolve("limboauth.mv.db");
        if (Files.exists(legacyDatabase, new LinkOption[0])) {
            Path dumpFile = dir.resolve("limboauth.dump.sql");
            try (Connection legacyConnection = H2_LEGACY_V1.connect(dir, null, null, user, password);
                 PreparedStatement migrateStatement = legacyConnection.prepareStatement("SCRIPT TO '?'");){
                migrateStatement.setString(1, dumpFile.toString());
                migrateStatement.execute();
            }
            try (PreparedStatement migrateStatement = modernConnection.prepareStatement("RUNSCRIPT FROM '?'");){
                migrateStatement.setString(1, dumpFile.toString());
                migrateStatement.execute();
            }
            Files.delete(dumpFile);
            Files.move(legacyDatabase, dir.resolve("limboauth-v1-backup.mv.db"), new CopyOption[0]);
        }
        return modernConnection;
    }, (dir, hostname, database) -> "jdbc:h2:" + dir + "/limboauth-v2"),
    MYSQL(BaseLibrary.MYSQL, (classLoader, dir, jdbc, user, password) -> DatabaseLibrary.fromDriver(classLoader.loadClass("com.mysql.cj.jdbc.NonRegisteringDriver"), jdbc, user, password, true), (dir, hostname, database) -> "jdbc:mysql://" + hostname + "/" + database),
    MARIADB(BaseLibrary.MARIADB, (classLoader, dir, jdbc, user, password) -> DatabaseLibrary.fromDriver(classLoader.loadClass("org.mariadb.jdbc.Driver"), jdbc, user, password, true), (dir, hostname, database) -> "jdbc:mariadb://" + hostname + "/" + database),
    POSTGRESQL(BaseLibrary.POSTGRESQL, (classLoader, dir, jdbc, user, password) -> DatabaseLibrary.fromDriver(classLoader.loadClass("org.postgresql.Driver"), jdbc, user, password, true), (dir, hostname, database) -> "jdbc:postgresql://" + hostname + "/" + database),
    SQLITE(BaseLibrary.SQLITE, (classLoader, dir, jdbc, user, password) -> DatabaseLibrary.fromDriver(classLoader.loadClass("org.sqlite.JDBC"), jdbc, user, password, true), (dir, hostname, database) -> "jdbc:sqlite:" + dir + "/limboauth.db");

    private final BaseLibrary baseLibrary;
    private final DatabaseConnector connector;
    private final DatabaseStringGetter stringGetter;

    private DatabaseLibrary(BaseLibrary baseLibrary, DatabaseConnector connector, DatabaseStringGetter stringGetter) {
        this.baseLibrary = baseLibrary;
        this.connector = connector;
        this.stringGetter = stringGetter;
    }

    public Connection connect(ClassLoader classLoader, Path dir, String hostname, String database, String user, String password) throws ReflectiveOperationException, SQLException, IOException {
        return this.connect(classLoader, dir, this.stringGetter.getJdbcString(dir, hostname, database), user, password);
    }

    public Connection connect(Path dir, String hostname, String database, String user, String password) throws ReflectiveOperationException, SQLException, IOException {
        return this.connect(dir, this.stringGetter.getJdbcString(dir, hostname, database), user, password);
    }

    public Connection connect(ClassLoader classLoader, Path dir, String jdbc, String user, String password) throws ReflectiveOperationException, SQLException, IOException {
        return this.connector.connect(classLoader, dir, jdbc, user, password);
    }

    public Connection connect(Path dir, String jdbc, String user, String password) throws IOException, ReflectiveOperationException, SQLException {
        return this.connector.connect(new IsolatedClassLoader(new URL[]{this.baseLibrary.getClassLoaderURL()}), dir, jdbc, user, password);
    }

    public ConnectionSource connectToORM(Path dir, String hostname, String database, String user, String password) throws ReflectiveOperationException, IOException, SQLException, URISyntaxException {
        String jdbc = this.stringGetter.getJdbcString(dir, hostname, database);
        URL baseLibraryURL = this.baseLibrary.getClassLoaderURL();
        ClassLoader currentClassLoader = DatabaseLibrary.class.getClassLoader();
        Method addPath = currentClassLoader.getClass().getDeclaredMethod("addPath", Path.class);
        addPath.setAccessible(true);
        addPath.invoke((Object)currentClassLoader, Path.of(baseLibraryURL.toURI()));
        this.connect(currentClassLoader, dir, jdbc, user, password).close();
        boolean h2 = this.baseLibrary == BaseLibrary.H2_V1 || this.baseLibrary == BaseLibrary.H2_V2;
        return new JdbcPooledConnectionSource(jdbc, h2 ? null : user, h2 ? null : password, DatabaseTypeUtils.createDatabaseType(jdbc));
    }

    private static Connection fromDriver(Class<?> connectionClass, String jdbc, String user, String password, boolean register) throws ReflectiveOperationException, SQLException {
        Constructor<?> legacyConstructor = connectionClass.getConstructor(new Class[0]);
        Properties info = new Properties();
        if (user != null) {
            info.put("user", user);
        }
        if (password != null) {
            info.put("password", password);
        }
        Object driver = legacyConstructor.newInstance(new Object[0]);
        DriverManager.deregisterDriver((Driver)driver);
        if (register) {
            DriverManager.registerDriver((Driver)driver);
        }
        Method connect = connectionClass.getDeclaredMethod("connect", String.class, Properties.class);
        connect.setAccessible(true);
        return (Connection)connect.invoke(driver, jdbc, info);
    }

    public static interface DatabaseConnector {
        public Connection connect(ClassLoader var1, Path var2, String var3, String var4, String var5) throws ReflectiveOperationException, SQLException, IOException;
    }

    public static interface DatabaseStringGetter {
        public String getJdbcString(Path var1, String var2, String var3);
    }
}

