/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.handler;

import com.google.common.primitives.Longs;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import io.netty.buffer.ByteBuf;
import io.whitfin.siphash.SipHasher;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.elytrium.limboapi.api.Limbo;
import net.elytrium.limboapi.api.LimboSessionHandler;
import net.elytrium.limboapi.api.player.LimboPlayer;
import net.elytrium.limboapi.thirdparty.commons.kyori.serialization.Serializer;
import net.elytrium.limboauth.LimboAuth;
import net.elytrium.limboauth.Settings;
import net.elytrium.limboauth.event.PostAuthorizationEvent;
import net.elytrium.limboauth.event.PostRegisterEvent;
import net.elytrium.limboauth.event.TaskEvent;
import net.elytrium.limboauth.migration.MigrationHash;
import net.elytrium.limboauth.model.RegisteredPlayer;
import net.elytrium.limboauth.model.SQLRuntimeException;
import net.elytrium.limboauth.thirdparty.at.favre.lib.crypto.bcrypt.BCrypt;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.Dao;
import net.elytrium.limboauth.thirdparty.dev.samstevens.totp.code.CodeVerifier;
import net.elytrium.limboauth.thirdparty.dev.samstevens.totp.code.DefaultCodeGenerator;
import net.elytrium.limboauth.thirdparty.dev.samstevens.totp.code.DefaultCodeVerifier;
import net.elytrium.limboauth.thirdparty.dev.samstevens.totp.time.SystemTimeProvider;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthSessionHandler
implements LimboSessionHandler {
    public static final CodeVerifier TOTP_CODE_VERIFIER = new DefaultCodeVerifier(new DefaultCodeGenerator(), new SystemTimeProvider());
    private static final BCrypt.Verifyer HASH_VERIFIER = BCrypt.verifyer();
    private static final BCrypt.Hasher HASHER = BCrypt.withDefaults();
    private static Component ratelimited;
    private static BossBar.Color bossbarColor;
    private static BossBar.Overlay bossbarOverlay;
    private static Component ipLimitKick;
    private static Component databaseErrorKick;
    private static String wrongNicknameCaseKick;
    private static Component timesUp;
    private static Component registerSuccessful;
    private static @Nullable Title registerSuccessfulTitle;
    private static Component[] loginWrongPassword;
    private static Component loginWrongPasswordKick;
    private static Component totp;
    private static @Nullable Title totpTitle;
    private static Component register;
    private static @Nullable Title registerTitle;
    private static Component[] login;
    private static @Nullable Title loginTitle;
    private static Component registerDifferentPasswords;
    private static Component registerPasswordTooLong;
    private static Component registerPasswordTooShort;
    private static Component registerPasswordUnsafe;
    private static Component loginSuccessful;
    private static Component sessionExpired;
    private static @Nullable Title loginSuccessfulTitle;
    private static @Nullable MigrationHash migrationHash;
    private final Dao<RegisteredPlayer, String> playerDao;
    private final Player proxyPlayer;
    private final LimboAuth plugin;
    private final long joinTime = System.currentTimeMillis();
    private final BossBar bossBar = BossBar.bossBar((Component)Component.empty(), (float)1.0f, (BossBar.Color)bossbarColor, (BossBar.Overlay)bossbarOverlay);
    private final boolean loginOnlyByMod;
    private @Nullable RegisteredPlayer playerInfo;
    private ScheduledFuture<?> authMainTask;
    private LimboPlayer player;
    private int attempts;
    private boolean totpState;
    private String tempPassword;
    private boolean tokenReceived;

    public AuthSessionHandler(Dao<RegisteredPlayer, String> playerDao, Player proxyPlayer, LimboAuth plugin, @Nullable RegisteredPlayer playerInfo) {
        this.loginOnlyByMod = Settings.IMP.MAIN.MOD.ENABLED && Settings.IMP.MAIN.MOD.LOGIN_ONLY_BY_MOD;
        this.attempts = Settings.IMP.MAIN.LOGIN_ATTEMPTS;
        this.playerDao = playerDao;
        this.proxyPlayer = proxyPlayer;
        this.plugin = plugin;
        this.playerInfo = playerInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onSpawn(Limbo server, LimboPlayer player) {
        Serializer serializer;
        block12: {
            this.player = player;
            if (Settings.IMP.MAIN.DISABLE_FALLING) {
                this.player.disableFalling();
            } else {
                this.player.enableFalling();
            }
            serializer = LimboAuth.getSerializer();
            if (this.playerInfo == null) {
                try {
                    String ip = this.proxyPlayer.getRemoteAddress().getAddress().getHostAddress();
                    List<RegisteredPlayer> alreadyRegistered = this.playerDao.queryForEq("creationIP", ip);
                    if (alreadyRegistered != null) {
                        int sizeOfValidRegistrations = alreadyRegistered.size();
                        if (Settings.IMP.MAIN.IP_LIMIT_VALID_TIME > 0L) {
                            for (RegisteredPlayer registeredPlayer : alreadyRegistered) {
                                if (registeredPlayer.getRegDate().getTime() >= System.currentTimeMillis() - Settings.IMP.MAIN.IP_LIMIT_VALID_TIME) continue;
                                registeredPlayer.setIP("");
                                this.playerDao.update(registeredPlayer);
                                --sizeOfValidRegistrations;
                            }
                        }
                        if (sizeOfValidRegistrations >= Settings.IMP.MAIN.IP_LIMIT_REGISTRATIONS) {
                            this.proxyPlayer.disconnect(ipLimitKick);
                            return;
                        }
                    }
                    break block12;
                }
                catch (SQLException e) {
                    this.proxyPlayer.disconnect(databaseErrorKick);
                    throw new SQLRuntimeException(e);
                }
            }
            if (!this.proxyPlayer.getUsername().equals(this.playerInfo.getNickname())) {
                this.proxyPlayer.disconnect(serializer.deserialize(MessageFormat.format(wrongNicknameCaseKick, this.playerInfo.getNickname(), this.proxyPlayer.getUsername())));
                return;
            }
        }
        boolean bossBarEnabled = !this.loginOnlyByMod && Settings.IMP.MAIN.ENABLE_BOSSBAR;
        int authTime = Settings.IMP.MAIN.AUTH_TIME;
        float multiplier = 1000.0f / (float)authTime;
        this.authMainTask = this.player.getScheduledExecutor().scheduleWithFixedDelay(() -> {
            if (System.currentTimeMillis() - this.joinTime > (long)authTime) {
                this.proxyPlayer.disconnect(timesUp);
            } else if (bossBarEnabled) {
                float secondsLeft = (float)((long)authTime - (System.currentTimeMillis() - this.joinTime)) / 1000.0f;
                this.bossBar.name(serializer.deserialize(MessageFormat.format(Settings.IMP.MAIN.STRINGS.BOSSBAR, (int)secondsLeft)));
                this.bossBar.progress(Math.min(1.0f, secondsLeft * multiplier));
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        if (bossBarEnabled) {
            this.proxyPlayer.showBossBar(this.bossBar);
        }
        if (!this.loginOnlyByMod) {
            this.sendMessage(true);
        }
    }

    public void onChat(String message) {
        if (this.loginOnlyByMod) {
            return;
        }
        if (!LimboAuth.RATELIMITER.attempt((Object)this.proxyPlayer.getRemoteAddress().getAddress())) {
            this.proxyPlayer.sendMessage(ratelimited);
            return;
        }
        String[] args = message.split(" ");
        if (args.length != 0 && this.checkArgsLength(args.length)) {
            Command command = Command.parse(args[0]);
            if (command == Command.REGISTER && !this.totpState && this.playerInfo == null) {
                String password = args[1];
                if (this.checkPasswordsRepeat(args) && this.checkPasswordLength(password) && this.checkPasswordStrength(password)) {
                    this.saveTempPassword(password);
                    RegisteredPlayer registeredPlayer = new RegisteredPlayer(this.proxyPlayer).setPassword(password);
                    try {
                        this.playerDao.create(registeredPlayer);
                        this.playerInfo = registeredPlayer;
                    }
                    catch (SQLException e) {
                        this.proxyPlayer.disconnect(databaseErrorKick);
                        throw new SQLRuntimeException(e);
                    }
                    this.proxyPlayer.sendMessage(registerSuccessful);
                    if (registerSuccessfulTitle != null) {
                        this.proxyPlayer.showTitle(registerSuccessfulTitle);
                    }
                    this.plugin.getServer().getEventManager().fire((Object)new PostRegisterEvent(this::finishAuth, this.player, this.playerInfo, this.tempPassword)).thenAcceptAsync(this::finishAuth);
                }
                return;
            }
            if (command == Command.LOGIN && !this.totpState && this.playerInfo != null) {
                String password = args[1];
                this.saveTempPassword(password);
                if (password.length() > 0 && AuthSessionHandler.checkPassword(password, this.playerInfo, this.playerDao)) {
                    if (this.playerInfo.getTotpToken().isEmpty()) {
                        this.finishLogin();
                    } else {
                        this.totpState = true;
                        this.sendMessage(true);
                    }
                } else if (--this.attempts != 0) {
                    this.proxyPlayer.sendMessage(loginWrongPassword[this.attempts - 1]);
                    this.checkBruteforceAttempts();
                } else {
                    this.proxyPlayer.disconnect(loginWrongPasswordKick);
                }
                return;
            }
            if (command == Command.TOTP && this.totpState && this.playerInfo != null) {
                if (TOTP_CODE_VERIFIER.isValidCode(this.playerInfo.getTotpToken(), args[1])) {
                    this.finishLogin();
                    return;
                }
                this.checkBruteforceAttempts();
            }
        }
        this.sendMessage(false);
    }

    public void onGeneric(Object packet) {
        if (Settings.IMP.MAIN.MOD.ENABLED && packet instanceof PluginMessagePacket) {
            PluginMessagePacket pluginMessage = (PluginMessagePacket)packet;
            String channel = pluginMessage.getChannel();
            if (channel.equals("MC|Brand") || channel.equals("minecraft:brand")) {
                if (Settings.IMP.MAIN.MOD.ENABLED) {
                    this.proxyPlayer.sendPluginMessage(this.plugin.getChannelIdentifier(this.proxyPlayer), new byte[0]);
                }
            } else if (channel.equals(this.plugin.getChannelIdentifier(this.proxyPlayer).getId())) {
                if (this.tokenReceived) {
                    this.checkBruteforceAttempts();
                    this.proxyPlayer.disconnect((Component)Component.empty());
                    return;
                }
                this.tokenReceived = true;
                if (this.playerInfo == null) {
                    return;
                }
                ByteBuf data = pluginMessage.content();
                if (data.readableBytes() < 16) {
                    this.checkBruteforceAttempts();
                    this.proxyPlayer.sendMessage(sessionExpired);
                    return;
                }
                long issueTime = data.readLong();
                long hash = data.readLong();
                if (this.playerInfo.getTokenIssuedAt() > issueTime) {
                    this.proxyPlayer.sendMessage(sessionExpired);
                    return;
                }
                byte[] lowercaseNicknameSerialized = this.playerInfo.getLowercaseNickname().getBytes(StandardCharsets.UTF_8);
                long correctHash = SipHasher.init(Settings.IMP.MAIN.MOD.VERIFY_KEY).update(lowercaseNicknameSerialized).update(Longs.toByteArray((long)issueTime)).digest();
                if (hash != correctHash) {
                    this.checkBruteforceAttempts();
                    this.proxyPlayer.sendMessage(sessionExpired);
                    return;
                }
                this.finishAuth();
            }
        }
    }

    private void checkBruteforceAttempts() {
        this.plugin.incrementBruteforceAttempts(this.proxyPlayer.getRemoteAddress().getAddress());
        if (this.plugin.getBruteforceAttempts(this.proxyPlayer.getRemoteAddress().getAddress()) >= Settings.IMP.MAIN.BRUTEFORCE_MAX_ATTEMPTS) {
            this.proxyPlayer.disconnect(loginWrongPasswordKick);
        }
    }

    private void saveTempPassword(String password) {
        this.tempPassword = password;
    }

    public void onDisconnect() {
        if (this.authMainTask != null) {
            this.authMainTask.cancel(true);
        }
        this.proxyPlayer.hideBossBar(this.bossBar);
    }

    private void sendMessage(boolean sendTitle) {
        if (this.totpState) {
            this.proxyPlayer.sendMessage(totp);
            if (sendTitle && totpTitle != null) {
                this.proxyPlayer.showTitle(totpTitle);
            }
        } else if (this.playerInfo == null) {
            this.proxyPlayer.sendMessage(register);
            if (sendTitle && registerTitle != null) {
                this.proxyPlayer.showTitle(registerTitle);
            }
        } else {
            this.proxyPlayer.sendMessage(login[this.attempts - 1]);
            if (sendTitle && loginTitle != null) {
                this.proxyPlayer.showTitle(loginTitle);
            }
        }
    }

    private boolean checkArgsLength(int argsLength) {
        if (this.playerInfo == null && Settings.IMP.MAIN.REGISTER_NEED_REPEAT_PASSWORD) {
            return argsLength == 3;
        }
        return argsLength == 2;
    }

    private boolean checkPasswordsRepeat(String[] args) {
        if (!Settings.IMP.MAIN.REGISTER_NEED_REPEAT_PASSWORD || args[1].equals(args[2])) {
            return true;
        }
        this.proxyPlayer.sendMessage(registerDifferentPasswords);
        return false;
    }

    private boolean checkPasswordLength(String password) {
        int length = password.length();
        if (length > Settings.IMP.MAIN.MAX_PASSWORD_LENGTH) {
            this.proxyPlayer.sendMessage(registerPasswordTooLong);
            return false;
        }
        if (length < Settings.IMP.MAIN.MIN_PASSWORD_LENGTH) {
            this.proxyPlayer.sendMessage(registerPasswordTooShort);
            return false;
        }
        return true;
    }

    private boolean checkPasswordStrength(String password) {
        if (Settings.IMP.MAIN.CHECK_PASSWORD_STRENGTH && this.plugin.getUnsafePasswords().contains(password)) {
            this.proxyPlayer.sendMessage(registerPasswordUnsafe);
            return false;
        }
        return true;
    }

    private void finishLogin() {
        this.proxyPlayer.sendMessage(loginSuccessful);
        if (loginSuccessfulTitle != null) {
            this.proxyPlayer.showTitle(loginSuccessfulTitle);
        }
        this.plugin.clearBruteforceAttempts(this.proxyPlayer.getRemoteAddress().getAddress());
        this.plugin.getServer().getEventManager().fire((Object)new PostAuthorizationEvent(this::finishAuth, this.player, this.playerInfo, this.tempPassword)).thenAcceptAsync(this::finishAuth);
    }

    private void finishAuth(TaskEvent event) {
        if (event.getResult() == TaskEvent.Result.CANCEL) {
            this.proxyPlayer.disconnect(event.getReason());
            return;
        }
        if (event.getResult() == TaskEvent.Result.WAIT) {
            return;
        }
        this.finishAuth();
    }

    private void finishAuth() {
        if (Settings.IMP.MAIN.CRACKED_TITLE_SETTINGS.CLEAR_AFTER_LOGIN) {
            this.proxyPlayer.clearTitle();
        }
        try {
            this.plugin.updateLoginData(this.proxyPlayer);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.plugin.cacheAuthUser(this.proxyPlayer);
        this.player.disconnect();
    }

    public static void reload() {
        int i;
        Serializer serializer = LimboAuth.getSerializer();
        ratelimited = serializer.deserialize(Settings.IMP.MAIN.STRINGS.RATELIMITED);
        bossbarColor = Settings.IMP.MAIN.BOSSBAR_COLOR;
        bossbarOverlay = Settings.IMP.MAIN.BOSSBAR_OVERLAY;
        ipLimitKick = serializer.deserialize(Settings.IMP.MAIN.STRINGS.IP_LIMIT_KICK);
        databaseErrorKick = serializer.deserialize(Settings.IMP.MAIN.STRINGS.DATABASE_ERROR_KICK);
        wrongNicknameCaseKick = Settings.IMP.MAIN.STRINGS.WRONG_NICKNAME_CASE_KICK;
        timesUp = serializer.deserialize(Settings.IMP.MAIN.STRINGS.TIMES_UP);
        registerSuccessful = serializer.deserialize(Settings.IMP.MAIN.STRINGS.REGISTER_SUCCESSFUL);
        registerSuccessfulTitle = Settings.IMP.MAIN.STRINGS.REGISTER_SUCCESSFUL_TITLE.isEmpty() && Settings.IMP.MAIN.STRINGS.REGISTER_SUCCESSFUL_SUBTITLE.isEmpty() ? null : Title.title((Component)serializer.deserialize(Settings.IMP.MAIN.STRINGS.REGISTER_SUCCESSFUL_TITLE), (Component)serializer.deserialize(Settings.IMP.MAIN.STRINGS.REGISTER_SUCCESSFUL_SUBTITLE), (Title.Times)Settings.IMP.MAIN.CRACKED_TITLE_SETTINGS.toTimes());
        int loginAttempts = Settings.IMP.MAIN.LOGIN_ATTEMPTS;
        loginWrongPassword = new Component[loginAttempts];
        for (i = 0; i < loginAttempts; ++i) {
            AuthSessionHandler.loginWrongPassword[i] = serializer.deserialize(MessageFormat.format(Settings.IMP.MAIN.STRINGS.LOGIN_WRONG_PASSWORD, i + 1));
        }
        loginWrongPasswordKick = serializer.deserialize(Settings.IMP.MAIN.STRINGS.LOGIN_WRONG_PASSWORD_KICK);
        totp = serializer.deserialize(Settings.IMP.MAIN.STRINGS.TOTP);
        totpTitle = Settings.IMP.MAIN.STRINGS.TOTP_TITLE.isEmpty() && Settings.IMP.MAIN.STRINGS.TOTP_SUBTITLE.isEmpty() ? null : Title.title((Component)serializer.deserialize(Settings.IMP.MAIN.STRINGS.TOTP_TITLE), (Component)serializer.deserialize(Settings.IMP.MAIN.STRINGS.TOTP_SUBTITLE), (Title.Times)Settings.IMP.MAIN.CRACKED_TITLE_SETTINGS.toTimes());
        register = serializer.deserialize(Settings.IMP.MAIN.STRINGS.REGISTER);
        registerTitle = Settings.IMP.MAIN.STRINGS.REGISTER_TITLE.isEmpty() && Settings.IMP.MAIN.STRINGS.REGISTER_SUBTITLE.isEmpty() ? null : Title.title((Component)serializer.deserialize(Settings.IMP.MAIN.STRINGS.REGISTER_TITLE), (Component)serializer.deserialize(Settings.IMP.MAIN.STRINGS.REGISTER_SUBTITLE), (Title.Times)Settings.IMP.MAIN.CRACKED_TITLE_SETTINGS.toTimes());
        login = new Component[loginAttempts];
        for (i = 0; i < loginAttempts; ++i) {
            AuthSessionHandler.login[i] = serializer.deserialize(MessageFormat.format(Settings.IMP.MAIN.STRINGS.LOGIN, i + 1));
        }
        loginTitle = Settings.IMP.MAIN.STRINGS.LOGIN_TITLE.isEmpty() && Settings.IMP.MAIN.STRINGS.LOGIN_SUBTITLE.isEmpty() ? null : Title.title((Component)serializer.deserialize(MessageFormat.format(Settings.IMP.MAIN.STRINGS.LOGIN_TITLE, loginAttempts)), (Component)serializer.deserialize(MessageFormat.format(Settings.IMP.MAIN.STRINGS.LOGIN_SUBTITLE, loginAttempts)), (Title.Times)Settings.IMP.MAIN.CRACKED_TITLE_SETTINGS.toTimes());
        registerDifferentPasswords = serializer.deserialize(Settings.IMP.MAIN.STRINGS.REGISTER_DIFFERENT_PASSWORDS);
        registerPasswordTooLong = serializer.deserialize(Settings.IMP.MAIN.STRINGS.REGISTER_PASSWORD_TOO_LONG);
        registerPasswordTooShort = serializer.deserialize(Settings.IMP.MAIN.STRINGS.REGISTER_PASSWORD_TOO_SHORT);
        registerPasswordUnsafe = serializer.deserialize(Settings.IMP.MAIN.STRINGS.REGISTER_PASSWORD_UNSAFE);
        loginSuccessful = serializer.deserialize(Settings.IMP.MAIN.STRINGS.LOGIN_SUCCESSFUL);
        sessionExpired = serializer.deserialize(Settings.IMP.MAIN.STRINGS.MOD_SESSION_EXPIRED);
        loginSuccessfulTitle = Settings.IMP.MAIN.STRINGS.LOGIN_SUCCESSFUL_TITLE.isEmpty() && Settings.IMP.MAIN.STRINGS.LOGIN_SUCCESSFUL_SUBTITLE.isEmpty() ? null : Title.title((Component)serializer.deserialize(Settings.IMP.MAIN.STRINGS.LOGIN_SUCCESSFUL_TITLE), (Component)serializer.deserialize(Settings.IMP.MAIN.STRINGS.LOGIN_SUCCESSFUL_SUBTITLE), (Title.Times)Settings.IMP.MAIN.CRACKED_TITLE_SETTINGS.toTimes());
        migrationHash = Settings.IMP.MAIN.MIGRATION_HASH;
    }

    public static boolean checkPassword(String password, RegisteredPlayer player, Dao<RegisteredPlayer, String> playerDao) {
        String hash = player.getHash();
        boolean isCorrect = AuthSessionHandler.HASH_VERIFIER.verify((byte[])password.getBytes((Charset)StandardCharsets.UTF_8), (byte[])hash.replace((CharSequence)"BCRYPT$", (CharSequence)"$2a$").getBytes((Charset)StandardCharsets.UTF_8)).verified;
        if (!isCorrect && migrationHash != null && (isCorrect = migrationHash.checkPassword(hash, password))) {
            player.setPassword(password);
            try {
                playerDao.update(player);
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
        }
        return isCorrect;
    }

    public static RegisteredPlayer fetchInfo(Dao<RegisteredPlayer, String> playerDao, UUID uuid) {
        try {
            List<RegisteredPlayer> playerList = playerDao.queryForEq("PREMIUMUUID", uuid.toString());
            return (playerList != null ? playerList.size() : 0) == 0 ? null : playerList.get(0);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    public static RegisteredPlayer fetchInfo(Dao<RegisteredPlayer, String> playerDao, String nickname) {
        return AuthSessionHandler.fetchInfoLowercased(playerDao, nickname.toLowerCase(Locale.ROOT));
    }

    public static RegisteredPlayer fetchInfoLowercased(Dao<RegisteredPlayer, String> playerDao, String nickname) {
        try {
            List<RegisteredPlayer> playerList = playerDao.queryForEq("username", nickname);
            return (playerList != null ? playerList.size() : 0) == 0 ? null : playerList.get(0);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Deprecated
    public static String genHash(String password) {
        return HASHER.hashToString(Settings.IMP.MAIN.BCRYPT_COST, password.toCharArray());
    }

    private static enum Command {
        INVALID,
        REGISTER,
        LOGIN,
        TOTP;


        static Command parse(String command) {
            if (Settings.IMP.MAIN.REGISTER_COMMAND.contains(command)) {
                return REGISTER;
            }
            if (Settings.IMP.MAIN.LOGIN_COMMAND.contains(command)) {
                return LOGIN;
            }
            if (Settings.IMP.MAIN.TOTP_COMMAND.contains(command)) {
                return TOTP;
            }
            return INVALID;
        }
    }
}

