/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.migration;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.elytrium.limboauth.migration.MigrationHashVerifier;
import net.elytrium.limboauth.thirdparty.de.mkammerer.argon2.Argon2;
import net.elytrium.limboauth.thirdparty.de.mkammerer.argon2.Argon2Factory;
import net.elytrium.limboauth.thirdparty.org.apache.commons.codec.binary.Hex;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public enum MigrationHash {
    AUTHME((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 4 && args[3].equals(MigrationHash.getDigest(MigrationHash.getDigest(password, "SHA-256") + args[2], "SHA-256"));
    }),
    AUTHME_NP((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 3 && args[2].equals(MigrationHash.getDigest(MigrationHash.getDigest(password, "SHA-256") + args[1], "SHA-256"));
    }),
    ARGON2(new Argon2Verifier()),
    SHA512_DBA((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 3 && args[2].equals(MigrationHash.getDigest(MigrationHash.getDigest(password, "SHA-512") + args[1], "SHA-512"));
    }),
    SHA512_NP((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 3 && args[2].equals(MigrationHash.getDigest(password + args[1], "SHA-512"));
    }),
    SHA512_P((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 4 && args[3].equals(MigrationHash.getDigest(password + args[2], "SHA-512"));
    }),
    SHA256_NP((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 3 && args[2].equals(MigrationHash.getDigest(password + args[1], "SHA-256"));
    }),
    SHA256_P((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 4 && args[3].equals(MigrationHash.getDigest(password + args[2], "SHA-256"));
    }),
    MD5((hash, password) -> hash.equals(MigrationHash.getDigest(password, "MD5"))),
    MOON_SHA256((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 3 && args[2].equals(MigrationHash.getDigest(MigrationHash.getDigest(password, "SHA-256"), "SHA-256"));
    }),
    SHA256_NO_SALT((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 3 && args[2].equals(MigrationHash.getDigest(password, "SHA-256"));
    }),
    SHA512_NO_SALT((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 3 && args[2].equals(MigrationHash.getDigest(password, "SHA-512"));
    }),
    SHA512_P_REVERSED_HASH((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 4 && args[2].equals(MigrationHash.getDigest(password + args[3], "SHA-512"));
    }),
    SHA512_NLOGIN((hash, password) -> {
        String[] args = hash.split("\\$");
        return args.length == 4 && args[2].equals(MigrationHash.getDigest(MigrationHash.getDigest(password, "SHA-512") + args[3], "SHA-512"));
    }),
    CRC32C((hash, password) -> hash.equals(Hashing.crc32c().hashString((CharSequence)password, StandardCharsets.UTF_8).toString())),
    PLAINTEXT(String::equals);

    private final MigrationHashVerifier verifier;

    private MigrationHash(MigrationHashVerifier verifier) {
        this.verifier = verifier;
    }

    public boolean checkPassword(String hash, String password) {
        return this.verifier.checkPassword(hash, password);
    }

    private static String getDigest(String string, String algorithm) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            messageDigest.update(string.getBytes(StandardCharsets.UTF_8));
            byte[] array = messageDigest.digest();
            return Hex.encodeHexString(array);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class Argon2Verifier
    implements MigrationHashVerifier {
        private @MonotonicNonNull Argon2 argon2;

        private Argon2Verifier() {
        }

        @Override
        public boolean checkPassword(String hash, String password) {
            if (this.argon2 == null) {
                this.argon2 = Argon2Factory.create();
            }
            return this.argon2.verify(hash, password.getBytes(StandardCharsets.UTF_8));
        }
    }
}

