/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.BaseForeignCollection;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.CloseableIterator;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.CloseableWrappedIterable;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.Dao;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.FieldType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.support.DatabaseResults;

public class EagerForeignCollection<T, ID>
extends BaseForeignCollection<T, ID>
implements CloseableWrappedIterable<T>,
Serializable,
List<T> {
    private static final long serialVersionUID = -2523335606983317721L;
    private List<T> results;

    public EagerForeignCollection(Dao<T, ID> dao, Object parent, Object parentId, FieldType foreignFieldType, String orderColumn, boolean orderAscending) throws SQLException {
        super(dao, parent, parentId, foreignFieldType, orderColumn, orderAscending);
        this.results = parentId == null ? new ArrayList<T>() : dao.query(this.getPreparedQuery());
    }

    @Override
    public CloseableIterator<T> iterator() {
        return this.iteratorThrow(-1);
    }

    @Override
    public CloseableIterator<T> iterator(int flags) {
        return this.iteratorThrow(flags);
    }

    @Override
    public CloseableIterator<T> closeableIterator() {
        return this.iteratorThrow(-1);
    }

    @Override
    public CloseableIterator<T> closeableIterator(int flags) {
        return this.iteratorThrow(-1);
    }

    @Override
    public CloseableIterator<T> iteratorThrow() {
        return this.iteratorThrow(-1);
    }

    @Override
    public CloseableIterator<T> iteratorThrow(int flags) {
        return new CloseableIterator<T>(){
            private int offset = -1;

            @Override
            public boolean hasNext() {
                return this.offset + 1 < EagerForeignCollection.this.results.size();
            }

            @Override
            public T first() {
                this.offset = 0;
                if (this.offset >= EagerForeignCollection.this.results.size()) {
                    return null;
                }
                return EagerForeignCollection.this.results.get(0);
            }

            @Override
            public T next() {
                ++this.offset;
                return EagerForeignCollection.this.results.get(this.offset);
            }

            @Override
            public T nextThrow() {
                ++this.offset;
                if (this.offset >= EagerForeignCollection.this.results.size()) {
                    return null;
                }
                return EagerForeignCollection.this.results.get(this.offset);
            }

            @Override
            public T current() {
                if (this.offset < 0) {
                    this.offset = 0;
                }
                if (this.offset >= EagerForeignCollection.this.results.size()) {
                    return null;
                }
                return EagerForeignCollection.this.results.get(this.offset);
            }

            @Override
            public T previous() {
                --this.offset;
                if (this.offset < 0 || this.offset >= EagerForeignCollection.this.results.size()) {
                    return null;
                }
                return EagerForeignCollection.this.results.get(this.offset);
            }

            @Override
            public T moveRelative(int relativeOffset) {
                this.offset += relativeOffset;
                if (this.offset < 0 || this.offset >= EagerForeignCollection.this.results.size()) {
                    return null;
                }
                return EagerForeignCollection.this.results.get(this.offset);
            }

            @Override
            public T moveAbsolute(int position) {
                this.offset = position;
                if (this.offset < 0 || this.offset >= EagerForeignCollection.this.results.size()) {
                    return null;
                }
                return EagerForeignCollection.this.results.get(this.offset);
            }

            @Override
            public void remove() {
                if (this.offset < 0) {
                    throw new IllegalStateException("next() must be called before remove()");
                }
                if (this.offset >= EagerForeignCollection.this.results.size()) {
                    throw new IllegalStateException("current results position (" + this.offset + ") is out of bounds");
                }
                Object removed = EagerForeignCollection.this.results.remove(this.offset);
                --this.offset;
                if (EagerForeignCollection.this.dao != null) {
                    try {
                        EagerForeignCollection.this.dao.delete(removed);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public void closeQuietly() {
            }

            @Override
            public DatabaseResults getRawResults() {
                return null;
            }

            @Override
            public void moveToNext() {
                ++this.offset;
            }
        };
    }

    @Override
    public CloseableWrappedIterable<T> getWrappedIterable() {
        return this;
    }

    @Override
    public CloseableWrappedIterable<T> getWrappedIterable(int flags) {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void closeLastIterator() {
    }

    @Override
    public boolean isEager() {
        return true;
    }

    @Override
    public int size() {
        return this.results.size();
    }

    @Override
    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.results.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.results.containsAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.results.toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.results.toArray(array);
    }

    @Override
    public boolean add(T data) {
        if (this.results.add(data)) {
            return super.add(data);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (this.results.addAll(collection)) {
            return super.addAll(collection);
        }
        return false;
    }

    @Override
    public boolean remove(Object data) {
        if (!this.results.remove(data) || this.dao == null) {
            return false;
        }
        Object castData = data;
        try {
            return this.dao.delete(castData) == 1;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not delete data element from dao", e);
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object data : collection) {
            if (!this.remove(data)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return super.retainAll(collection);
    }

    @Override
    public int updateAll() throws SQLException {
        int updatedC = 0;
        for (T data : this.results) {
            updatedC += this.dao.update(data);
        }
        return updatedC;
    }

    @Override
    public int refreshAll() throws SQLException {
        int updatedC = 0;
        for (T data : this.results) {
            updatedC += this.dao.refresh(data);
        }
        return updatedC;
    }

    @Override
    public int refreshCollection() throws SQLException {
        this.results = this.dao.query(this.getPreparedQuery());
        return this.results.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException("addAll() at an index is not supported by foreign-collections, use addAll()");
    }

    @Override
    public T get(int index) {
        return this.results.get(index);
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("setting an element at an index is not supported by foreign-collections, use update");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("adding an element at an index is not supported by foreign-collections");
    }

    @Override
    public T remove(int index) {
        T result = this.results.get(0);
        this.remove(result);
        return result;
    }

    @Override
    public int indexOf(Object element) {
        return this.results.indexOf(element);
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.results.lastIndexOf(element);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.results.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.results.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.results.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EagerForeignCollection)) {
            return false;
        }
        EagerForeignCollection other = (EagerForeignCollection)obj;
        return this.results.equals(other.results);
    }

    @Override
    public int hashCode() {
        return this.results.hashCode();
    }
}

