/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.types;

import java.math.BigDecimal;
import java.sql.SQLException;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.FieldType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.SqlType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.types.BaseDataType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.support.DatabaseResults;

public class BigDecimalNumericType
extends BaseDataType {
    private static final BigDecimalNumericType singleTon = new BigDecimalNumericType();

    public static BigDecimalNumericType getSingleton() {
        return singleTon;
    }

    private BigDecimalNumericType() {
        super(SqlType.BIG_DECIMAL);
    }

    protected BigDecimalNumericType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        try {
            return new BigDecimal(defaultStr);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Problems with field " + fieldType + " parsing default BigDecimal string '" + defaultStr + "'", e);
        }
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getBigDecimal(columnPos);
    }

    @Override
    public boolean isAppropriateId() {
        return false;
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public Class<?> getPrimaryClass() {
        return BigDecimal.class;
    }
}

