/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.types;

import java.sql.SQLException;
import java.util.Date;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.FieldType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.SqlType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.types.BaseDateType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.support.DatabaseResults;

public class DateLongType
extends BaseDateType {
    private static final DateLongType singleTon = new DateLongType();

    public static DateLongType getSingleton() {
        return singleTon;
    }

    private DateLongType() {
        super(SqlType.LONG);
    }

    protected DateLongType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        try {
            return Long.parseLong(defaultStr);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Problems with field " + fieldType + " parsing default date-long value: " + defaultStr, e);
        }
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getLong(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        return new Date((Long)sqlArg);
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        Date date = (Date)obj;
        return date.getTime();
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public Class<?> getPrimaryClass() {
        return Date.class;
    }
}

