/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.types;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.FieldType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.SqlType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.types.BaseEnumType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.support.DatabaseResults;

public class EnumIntegerType
extends BaseEnumType {
    private static final EnumIntegerType singleTon = new EnumIntegerType();

    public static EnumIntegerType getSingleton() {
        return singleTon;
    }

    private EnumIntegerType() {
        super(SqlType.INTEGER);
    }

    protected EnumIntegerType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return Integer.parseInt(defaultStr);
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getInt(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        if (fieldType == null) {
            return sqlArg;
        }
        Integer valInteger = (Integer)sqlArg;
        Map enumIntMap = (Map)fieldType.getDataTypeConfigObj();
        if (enumIntMap == null) {
            return EnumIntegerType.enumVal(fieldType, valInteger, null, fieldType.getUnknownEnumVal());
        }
        return EnumIntegerType.enumVal(fieldType, valInteger, (Enum)enumIntMap.get(valInteger), fieldType.getUnknownEnumVal());
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        Enum enumVal = (Enum)obj;
        return enumVal.ordinal();
    }

    @Override
    public boolean isEscapedValue() {
        return false;
    }

    @Override
    public Object makeConfigObject(FieldType fieldType) throws SQLException {
        HashMap<Integer, Enum> enumIntMap = new HashMap<Integer, Enum>();
        Enum[] constants = (Enum[])fieldType.getType().getEnumConstants();
        if (constants == null) {
            throw new SQLException("Could not get enum-constants for field " + fieldType);
        }
        for (Enum enumVal : constants) {
            enumIntMap.put(enumVal.ordinal(), enumVal);
        }
        return enumIntMap;
    }

    @Override
    public Class<?> getPrimaryClass() {
        return Integer.TYPE;
    }
}

