/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.ObjectCache;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.SqlType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.jdbc.JdbcDatabaseResults;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.jdbc.TypeValMapper;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.misc.IOUtils;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt.StatementBuilder;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.support.CompiledStatement;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.support.DatabaseResults;

public class JdbcCompiledStatement
implements CompiledStatement {
    private final PreparedStatement preparedStatement;
    private final String statement;
    private final StatementBuilder.StatementType type;
    private final boolean cacheStore;
    private ResultSetMetaData metaData = null;

    public JdbcCompiledStatement(PreparedStatement preparedStatement, String statement, StatementBuilder.StatementType type, boolean cacheStore) {
        this.preparedStatement = preparedStatement;
        this.statement = statement;
        this.type = type;
        this.cacheStore = cacheStore;
    }

    @Override
    public int getColumnCount() throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.preparedStatement.getMetaData();
        }
        return this.metaData.getColumnCount();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.preparedStatement.getMetaData();
        }
        return this.metaData.getColumnName(column + 1);
    }

    @Override
    public int runUpdate() throws SQLException {
        if (!this.type.isOkForUpdate()) {
            throw new IllegalArgumentException("Cannot call update on a " + (Object)((Object)this.type) + " statement");
        }
        return this.preparedStatement.executeUpdate();
    }

    @Override
    public DatabaseResults runQuery(ObjectCache objectCache) throws SQLException {
        if (!this.type.isOkForQuery()) {
            throw new IllegalArgumentException("Cannot call query on a " + (Object)((Object)this.type) + " statement");
        }
        return new JdbcDatabaseResults(this.preparedStatement, this.preparedStatement.executeQuery(), objectCache, this.cacheStore);
    }

    @Override
    public int runExecute() throws SQLException {
        if (!this.type.isOkForExecute()) {
            throw new IllegalArgumentException("Cannot call execute on a " + (Object)((Object)this.type) + " statement");
        }
        this.preparedStatement.execute();
        return this.preparedStatement.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        try {
            this.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new SQLException("could not close prepared statement", e);
        }
    }

    @Override
    public void closeQuietly() {
        IOUtils.closeQuietly(this);
    }

    @Override
    public void cancel() throws SQLException {
        this.preparedStatement.cancel();
    }

    @Override
    public void setObject(int parameterIndex, Object obj, SqlType sqlType) throws SQLException {
        if (obj == null) {
            this.preparedStatement.setNull(parameterIndex + 1, TypeValMapper.getTypeValForSqlType(sqlType));
        } else {
            this.preparedStatement.setObject(parameterIndex + 1, obj, TypeValMapper.getTypeValForSqlType(sqlType));
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.preparedStatement.setMaxRows(max);
    }

    @Override
    public void setQueryTimeout(long millis) throws SQLException {
        this.preparedStatement.setQueryTimeout(Long.valueOf(millis).intValue() / 1000);
    }

    @Override
    public String getStatement() {
        return this.statement;
    }

    public String toString() {
        return this.statement;
    }

    boolean getMoreResults() throws SQLException {
        return this.preparedStatement.getMoreResults();
    }
}

