/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.jdbc.db;

import java.util.List;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.db.BaseDatabaseType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.FieldType;

public class H2DatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "h2";
    private static final String DRIVER_CLASS_NAME = "org.h2.Driver";
    private static final String DATABASE_NAME = "H2";

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    @Override
    protected String[] getDriverClassNames() {
        return new String[]{DRIVER_CLASS_NAME};
    }

    @Override
    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    @Override
    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("AUTO_INCREMENT ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    public void appendLimitValue(StringBuilder sb, long limit, Long offset) {
        sb.append("LIMIT ");
        if (offset != null) {
            sb.append(offset).append(',');
        }
        sb.append(limit).append(' ');
    }

    @Override
    public boolean isOffsetLimitArgument() {
        return true;
    }

    @Override
    public void appendOffsetValue(StringBuilder sb, long offset) {
        throw new IllegalStateException("Offset is part of the LIMIT in database type " + this.getClass());
    }

    @Override
    public boolean isTruncateSupported() {
        return true;
    }

    @Override
    public boolean isCreateIfNotExistsSupported() {
        return true;
    }

    @Override
    public boolean isLimitUpdateAtEndSupported() {
        return true;
    }

    @Override
    public boolean isLimitDeleteAtEndSupported() {
        return true;
    }
}

