/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger.Level;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger.LogBackend;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger.LogBackendFactory;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger.LoggerFactory;

public class LocalLogBackend
implements LogBackend {
    public static final String LOCAL_LOG_LEVEL_PROPERTY = "com.j256.simplelogging.level";
    public static final String LOCAL_LOG_FILE_PROPERTY = "com.j256.simplelogging.file";
    public static final String LOCAL_LOG_PROPERTIES_FILE = "/ormliteLocalLog.properties";
    private static final Level DEFAULT_LEVEL = Level.DEBUG;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private static PrintStream printStream;
    private static final List<PatternLevel> classLevels;
    private final String className;
    private final Level level;

    public LocalLogBackend(String className) {
        this.className = LoggerFactory.getSimpleClassName(className);
        Level level = null;
        if (classLevels != null) {
            for (PatternLevel patternLevel : classLevels) {
                if (!patternLevel.pattern.matcher(className).matches() || level != null && patternLevel.level.ordinal() >= level.ordinal()) continue;
                level = patternLevel.level;
            }
        }
        if (level == null) {
            String levelName = System.getProperty(LOCAL_LOG_LEVEL_PROPERTY);
            if (levelName == null) {
                level = DEFAULT_LEVEL;
            } else {
                Level matchedLevel;
                try {
                    matchedLevel = Level.valueOf(levelName.toUpperCase());
                }
                catch (IllegalArgumentException e1) {
                    try {
                        matchedLevel = Level.valueOf(levelName.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException e2) {
                        throw new IllegalArgumentException("Level '" + levelName + "' was not found", e2);
                    }
                }
                level = matchedLevel;
            }
        }
        this.level = level;
    }

    public static void openLogFile(String logPath) {
        if (logPath == null) {
            printStream = System.out;
        } else {
            try {
                printStream = new PrintStream(new File(logPath));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Log file " + logPath + " was not found", e);
            }
        }
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        return this.level.isEnabled(level);
    }

    @Override
    public void log(Level level, String msg) {
        this.printMessage(level, msg, null);
    }

    @Override
    public void log(Level level, String msg, Throwable throwable) {
        this.printMessage(level, msg, throwable);
    }

    void flush() {
        printStream.flush();
    }

    static List<PatternLevel> readLevelResourceFile(InputStream stream) {
        List<PatternLevel> levels = null;
        if (stream != null) {
            try {
                levels = LocalLogBackend.configureClassLevels(stream);
            }
            catch (IOException e) {
                System.err.println("IO exception reading the log properties file '/ormliteLocalLog.properties': " + e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return levels;
    }

    private static List<PatternLevel> configureClassLevels(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        ArrayList<PatternLevel> list = new ArrayList<PatternLevel>();
        while ((line = reader.readLine()) != null) {
            Level level;
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            String[] parts = line.split("=");
            if (parts.length != 2) {
                System.err.println("Line is not in the format of 'pattern = level': " + line);
                continue;
            }
            Pattern pattern = Pattern.compile(parts[0].trim());
            try {
                level = Level.valueOf(parts[1].trim());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Level '" + parts[1] + "' was not found");
                continue;
            }
            list.add(new PatternLevel(pattern, level));
        }
        return list;
    }

    private void printMessage(Level level, String message, Throwable throwable) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        DateFormat dateFormat = (DateFormat)DATE_FORMAT.clone();
        sb.append(dateFormat.format(new Date()));
        sb.append(" [").append(level.name()).append("] ");
        sb.append(this.className).append(' ');
        sb.append(message);
        printStream.println(sb.toString());
        if (throwable != null) {
            throwable.printStackTrace(printStream);
        }
    }

    static {
        InputStream stream = LocalLogBackend.class.getResourceAsStream(LOCAL_LOG_PROPERTIES_FILE);
        List<PatternLevel> levels = LocalLogBackend.readLevelResourceFile(stream);
        classLevels = levels;
        String logPath = System.getProperty(LOCAL_LOG_FILE_PROPERTY);
        LocalLogBackend.openLogFile(logPath);
    }

    private static class PatternLevel {
        Pattern pattern;
        Level level;

        public PatternLevel(Pattern pattern, Level level) {
            this.pattern = pattern;
            this.level = level;
        }
    }

    public static class LocalLogBackendFactory
    implements LogBackendFactory {
        private final AtomicReference<String> queuedWarning = new AtomicReference();

        public LocalLogBackendFactory() {
        }

        public LocalLogBackendFactory(String queuedWarning) {
            this.queuedWarning.set(queuedWarning);
        }

        @Override
        public LogBackend createLogBackend(String classLabel) {
            LocalLogBackend backend = new LocalLogBackend(classLabel);
            String queuedWarning = this.queuedWarning.getAndSet(null);
            if (queuedWarning != null) {
                backend.log(Level.WARNING, queuedWarning);
            }
            return backend;
        }
    }
}

