/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger;

import java.lang.reflect.Array;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger.Level;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger.LogBackend;

public class Logger {
    private static Level globalLevel;
    private static final String ARG_STRING = "{}";
    private static final int ARG_STRING_LENGTH;
    private static final Object UNKNOWN_ARG;
    private static final int DEFAULT_FULL_MESSAGE_LENGTH = 128;
    private final LogBackend backend;

    public Logger(LogBackend backend) {
        this.backend = backend;
    }

    public static void setGlobalLogLevel(Level level) {
        globalLevel = level;
    }

    public boolean isLevelEnabled(Level level) {
        return this.backend.isLevelEnabled(level);
    }

    public void trace(String msg) {
        this.logIfEnabled(Level.TRACE, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void trace(String msg, Object arg0) {
        this.logIfEnabled(Level.TRACE, null, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void trace(String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.TRACE, null, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void trace(String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.TRACE, null, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void trace(String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.TRACE, null, msg, arg0, arg1, arg2, arg3, null);
    }

    public void trace(String msg, Object[] argArray) {
        this.logIfEnabled(Level.TRACE, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void trace(Throwable throwable, String msg) {
        this.logIfEnabled(Level.TRACE, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null, null);
    }

    public void trace(Throwable throwable, String msg, Object arg0) {
        this.logIfEnabled(Level.TRACE, throwable, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void trace(Throwable throwable, String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.TRACE, throwable, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void trace(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.TRACE, throwable, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void trace(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.TRACE, throwable, msg, arg0, arg1, arg2, arg3, null);
    }

    public void trace(Throwable throwable, String msg, Object[] argArray) {
        this.logIfEnabled(Level.TRACE, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void debug(String msg) {
        this.logIfEnabled(Level.DEBUG, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void debug(String msg, Object arg0) {
        this.logIfEnabled(Level.DEBUG, null, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void debug(String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.DEBUG, null, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void debug(String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.DEBUG, null, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void debug(String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.DEBUG, null, msg, arg0, arg1, arg2, arg3, null);
    }

    public void debug(String msg, Object[] argArray) {
        this.logIfEnabled(Level.DEBUG, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void debug(Throwable throwable, String msg) {
        this.logIfEnabled(Level.DEBUG, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void debug(Throwable throwable, String msg, Object arg0) {
        this.logIfEnabled(Level.DEBUG, throwable, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void debug(Throwable throwable, String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.DEBUG, throwable, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void debug(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.DEBUG, throwable, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void debug(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.DEBUG, throwable, msg, arg0, arg1, arg2, arg3, null);
    }

    public void debug(Throwable throwable, String msg, Object[] argArray) {
        this.logIfEnabled(Level.DEBUG, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void info(String msg) {
        this.logIfEnabled(Level.INFO, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void info(String msg, Object arg0) {
        this.logIfEnabled(Level.INFO, null, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void info(String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.INFO, null, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void info(String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.INFO, null, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void info(String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.INFO, null, msg, arg0, arg1, arg2, arg3, null);
    }

    public void info(String msg, Object[] argArray) {
        this.logIfEnabled(Level.INFO, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void info(Throwable throwable, String msg) {
        this.logIfEnabled(Level.INFO, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void info(Throwable throwable, String msg, Object arg0) {
        this.logIfEnabled(Level.INFO, throwable, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void info(Throwable throwable, String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.INFO, throwable, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void info(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.INFO, throwable, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void info(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.INFO, throwable, msg, arg0, arg1, arg2, arg3, null);
    }

    public void info(Throwable throwable, String msg, Object[] argArray) {
        this.logIfEnabled(Level.INFO, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void warn(String msg) {
        this.logIfEnabled(Level.WARNING, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void warn(String msg, Object arg0) {
        this.logIfEnabled(Level.WARNING, null, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void warn(String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.WARNING, null, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void warn(String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.WARNING, null, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void warn(String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.WARNING, null, msg, arg0, arg1, arg2, arg3, null);
    }

    public void warn(String msg, Object[] argArray) {
        this.logIfEnabled(Level.WARNING, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void warn(Throwable throwable, String msg) {
        this.logIfEnabled(Level.WARNING, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void warn(Throwable throwable, String msg, Object arg0) {
        this.logIfEnabled(Level.WARNING, throwable, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void warn(Throwable throwable, String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.WARNING, throwable, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void warn(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.WARNING, throwable, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void warn(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.WARNING, throwable, msg, arg0, arg1, arg2, arg3, null);
    }

    public void warn(Throwable throwable, String msg, Object[] argArray) {
        this.logIfEnabled(Level.WARNING, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void error(String msg) {
        this.logIfEnabled(Level.ERROR, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void error(String msg, Object arg0) {
        this.logIfEnabled(Level.ERROR, null, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void error(String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.ERROR, null, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void error(String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.ERROR, null, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void error(String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.ERROR, null, msg, arg0, arg1, arg2, arg3, null);
    }

    public void error(String msg, Object[] argArray) {
        this.logIfEnabled(Level.ERROR, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void error(Throwable throwable, String msg) {
        this.logIfEnabled(Level.ERROR, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void error(Throwable throwable, String msg, Object arg0) {
        this.logIfEnabled(Level.ERROR, throwable, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void error(Throwable throwable, String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.ERROR, throwable, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void error(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.ERROR, throwable, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void error(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.ERROR, throwable, msg, arg0, arg1, arg2, arg3, null);
    }

    public void error(Throwable throwable, String msg, Object[] argArray) {
        this.logIfEnabled(Level.ERROR, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void fatal(String msg) {
        this.logIfEnabled(Level.FATAL, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void fatal(String msg, Object arg0) {
        this.logIfEnabled(Level.FATAL, null, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void fatal(String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.FATAL, null, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void fatal(String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.FATAL, null, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void fatal(String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.FATAL, null, msg, arg0, arg1, arg2, arg3, null);
    }

    public void fatal(String msg, Object[] argArray) {
        this.logIfEnabled(Level.FATAL, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void fatal(Throwable throwable, String msg) {
        this.logIfEnabled(Level.FATAL, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void fatal(Throwable throwable, String msg, Object arg0) {
        this.logIfEnabled(Level.FATAL, throwable, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void fatal(Throwable throwable, String msg, Object arg0, Object arg1) {
        this.logIfEnabled(Level.FATAL, throwable, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void fatal(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(Level.FATAL, throwable, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void fatal(Throwable throwable, String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(Level.FATAL, throwable, msg, arg0, arg1, arg2, arg3, null);
    }

    public void fatal(Throwable throwable, String msg, Object[] argArray) {
        this.logIfEnabled(Level.FATAL, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void log(Level level, String msg) {
        this.logIfEnabled(level, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void log(Level level, String msg, Object arg0) {
        this.logIfEnabled(level, null, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void log(Level level, String msg, Object arg0, Object arg1) {
        this.logIfEnabled(level, null, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void log(Level level, String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(level, null, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void log(Level level, String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(level, null, msg, arg0, arg1, arg2, arg3, null);
    }

    public void log(Level level, String msg, Object[] argArray) {
        this.logIfEnabled(level, null, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public void log(Level level, Throwable throwable, String msg) {
        this.logIfEnabled(level, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void log(Level level, Throwable throwable, String msg, Object arg0) {
        this.logIfEnabled(level, throwable, msg, arg0, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void log(Level level, Throwable throwable, String msg, Object arg0, Object arg1) {
        this.logIfEnabled(level, throwable, msg, arg0, arg1, UNKNOWN_ARG, UNKNOWN_ARG, null);
    }

    public void log(Level level, Throwable throwable, String msg, Object arg0, Object arg1, Object arg2) {
        this.logIfEnabled(level, throwable, msg, arg0, arg1, arg2, UNKNOWN_ARG, null);
    }

    public void log(Level level, Throwable throwable, String msg, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.logIfEnabled(level, throwable, msg, arg0, arg1, arg2, arg3, null);
    }

    public void log(Level level, Throwable throwable, String msg, Object[] argArray) {
        this.logIfEnabled(level, throwable, msg, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, UNKNOWN_ARG, argArray);
    }

    public LogBackend getLogBackend() {
        return this.backend;
    }

    private void logIfEnabled(Level level, Throwable throwable, String msg, Object arg0, Object arg1, Object arg2, Object arg3, Object[] argArray) {
        if ((globalLevel == null || globalLevel.isEnabled(level)) && this.backend.isLevelEnabled(level)) {
            String fullMsg = this.buildFullMessage(msg, arg0, arg1, arg2, arg3, argArray);
            if (throwable == null) {
                this.backend.log(level, fullMsg);
            } else {
                this.backend.log(level, fullMsg, throwable);
            }
        }
    }

    private String buildFullMessage(String msg, Object arg0, Object arg1, Object arg2, Object arg3, Object[] argArray) {
        int argIndex;
        StringBuilder sb = null;
        int lastIndex = 0;
        int argC = 0;
        while ((argIndex = msg.indexOf(ARG_STRING, lastIndex)) != -1) {
            if (sb == null) {
                sb = new StringBuilder(128);
            }
            sb.append(msg, lastIndex, argIndex);
            lastIndex = argIndex + ARG_STRING_LENGTH;
            if (argArray == null) {
                if (argC == 0) {
                    this.appendArg(sb, arg0);
                } else if (argC == 1) {
                    this.appendArg(sb, arg1);
                } else if (argC == 2) {
                    this.appendArg(sb, arg2);
                } else if (argC == 3) {
                    this.appendArg(sb, arg3);
                }
            } else if (argC < argArray.length) {
                this.appendArg(sb, argArray[argC]);
            }
            ++argC;
        }
        if (sb == null) {
            return msg;
        }
        sb.append(msg, lastIndex, msg.length());
        return sb.toString();
    }

    private void appendArg(StringBuilder sb, Object arg) {
        if (arg != UNKNOWN_ARG) {
            if (arg == null) {
                sb.append("null");
            } else if (arg.getClass().isArray()) {
                sb.append('[');
                int length = Array.getLength(arg);
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    this.appendArg(sb, Array.get(arg, i));
                }
                sb.append(']');
            } else {
                sb.append(arg.toString());
            }
        }
    }

    static {
        ARG_STRING_LENGTH = ARG_STRING.length();
        UNKNOWN_ARG = new Object();
    }
}

