/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger;

import net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger.Level;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger.LocalLogBackend;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger.LogBackendFactory;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger.LogBackendType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.logger.Logger;

public class LoggerFactory {
    public static final String LOG_TYPE_SYSTEM_PROPERTY = "com.j256.simplelogger.backend";
    private static LogBackendFactory logBackendFactory;

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String className) {
        if (logBackendFactory == null) {
            logBackendFactory = LoggerFactory.findLogBackendFactory();
        }
        return new Logger(logBackendFactory.createLogBackend(className));
    }

    public static LogBackendFactory getLogBackendFactory() {
        return logBackendFactory;
    }

    public static void setLogBackendFactory(LogBackendFactory LogBackendFactory2) {
        logBackendFactory = LogBackendFactory2;
    }

    public static void setLogBackendType(LogBackendType type) {
        if (!type.isAvailable()) {
            throw new IllegalArgumentException("Logging backend type " + type + " is not available on the classpath");
        }
        logBackendFactory = type;
    }

    public static String getSimpleClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index < 0 || index == className.length() - 1) {
            return className;
        }
        return className.substring(index + 1);
    }

    private static LogBackendFactory findLogBackendFactory() {
        String logTypeString = System.getProperty(LOG_TYPE_SYSTEM_PROPERTY);
        if (logTypeString != null) {
            try {
                return LogBackendType.valueOf(logTypeString);
            }
            catch (IllegalArgumentException e) {
                LocalLogBackend backend = new LocalLogBackend(LoggerFactory.class.getName());
                backend.log(Level.WARNING, "Could not find valid log-type from system property 'com.j256.simplelogger.backend', value '" + logTypeString + "'");
            }
        }
        for (LogBackendType logType : LogBackendType.values()) {
            if (!logType.isAvailable()) continue;
            return logType;
        }
        return LogBackendType.LOCAL;
    }
}

