/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt;

import java.sql.SQLException;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.FieldType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.SqlType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt.ArgumentHolder;

public abstract class BaseArgumentHolder
implements ArgumentHolder {
    private String columnName = null;
    private FieldType fieldType = null;
    private SqlType sqlType = null;

    public BaseArgumentHolder() {
    }

    public BaseArgumentHolder(String columName) {
        this.columnName = columName;
    }

    public BaseArgumentHolder(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    protected abstract Object getValue();

    @Override
    public abstract void setValue(Object var1);

    protected abstract boolean isValueSet();

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public void setMetaInfo(String columnName) {
        if (this.columnName != null && !this.columnName.equals(columnName)) {
            throw new IllegalArgumentException("Column name cannot be set twice from " + this.columnName + " to " + columnName + ".  Using a SelectArg twice in query with different columns?");
        }
        this.columnName = columnName;
    }

    @Override
    public void setMetaInfo(FieldType fieldType) {
        if (this.fieldType != null && this.fieldType != fieldType) {
            throw new IllegalArgumentException("FieldType name cannot be set twice from " + this.fieldType + " to " + fieldType + ".  Using a SelectArg twice in query with different columns?");
        }
        this.fieldType = fieldType;
    }

    @Override
    public void setMetaInfo(String columnName, FieldType fieldType) {
        this.setMetaInfo(columnName);
        this.setMetaInfo(fieldType);
    }

    @Override
    public Object getSqlArgValue() throws SQLException {
        if (!this.isValueSet()) {
            throw new SQLException("Column value has not been set for " + this.columnName);
        }
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (this.fieldType == null) {
            return value;
        }
        if (this.fieldType.isForeign() && this.fieldType.getType() == value.getClass()) {
            FieldType refFieldType = this.fieldType.getForeignRefField();
            return refFieldType.extractJavaFieldValue(value);
        }
        return this.fieldType.convertJavaFieldToSqlArgValue(value);
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public String toString() {
        if (!this.isValueSet()) {
            return "[unset]";
        }
        try {
            Object val = this.getSqlArgValue();
            if (val == null) {
                return "[null]";
            }
            return val.toString();
        }
        catch (SQLException e) {
            return "[could not get value: " + e + "]";
        }
    }
}

