/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt;

import java.sql.SQLException;
import java.util.List;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.Dao;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.db.DatabaseType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt.ArgumentHolder;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt.PreparedDelete;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt.StatementBuilder;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.table.TableInfo;

public class DeleteBuilder<T, ID>
extends StatementBuilder<T, ID> {
    private Long limit;

    public DeleteBuilder(DatabaseType databaseType, TableInfo<T, ID> tableInfo, Dao<T, ID> dao) {
        super(databaseType, tableInfo, dao, StatementBuilder.StatementType.DELETE);
    }

    public PreparedDelete<T> prepare() throws SQLException {
        return super.prepareStatement(this.limit, false);
    }

    public int delete() throws SQLException {
        return this.dao.delete(this.prepare());
    }

    public DeleteBuilder<T, ID> limit(Long maxRows) {
        this.limit = maxRows;
        return this;
    }

    @Override
    public void reset() {
        super.reset();
        this.limit = null;
    }

    @Override
    protected void appendStatementStart(StringBuilder sb, List<ArgumentHolder> argList) {
        sb.append("DELETE FROM ");
        if (this.tableInfo.getSchemaName() != null && this.tableInfo.getSchemaName().length() > 0) {
            this.databaseType.appendEscapedEntityName(sb, this.tableInfo.getSchemaName());
            sb.append('.');
        }
        if (this.databaseType.isLimitAfterDeleteSupported()) {
            this.appendLimit(sb);
        }
        this.databaseType.appendEscapedEntityName(sb, this.tableInfo.getTableName());
        sb.append(' ');
    }

    @Override
    protected void appendStatementEnd(StringBuilder sb, List<ArgumentHolder> argList) {
        if (this.databaseType.isLimitDeleteAtEndSupported()) {
            this.appendLimit(sb);
        }
    }

    private void appendLimit(StringBuilder sb) {
        if (this.limit != null) {
            this.databaseType.appendUpdateLimitValue(sb, this.limit);
        }
    }
}

