/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt.mapped;

import java.sql.SQLException;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.Dao;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.dao.ObjectCache;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.db.DatabaseType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.field.FieldType;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.stmt.mapped.BaseMappedStatement;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.support.DatabaseConnection;
import net.elytrium.limboauth.thirdparty.com.j256.ormlite.table.TableInfo;

public class MappedUpdateId<T, ID>
extends BaseMappedStatement<T, ID> {
    private MappedUpdateId(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes) {
        super(dao, tableInfo, statement, argFieldTypes);
    }

    public int execute(DatabaseConnection databaseConnection, T data, ID newId, ObjectCache objectCache) throws SQLException {
        try {
            Object[] args = new Object[]{this.convertIdToFieldObject(newId), this.extractIdToFieldObject(data)};
            int rowC = databaseConnection.update(this.statement, args, this.argFieldTypes);
            if (rowC > 0) {
                Object oldId;
                Object obj;
                if (objectCache != null && (obj = objectCache.updateId(this.clazz, oldId = this.idField.extractJavaFieldValue(data), newId)) != null && obj != data) {
                    this.idField.assignField(this.connectionSource, obj, newId, false, objectCache);
                }
                this.idField.assignField(this.connectionSource, data, newId, false, objectCache);
            }
            logger.debug("updating-id with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)args.length, (Object)rowC);
            if (args.length > 0) {
                logger.trace("updating-id arguments: {}", (Object)args);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw new SQLException("Unable to run update-id stmt on object " + data + ": " + this.statement, e);
        }
    }

    public static <T, ID> MappedUpdateId<T, ID> build(Dao<T, ID> dao, TableInfo<T, ID> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot update-id in " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        StringBuilder sb = new StringBuilder(64);
        DatabaseType databaseType = dao.getConnectionSource().getDatabaseType();
        MappedUpdateId.appendTableName(databaseType, sb, "UPDATE ", tableInfo);
        sb.append("SET ");
        MappedUpdateId.appendFieldColumnName(databaseType, sb, idField, null);
        sb.append("= ? ");
        MappedUpdateId.appendWhereFieldEq(databaseType, idField, sb, null);
        return new MappedUpdateId<T, ID>(dao, tableInfo, sb.toString(), new FieldType[]{idField, idField});
    }

    private Object extractIdToFieldObject(T data) throws SQLException {
        return this.idField.extractJavaFieldToSqlArgValue(data);
    }
}

