/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.cache.captcha;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.elytrium.limboapi.api.LimboFactory;
import net.elytrium.limboapi.api.protocol.PreparedPacket;
import net.elytrium.limboapi.api.protocol.packets.data.MapPalette;
import net.elytrium.limbofilter.LimboFilter;
import net.elytrium.limbofilter.Settings;
import net.elytrium.limbofilter.captcha.CaptchaHolder;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class CachedCaptcha {
    private final LimboFilter plugin;
    private final AtomicInteger threadIdCounter = new AtomicInteger(0);
    private final ThreadLocal<Integer> threadId = ThreadLocal.withInitial(this.threadIdCounter::getAndIncrement);
    private final CaptchaHolder[] firstHolders;
    private final CaptchaHolder[] lastHolders;
    private @MonotonicNonNull CaptchaHolder firstHolder;
    private @MonotonicNonNull CaptchaHolder lastHolder;
    private ThreadLocal<CaptchaHolder> captchaIterator;
    private boolean disposed;

    public CachedCaptcha(LimboFilter plugin, int threadsCount) {
        this.plugin = plugin;
        this.firstHolders = new CaptchaHolder[threadsCount];
        this.lastHolders = new CaptchaHolder[threadsCount];
    }

    public void addCaptchaPacket(String answer, MinecraftPacket[] mapDataPackets17, Function<MapPalette.MapVersion, MinecraftPacket[]> mapDataPacket) {
        CaptchaHolder holder;
        if (this.disposed) {
            return;
        }
        int threadId = this.threadId.get();
        boolean isFirst = this.firstHolders[threadId] == null;
        this.firstHolders[threadId] = holder = this.getCaptchaHolder(answer, this.firstHolders[threadId], mapDataPackets17, mapDataPacket);
        if (isFirst) {
            this.lastHolders[threadId] = holder;
        }
    }

    private CaptchaHolder getCaptchaHolder(String answer, CaptchaHolder next, MinecraftPacket[] mapDataPackets17, Function<MapPalette.MapVersion, MinecraftPacket[]> mapDataPacket) {
        MinecraftPacket[][] mapDataPacketEnum = new MinecraftPacket[ProtocolVersion.values().length][];
        LimboFactory limboFactory = this.plugin.getLimboFactory();
        ProtocolVersion prepareMinVersion = limboFactory.getPrepareMinVersion();
        ProtocolVersion prepareMaxVersion = limboFactory.getPrepareMaxVersion();
        block0: for (MapPalette.MapVersion version2 : MapPalette.MapVersion.values()) {
            for (ProtocolVersion mapProtocolVersion : version2.getVersions()) {
                if (prepareMinVersion.compareTo((Enum)mapProtocolVersion) > 0 || prepareMaxVersion.compareTo((Enum)mapProtocolVersion) < 0) continue;
                MinecraftPacket[] packets = mapDataPacket.apply(version2);
                version2.getVersions().forEach(protocolVersion -> {
                    mapDataPacketEnum[protocolVersion.ordinal()] = packets;
                });
                continue block0;
            }
        }
        if (Settings.IMP.MAIN.CAPTCHA_GENERATOR.PREPARE_CAPTCHA_PACKETS) {
            PreparedPacket prepared = this.plugin.getLimboFactory().createPreparedPacket();
            if (Settings.IMP.MAIN.FRAMED_CAPTCHA.FRAMED_CAPTCHA_ENABLED) {
                int i = 0;
                while (i < Settings.IMP.MAIN.FRAMED_CAPTCHA.WIDTH * Settings.IMP.MAIN.FRAMED_CAPTCHA.HEIGHT) {
                    int index = i++;
                    prepared.prepare(version -> mapDataPacketEnum[version.ordinal()][index], ProtocolVersion.MINECRAFT_1_8);
                }
            } else {
                prepared.prepare(version -> mapDataPacketEnum[version.ordinal()][0], ProtocolVersion.MINECRAFT_1_8);
            }
            return new CaptchaHolder(answer, next, prepared.prepare((Object[])mapDataPackets17, ProtocolVersion.MINECRAFT_1_7_2, ProtocolVersion.MINECRAFT_1_7_6).build());
        }
        return new CaptchaHolder(answer, next, mapDataPackets17, mapDataPacketEnum);
    }

    public void build() {
        int lastHolderIndex = this.firstHolders.length - 1;
        int i = 0;
        while (i < lastHolderIndex) {
            this.lastHolders[i].setNext(this.firstHolders[++i]);
        }
        this.firstHolder = this.firstHolders[0];
        this.lastHolder = this.lastHolders[lastHolderIndex];
        this.lastHolder.setNext(this.firstHolder);
        this.threadIdCounter.set(0);
        this.captchaIterator = ThreadLocal.withInitial(() -> new CaptchaHolder(this.firstHolders[this.threadId.get() % this.firstHolders.length]));
    }

    public CaptchaHolder getNextCaptcha() {
        if (this.captchaIterator == null) {
            return null;
        }
        CaptchaHolder holder = this.captchaIterator.get();
        this.captchaIterator.set(holder.getNext());
        return holder;
    }

    public void dispose() {
        this.disposed = true;
        if (this.firstHolder == null) {
            for (CaptchaHolder holder : this.firstHolders) {
                this.dispose(holder);
            }
        } else {
            this.dispose(this.firstHolder);
        }
    }

    private void dispose(CaptchaHolder next) {
        do {
            CaptchaHolder currentHolder = next;
            next = next.getNext();
            currentHolder.release();
        } while (next != null);
    }
}

