/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.captcha.painter;

import net.elytrium.limbofilter.captcha.painter.CaptchaEffect;

public class OutlineEffect
implements CaptchaEffect {
    private final int borderRadius;

    public OutlineEffect(int borderRadius) {
        this.borderRadius = borderRadius;
    }

    @Override
    public void filter(int width, int height, byte[] src, byte[] dest) {
        for (int x = this.borderRadius; x < width - this.borderRadius; ++x) {
            for (int y = this.borderRadius; y < height - this.borderRadius; ++y) {
                if (src[y * width + x] == 0) continue;
                boolean found = false;
                for (int blurX = x - this.borderRadius; blurX <= x + this.borderRadius; ++blurX) {
                    for (int blurY = y - this.borderRadius; blurY <= y + this.borderRadius; ++blurY) {
                        if (src[blurY * width + blurX] != 0) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                dest[y * width + x] = found ? (byte)(src[y * width + x] & 0xFFFFFFFC) : src[y * width + x];
            }
        }
    }

    @Override
    public boolean shouldCopy() {
        return false;
    }
}

