/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.limbofilter.protocol.data;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.elytrium.limboapi.api.material.VirtualItem;
import net.elytrium.limboapi.api.protocol.item.ItemComponentMap;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;

public class EntityMetadata {
    private final Map<Byte, Entry> entries;

    public EntityMetadata(Map<Byte, Entry> entries) {
        this.entries = entries;
    }

    public void encode(ByteBuf buf, ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) <= 0) {
            this.entries.forEach((index, value) -> {
                buf.writeByte(index & 0x1F | value.getType(protocolVersion) << 5);
                value.encode(buf, protocolVersion);
            });
            buf.writeByte(127);
        } else {
            this.entries.forEach((index, value) -> {
                buf.writeByte((int)index.byteValue());
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)value.getType(protocolVersion));
                value.encode(buf, protocolVersion);
            });
            buf.writeByte(255);
        }
    }

    public static interface Entry {
        public void encode(ByteBuf var1, ProtocolVersion var2);

        public int getType(ProtocolVersion var1);
    }

    public static class ByteEntry
    implements Entry {
        private final int value;

        public ByteEntry(int value) {
            this.value = value;
        }

        @Override
        public void encode(ByteBuf buf, ProtocolVersion protocolVersion) {
            buf.writeByte(this.value);
        }

        @Override
        public int getType(ProtocolVersion protocolVersion) {
            return 0;
        }
    }

    public static class VarIntEntry
    implements Entry {
        private final int value;

        public VarIntEntry(int value) {
            this.value = value;
        }

        @Override
        public void encode(ByteBuf buf, ProtocolVersion protocolVersion) {
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) <= 0) {
                buf.writeInt(this.value);
            } else {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.value);
            }
        }

        @Override
        public int getType(ProtocolVersion protocolVersion) {
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) <= 0) {
                return 2;
            }
            return 1;
        }
    }

    public static class SlotEntry
    implements Entry {
        private final boolean present;
        private final VirtualItem item;
        private final int count;
        private final int data;
        private final CompoundBinaryTag nbt;
        private final ItemComponentMap map;

        public SlotEntry(boolean present, VirtualItem item, int count, int data, CompoundBinaryTag nbt, ItemComponentMap map) {
            this.present = present;
            this.item = item;
            this.count = count;
            this.data = data;
            this.nbt = nbt;
            this.map = map;
        }

        public SlotEntry(VirtualItem item, int count, int data, CompoundBinaryTag nbt, ItemComponentMap map) {
            this(true, item, count, data, nbt, map);
        }

        public SlotEntry() {
            this(false, null, 0, 0, null, null);
        }

        @Override
        public void encode(ByteBuf buf, ProtocolVersion protocolVersion) {
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_20_5) >= 0) {
                this.encodeModern(buf, protocolVersion);
            } else {
                this.encodeLegacy(buf, protocolVersion);
            }
        }

        public void encodeModern(ByteBuf buf, ProtocolVersion protocolVersion) {
            short id = this.item.getID(protocolVersion);
            if (id == 0) {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
            } else {
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.count);
                ProtocolUtils.writeVarInt((ByteBuf)buf, (int)id);
                if (this.map != null) {
                    this.map.write(protocolVersion, (Object)buf);
                } else {
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)0);
                }
            }
        }

        public void encodeLegacy(ByteBuf buf, ProtocolVersion protocolVersion) {
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13_2) >= 0) {
                buf.writeBoolean(this.present);
            }
            if (!this.present && protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13_2) < 0) {
                buf.writeShort(-1);
            }
            if (this.present) {
                if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13_2) < 0) {
                    buf.writeShort((int)this.item.getID(protocolVersion));
                } else {
                    ProtocolUtils.writeVarInt((ByteBuf)buf, (int)this.item.getID(protocolVersion));
                }
                buf.writeByte(this.count);
                if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_13) < 0) {
                    buf.writeShort(this.data);
                }
                if (this.nbt == null) {
                    if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_8) < 0) {
                        buf.writeShort(-1);
                    } else {
                        buf.writeByte(0);
                    }
                } else {
                    ProtocolUtils.writeBinaryTag((ByteBuf)buf, (ProtocolVersion)protocolVersion, (BinaryTag)this.nbt);
                }
            }
        }

        @Override
        public int getType(ProtocolVersion protocolVersion) {
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_12_2) <= 0) {
                return 5;
            }
            if (protocolVersion.compareTo((Enum)ProtocolVersion.MINECRAFT_1_19_1) <= 0) {
                return 6;
            }
            return 7;
        }
    }
}

